/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.list;

import com.intellij.collaboration.ui.codereview.list.NamedCollection;
import com.intellij.collaboration.ui.codereview.list.ReviewListComponentFactory;
import com.intellij.collaboration.ui.codereview.list.ReviewListItemPresentation;
import com.intellij.collaboration.ui.codereview.list.TagPresentation;
import com.intellij.collaboration.ui.codereview.list.UserPresentation;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.ui.ColorHexUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBList;
import icons.CollaborationToolsIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestMergeableState;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestState;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bJ&\u0010\f\u001a\u0004\u0018\u00010\r2\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\"\u0010\f\u001a\u00020\r2\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\u0006\u0010\u000e\u001a\u00020\u0010H\u0002J\"\u0010\f\u001a\u00020\r2\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\u0006\u0010\u000e\u001a\u00020\u0011H\u0002J0\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00132\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J0\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00132\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0015H\u0002J\u001f\u0010!\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\"\u0010'\u001a\u00020(2\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\u0006\u0010)\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/list/GHPRListComponentFactory;", "", "listModel", "Ljavax/swing/ListModel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "(Ljavax/swing/ListModel;)V", "create", "Lcom/intellij/ui/components/JBList;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "createUserPresentation", "Lcom/intellij/collaboration/ui/codereview/list/UserPresentation;", "user", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "getAssigneesPresentation", "Lcom/intellij/collaboration/ui/codereview/list/NamedCollection;", "assignees", "", "getLabelPresentation", "Lcom/intellij/collaboration/ui/codereview/list/TagPresentation$Simple;", "label", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "getMergeableStatus", "Lcom/intellij/collaboration/ui/codereview/list/ReviewListItemPresentation$Status;", "mergeableState", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestMergeableState;", "getReviewersPresentation", "reviewRequests", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewRequest;", "getStateText", "Lcom/intellij/openapi/util/NlsSafe;", "state", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestState;", "isDraft", "", "presentPR", "Lcom/intellij/collaboration/ui/codereview/list/ReviewListItemPresentation$Simple;", "pr", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRListComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRListComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/ui/list/GHPRListComponentFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1549#2:95\n1620#2,3:96\n1549#2:99\n1620#2,3:100\n1603#2,9:103\n1855#2:112\n1856#2:114\n1612#2:115\n1549#2:116\n1620#2,3:117\n1#3:113\n*S KotlinDebug\n*F\n+ 1 GHPRListComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/ui/list/GHPRListComponentFactory\n*L\n43#1:95\n43#1:96,3\n73#1:99\n73#1:100,3\n78#1:103,9\n78#1:112\n78#1:114\n78#1:115\n80#1:116\n80#1:117,3\n78#1:113\n*E\n"})
public final class GHPRListComponentFactory {
    @NotNull
    private final ListModel<GHPullRequestShort> listModel;

    public GHPRListComponentFactory(@NotNull ListModel<GHPullRequestShort> listModel) {
        Intrinsics.checkNotNullParameter(listModel, (String)"listModel");
        this.listModel = listModel;
    }

    @NotNull
    public final JBList<GHPullRequestShort> create(@NotNull IconsProvider<String> avatarIconsProvider) {
        JBList jBList;
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        JBList it = jBList = new ReviewListComponentFactory(this.listModel).create((Function1)new Function1<GHPullRequestShort, ReviewListItemPresentation>(this, avatarIconsProvider){
            final /* synthetic */ GHPRListComponentFactory this$0;
            final /* synthetic */ IconsProvider<String> $avatarIconsProvider;
            {
                this.this$0 = $receiver;
                this.$avatarIconsProvider = $avatarIconsProvider;
                super(1);
            }

            @NotNull
            public final ReviewListItemPresentation invoke(@NotNull GHPullRequestShort it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (ReviewListItemPresentation)GHPRListComponentFactory.access$presentPR(this.this$0, this.$avatarIconsProvider, it);
            }
        });
        boolean bl = false;
        DataManager.registerDataProvider((JComponent)((JComponent)it), arg_0 -> GHPRListComponentFactory.create$lambda$1$lambda$0(it, arg_0));
        AnAction anAction = ActionManager.getInstance().getAction("Github.PullRequest.ToolWindow.List.Popup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup actionGroup = (ActionGroup)anAction;
        PopupHandler.installPopupMenu((JComponent)((JComponent)it), (ActionGroup)actionGroup, (String)"popup");
        ShortcutSet[] shortcutSetArray = new ShortcutSet[]{CommonShortcuts.ENTER, CommonShortcuts.DOUBLE_CLICK_1};
        CompositeShortcutSet shortcuts = new CompositeShortcutSet(shortcutSetArray);
        EmptyAction.registerWithShortcutSet((String)"Github.PullRequest.Show", (ShortcutSet)((ShortcutSet)shortcuts), (JComponent)((JComponent)it));
        return jBList;
    }

    /*
     * WARNING - void declaration
     */
    private final ReviewListItemPresentation.Simple presentPR(IconsProvider<String> avatarIconsProvider, GHPullRequestShort pr) {
        Collection<TagPresentation.Simple> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = pr.getTitle();
        String string2 = "#" + pr.getNumber();
        Date date = pr.getCreatedAt();
        UserPresentation userPresentation = this.createUserPresentation(avatarIconsProvider, pr.getAuthor());
        Object[] objectArray = new Object[]{pr.getLabels().size()};
        String string3 = GithubBundle.message("pull.request.labels.popup", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"pull.request.la\u2026s.popup\", pr.labels.size)");
        Iterable iterable = pr.getLabels();
        String string4 = string3;
        NamedCollection.Companion companion = NamedCollection.Companion;
        UserPresentation userPresentation2 = userPresentation;
        Date date2 = date;
        String string5 = string2;
        String string6 = string;
        boolean $i$f$map = false;
        void var5_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            GHLabel gHLabel = (GHLabel)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getLabelPresentation((GHLabel)p0));
        }
        collection = (List)destination$iv$iv;
        NamedCollection namedCollection = companion.create(string4, (List)collection);
        ReviewListItemPresentation.Status status = this.getMergeableStatus(pr.getMergeable());
        String string7 = this.getStateText(pr.getState(), pr.isDraft());
        NamedCollection<UserPresentation> namedCollection2 = this.getAssigneesPresentation(avatarIconsProvider, pr.getAssignees());
        NamedCollection<UserPresentation> namedCollection3 = this.getReviewersPresentation(avatarIconsProvider, pr.getReviewRequests());
        int n = pr.getUnresolvedReviewThreadsCount();
        Object[] objectArray2 = new Object[]{pr.getUnresolvedReviewThreadsCount()};
        String string8 = GithubBundle.message("pull.request.unresolved.comments", objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(\"pull.request.un\u2026solvedReviewThreadsCount)");
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 64;
        ReviewListItemPresentation.CommentsCounter commentsCounter = new ReviewListItemPresentation.CommentsCounter(n, string8);
        NamedCollection<UserPresentation> namedCollection4 = namedCollection3;
        NamedCollection<UserPresentation> namedCollection5 = namedCollection2;
        String string9 = string7;
        ReviewListItemPresentation.Status status2 = null;
        ReviewListItemPresentation.Status status3 = status;
        NamedCollection namedCollection6 = namedCollection;
        UserPresentation userPresentation3 = userPresentation2;
        Date date3 = date2;
        String string10 = string5;
        String string11 = string6;
        return new ReviewListItemPresentation.Simple(string11, string10, date3, userPresentation3, namedCollection6, status3, status2, string9, namedCollection5, namedCollection4, commentsCounter, n2, defaultConstructorMarker);
    }

    private final TagPresentation.Simple getLabelPresentation(GHLabel label) {
        return new TagPresentation.Simple(label.getName(), ColorHexUtil.fromHex((String)label.getColor()));
    }

    private final String getStateText(GHPullRequestState state2, boolean isDraft) {
        if (state2 == GHPullRequestState.OPEN && !isDraft) {
            return null;
        }
        return GHUIUtil.INSTANCE.getPullRequestStateText(state2, isDraft);
    }

    private final ReviewListItemPresentation.Status getMergeableStatus(GHPullRequestMergeableState mergeableState) {
        if (mergeableState == GHPullRequestMergeableState.CONFLICTING) {
            Icon icon = CollaborationToolsIcons.Review.NonMergeable;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"NonMergeable");
            String string = GithubBundle.message("pull.request.conflicts.merge.tooltip", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.conflicts.merge.tooltip\")");
            return new ReviewListItemPresentation.Status(icon, string);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final NamedCollection<UserPresentation> getAssigneesPresentation(IconsProvider<String> avatarIconsProvider, List<GHUser> assignees) {
        Collection<UserPresentation> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray = new Object[]{assignees.size()};
        String string = GithubBundle.message("pull.request.assignees.popup", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.as\u2026s.popup\", assignees.size)");
        Iterable iterable = assignees;
        String string2 = string;
        NamedCollection.Companion companion = NamedCollection.Companion;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void user;
            GHUser gHUser = (GHUser)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createUserPresentation(avatarIconsProvider, (GHUser)user));
        }
        collection = (List)destination$iv$iv;
        return companion.create(string2, (List)collection);
    }

    /*
     * WARNING - void declaration
     */
    private final NamedCollection<UserPresentation> getReviewersPresentation(IconsProvider<String> avatarIconsProvider, List<GHPullRequestReviewRequest> reviewRequests) {
        Collection<UserPresentation> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = reviewRequests;
        boolean $i$f$mapNotNull22 = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            GHPullRequestRequestedReviewer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            GHPullRequestReviewRequest it = (GHPullRequestReviewRequest)element$iv$iv;
            boolean bl2 = false;
            if (it.getRequestedReviewer() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List reviewers = (List)destination$iv$iv;
        Object[] $i$f$mapNotNull22 = new Object[]{reviewers.size()};
        String string = GithubBundle.message("pull.request.reviewers.popup", $i$f$mapNotNull22);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.re\u2026s.popup\", reviewers.size)");
        $this$mapNotNull$iv = reviewers;
        String string2 = string;
        NamedCollection.Companion companion = NamedCollection.Companion;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void reviewer;
            object = (GHPullRequestRequestedReviewer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createUserPresentation(avatarIconsProvider, (GHPullRequestRequestedReviewer)reviewer));
        }
        collection = (List)destination$iv$iv;
        return companion.create(string2, (List)collection);
    }

    private final UserPresentation createUserPresentation(IconsProvider<String> avatarIconsProvider, GHActor user) {
        if (user == null) {
            return null;
        }
        return (UserPresentation)new UserPresentation.Simple(user.getLogin(), null, avatarIconsProvider.getIcon((Object)user.getAvatarUrl(), 20));
    }

    private final UserPresentation createUserPresentation(IconsProvider<String> avatarIconsProvider, GHUser user) {
        return (UserPresentation)new UserPresentation.Simple(user.getLogin(), user.getName(), avatarIconsProvider.getIcon((Object)user.getAvatarUrl(), 20));
    }

    private final UserPresentation createUserPresentation(IconsProvider<String> avatarIconsProvider, GHPullRequestRequestedReviewer user) {
        return (UserPresentation)new UserPresentation.Simple(user.getShortName(), user.getName(), avatarIconsProvider.getIcon((Object)user.getAvatarUrl(), 20));
    }

    private static final Object create$lambda$1$lambda$0(JBList $it, String dataId) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return GHPRActionKeys.getSELECTED_PULL_REQUEST().is(dataId) ? (GHPullRequestShort)$it.getSelectedValue() : null;
    }

    public static final /* synthetic */ ReviewListItemPresentation.Simple access$presentPR(GHPRListComponentFactory $this, IconsProvider avatarIconsProvider, GHPullRequestShort pr) {
        return $this.presentPR((IconsProvider<String>)avatarIconsProvider, pr);
    }
}

