/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.util;

import com.intellij.UtilBundle;
import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.codereview.details.SelectableWrapper;
import com.intellij.collaboration.ui.codereview.list.search.ChooserPopupUtil;
import com.intellij.collaboration.ui.codereview.list.search.SimpleSelectablePopupItemRenderer;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.collaboration.util.CollectionDelta;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.CollaborationToolsIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.GithubIcons;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestState;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001b\u0010\u0014\u001a\u00070\b\u00a2\u0006\u0002\b\u00152\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J(\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u0013H\u0007J\u0016\u0010\u001c\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0016\u0010\u001e\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\\\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\"0!0 \"\u0004\b\u0000\u0010\"2\u0006\u0010#\u001a\u00020$2\u0018\u0010%\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\"0'\u0012\u0004\u0012\u00020(0&2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H\"0\u00182\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\"0\u00180 \u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil;", "", "()V", "createIssueLabelLabel", "Lcom/intellij/ui/components/JBLabel;", "label", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "formatActionDate", "", "date", "Ljava/util/Date;", "getIssueStateIcon", "Ljavax/swing/Icon;", "state", "Lorg/jetbrains/plugins/github/api/data/GithubIssueState;", "getIssueStateText", "getPullRequestStateIcon", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestState;", "isDraft", "", "getPullRequestStateText", "Lcom/intellij/openapi/util/NlsSafe;", "getRepositoryDisplayName", "allRepositories", "", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "repository", "alwaysShowOwner", "needToShowRepositoryOwner", "repos", "needToShowRepositoryServer", "showChooserPopup", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/collaboration/util/CollectionDelta;", "T", "parentComponent", "Ljavax/swing/JComponent;", "presenter", "Lkotlin/Function1;", "Lcom/intellij/collaboration/ui/codereview/details/SelectableWrapper;", "Lcom/intellij/collaboration/ui/codereview/list/search/ChooserPopupUtil$SelectablePopupItemPresentation$Simple;", "currentList", "availableListFuture", "SelectionPresenters", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHUIUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHUIUtil.kt\norg/jetbrains/plugins/github/ui/util/GHUIUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n1549#2:248\n1620#2,3:249\n1747#2,3:252\n1747#2,3:255\n*S KotlinDebug\n*F\n+ 1 GHUIUtil.kt\norg/jetbrains/plugins/github/ui/util/GHUIUtil\n*L\n146#1:248\n146#1:249,3\n239#1:252,3\n245#1:255,3\n*E\n"})
public final class GHUIUtil {
    @NotNull
    public static final GHUIUtil INSTANCE = new GHUIUtil();

    private GHUIUtil() {
    }

    @NotNull
    public final Icon getPullRequestStateIcon(@NotNull GHPullRequestState state2, boolean isDraft) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        if (isDraft) {
            Icon icon2 = GithubIcons.PullRequestDraft;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PullRequestDraft");
        } else {
            Icon icon3 = switch (WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                case 1 -> CollaborationToolsIcons.PullRequestClosed;
                case 2 -> GithubIcons.PullRequestMerged;
                case 3 -> CollaborationToolsIcons.PullRequestOpen;
                default -> throw new NoWhenBranchMatchedException();
            };
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"when (state) {\n      GHP\u2026ons.PullRequestOpen\n    }");
        }
        return icon;
    }

    @NotNull
    public final String getPullRequestStateText(@NotNull GHPullRequestState state2, boolean isDraft) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        if (isDraft) {
            String string2 = CollaborationToolsBundle.message((String)"review.details.review.state.draft", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"review.details.review.state.draft\")");
        } else {
            String string3 = switch (WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                case 1 -> CollaborationToolsBundle.message((String)"review.details.review.state.closed", (Object[])new Object[0]);
                case 2 -> CollaborationToolsBundle.message((String)"review.details.review.state.merged", (Object[])new Object[0]);
                case 3 -> CollaborationToolsBundle.message((String)"review.details.review.state.open", (Object[])new Object[0]);
                default -> throw new NoWhenBranchMatchedException();
            };
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"when (state) {\n      GHP\u2026review.state.open\")\n    }");
        }
        return string;
    }

    @NotNull
    public final Icon getIssueStateIcon(@NotNull GithubIssueState state2) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        switch (WhenMappings.$EnumSwitchMapping$1[state2.ordinal()]) {
            case 1: {
                Icon icon2 = GithubIcons.IssueOpened;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"IssueOpened");
                break;
            }
            case 2: {
                Icon icon3 = GithubIcons.IssueClosed;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"IssueClosed");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NlsSafe
    @NotNull
    public final String getIssueStateText(@NotNull GithubIssueState state2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        switch (WhenMappings.$EnumSwitchMapping$1[state2.ordinal()]) {
            case 1: {
                String string2 = GithubBundle.message("issue.state.open", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"issue.state.open\")");
                break;
            }
            case 2: {
                String string3 = GithubBundle.message("issue.state.closed", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"issue.state.closed\")");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final JBLabel createIssueLabelLabel(@NotNull GHLabel label) {
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        JBLabel $this$createIssueLabelLabel_u24lambda_u240 = jBLabel = new JBLabel(" " + label.getName() + " ", UIUtil.ComponentStyle.SMALL);
        boolean bl = false;
        $this$createIssueLabelLabel_u24lambda_u240.setBackground((Color)CollaborationToolsUIUtil.INSTANCE.getLabelBackground(label.getColor()));
        Color color2 = $this$createIssueLabelLabel_u24lambda_u240.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"background");
        $this$createIssueLabelLabel_u24lambda_u240.setForeground(CollaborationToolsUIUtil.INSTANCE.getLabelForeground(color2));
        JBLabel jBLabel2 = jBLabel.andOpaque();
        Intrinsics.checkNotNullExpressionValue((Object)jBLabel2, (String)"JBLabel(\" ${label.name} \u2026ckground)\n  }.andOpaque()");
        return jBLabel2;
    }

    @NotNull
    public final String formatActionDate(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string = DateFormatUtil.formatPrettyDate((Date)date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatPrettyDate(date)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String prettyDate = string3;
        String datePrefix = StringsKt.equals((String)prettyDate, (String)UtilBundle.message((String)"date.format.today", (Object[])new Object[0]), (boolean)true) || StringsKt.equals((String)prettyDate, (String)UtilBundle.message((String)"date.format.yesterday", (Object[])new Object[0]), (boolean)true) ? "" : "on ";
        return datePrefix + prettyDate;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> CompletableFuture<CollectionDelta<T>> showChooserPopup(@NotNull JComponent parentComponent, @NotNull Function1<? super SelectableWrapper<T>, ChooserPopupUtil.SelectablePopupItemPresentation.Simple> presenter, @NotNull List<? extends T> currentList, @NotNull CompletableFuture<List<T>> availableListFuture) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        JBList jBList;
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter(presenter, (String)"presenter");
        Intrinsics.checkNotNullParameter(currentList, (String)"currentList");
        Intrinsics.checkNotNullParameter(availableListFuture, (String)"availableListFuture");
        CollectionListModel listModel = new CollectionListModel((Object[])new SelectableWrapper[0]);
        JBList $this$showChooserPopup_u24lambda_u241 = jBList = new JBList((ListModel)listModel);
        boolean bl = false;
        $this$showChooserPopup_u24lambda_u241.setVisibleRowCount(7);
        $this$showChooserPopup_u24lambda_u241.setFocusable(false);
        $this$showChooserPopup_u24lambda_u241.setSelectionMode(0);
        $this$showChooserPopup_u24lambda_u241.setBackground(JBUI.CurrentTheme.Popup.BACKGROUND);
        JBList list = jBList;
        list.setCellRenderer(SimpleSelectablePopupItemRenderer.Companion.create(presenter));
        JScrollPane $this$showChooserPopup_u24lambda_u242 = bl = ScrollPaneFactory.createScrollPane((Component)((Component)list), (boolean)true);
        boolean bl2 = false;
        $this$showChooserPopup_u24lambda_u242.getViewport().setCursor(Cursor.getPredefinedCursor(12));
        $this$showChooserPopup_u24lambda_u242.setFocusable(false);
        JScrollPane jScrollPane = bl;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(list, t\u2026isFocusable = false\n    }");
        JScrollPane scrollPane2 = jScrollPane;
        JScrollPane $this$showChooserPopup_u24lambda_u243 = bl = new SearchTextField(false);
        boolean $i$a$-apply-GHUIUtil$showChooserPopup$searchField$22 = false;
        $this$showChooserPopup_u24lambda_u243.setBorder(IdeBorderFactory.createBorder((int)8));
        UIUtil.setBackgroundRecursively((Component)$this$showChooserPopup_u24lambda_u243, (Color)UIUtil.getListBackground());
        $this$showChooserPopup_u24lambda_u243.getTextEditor().setBorder((Border)JBUI.Borders.empty());
        JScrollPane searchField = bl;
        AbstractPopup.customizeSearchFieldLook((SearchTextField)searchField, (boolean)true);
        CollaborationToolsUIUtil.INSTANCE.attachSearch((JList)list, (SearchTextField)searchField, new Function1<SelectableWrapper<T>, String>(presenter){
            final /* synthetic */ Function1<SelectableWrapper<T>, ChooserPopupUtil.SelectablePopupItemPresentation.Simple> $presenter;
            {
                this.$presenter = $presenter;
                super(1);
            }

            @NotNull
            public final String invoke(SelectableWrapper<T> it) {
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                return ((ChooserPopupUtil.SelectablePopupItemPresentation.Simple)this.$presenter.invoke(it)).getShortText();
            }
        });
        BorderLayoutPanel $this$showChooserPopup_u24lambda_u244 = $i$a$-apply-GHUIUtil$showChooserPopup$searchField$22 = JBUI.Panels.simplePanel((Component)scrollPane2).addToTop((Component)searchField);
        boolean $i$a$-apply-GHUIUtil$showChooserPopup$panel$22 = false;
        Dimension size = searchField.getPreferredSize();
        $this$showChooserPopup_u24lambda_u244.setPreferredSize((Dimension)new JBDimension(size.width, size.height * 5, true));
        BorderLayoutPanel borderLayoutPanel = $i$a$-apply-GHUIUtil$showChooserPopup$searchField$22;
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"simplePanel(scrollPane).\u2026loading popup state\n    }");
        BorderLayoutPanel panel = borderLayoutPanel;
        ListUtil.installAutoSelectOnMouseMove((JList)((JList)list));
        list.addMouseListener((MouseListener)new MouseAdapter(list){
            final /* synthetic */ JBList<SelectableWrapper<T>> $list;
            {
                this.$list = $list;
            }

            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (UIUtil.isActionClick((MouseEvent)e, (int)502) && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !e.isConsumed()) {
                    GHUIUtil.access$showChooserPopup$toggleSelection(this.$list);
                }
            }
        });
        Set originalSelection = CollectionsKt.toHashSet((Iterable)currentList);
        Object $i$a$-apply-GHUIUtil$showChooserPopup$searchField$22 = currentList;
        CollectionListModel collectionListModel = listModel;
        boolean $i$f$map = false;
        void $i$a$-apply-GHUIUtil$showChooserPopup$panel$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(new SelectableWrapper((Object)it, true));
        }
        collectionListModel.add((List)destination$iv$iv);
        CompletableFuture result = new CompletableFuture();
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)searchField).setRequestFocus(true).setCancelOnClickOutside(true).setResizable(true).setMovable(true).setKeyboardActions(CollectionsKt.listOf((Object)Pair.create(arg_0 -> GHUIUtil.showChooserPopup$lambda$6(list, arg_0), (Object)KeyStroke.getKeyStroke(10, 0)))).addListener(new JBPopupListener(panel, list, availableListFuture, originalSelection, presenter, listModel, result){
            final /* synthetic */ BorderLayoutPanel $panel;
            final /* synthetic */ JBList<SelectableWrapper<T>> $list;
            final /* synthetic */ CompletableFuture<List<T>> $availableListFuture;
            final /* synthetic */ Set<T> $originalSelection;
            final /* synthetic */ Function1<SelectableWrapper<T>, ChooserPopupUtil.SelectablePopupItemPresentation.Simple> $presenter;
            final /* synthetic */ CollectionListModel<SelectableWrapper<T>> $listModel;
            final /* synthetic */ CompletableFuture<CollectionDelta<T>> $result;
            {
                this.$panel = $panel;
                this.$list = $list;
                this.$availableListFuture = $availableListFuture;
                this.$originalSelection = $originalSelection;
                this.$presenter = $presenter;
                this.$listModel = $listModel;
                this.$result = $result;
            }

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$panel.setPreferredSize(null);
                this.$list.setPaintBusy(true);
                this.$list.getEmptyText().setText(ApplicationBundle.message((String)"label.loading.page.please.wait", (Object[])new Object[0]));
                CompletionStage completionStage = this.$availableListFuture.thenApplyAsync(arg_0 -> showChooserPopup.5.beforeShown$lambda$0((Function1)new Function1<List<? extends T>, List<? extends SelectableWrapper<T>>>(this.$originalSelection, this.$presenter){
                    final /* synthetic */ Set<T> $originalSelection;
                    final /* synthetic */ Function1<SelectableWrapper<T>, ChooserPopupUtil.SelectablePopupItemPresentation.Simple> $presenter;
                    {
                        this.$originalSelection = $originalSelection;
                        this.$presenter = $presenter;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final List<SelectableWrapper<T>> invoke(List<? extends T> available) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Intrinsics.checkNotNullExpressionValue(available, (String)"available");
                        Iterable iterable = available;
                        Set<T> set = this.$originalSelection;
                        boolean $i$f$map = false;
                        void var5_5 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            void it;
                            T item$iv$iv;
                            T t = item$iv$iv = iterator.next();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(new SelectableWrapper((Object)it, set.contains(it)));
                        }
                        Iterable iterable2 = (List)destination$iv$iv;
                        Comparator<Object> comparator = Comparator.comparing(arg_0 -> showChooserPopup.beforeShown.1.invoke$lambda$1(showChooserPopup.beforeShown.2.INSTANCE, arg_0)).thenComparing(arg_0 -> showChooserPopup.beforeShown.1.invoke$lambda$2((Function1)new Function1<SelectableWrapper<T>, String>(this.$presenter){
                            final /* synthetic */ Function1<SelectableWrapper<T>, ChooserPopupUtil.SelectablePopupItemPresentation.Simple> $presenter;
                            {
                                this.$presenter = $presenter;
                                super(1);
                            }

                            public final String invoke(SelectableWrapper<T> it) {
                                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                                return ((ChooserPopupUtil.SelectablePopupItemPresentation.Simple)this.$presenter.invoke(it)).getShortText();
                            }
                        }, arg_0), (arg_0, arg_1) -> showChooserPopup.beforeShown.1.invoke$lambda$3(showChooserPopup.beforeShown.4.INSTANCE, arg_0, arg_1));
                        Intrinsics.checkNotNullExpressionValue(comparator, (String)"presenter: (SelectableWr\u2026til.compare(a, b, true) }");
                        return CollectionsKt.sortedWith((Iterable)iterable2, comparator);
                    }

                    private static final Boolean invoke$lambda$1(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (Boolean)$tmp0.invoke(p0);
                    }

                    private static final String invoke$lambda$2(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (String)$tmp0.invoke(p0);
                    }

                    private static final int invoke$lambda$3(Function2 $tmp0, Object p0, Object p1) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return ((Number)$tmp0.invoke(p0, p1)).intValue();
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"T> showChooserPopup(pare\u2026b, true) })\n            }");
                CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)completionStage, null, (Function1)((Function1)new Function1<List<? extends SelectableWrapper<T>>, Unit>(this.$listModel, this.$list, event){
                    final /* synthetic */ CollectionListModel<SelectableWrapper<T>> $listModel;
                    final /* synthetic */ JBList<SelectableWrapper<T>> $list;
                    final /* synthetic */ LightweightWindowEvent $event;
                    {
                        this.$listModel = $listModel;
                        this.$list = $list;
                        this.$event = $event;
                        super(1);
                    }

                    public final void invoke(List<SelectableWrapper<T>> it) {
                        this.$listModel.replaceAll(it);
                        this.$list.setPaintBusy(false);
                        this.$list.getEmptyText().setText(UIBundle.message((String)"message.noMatchesFound", (Object[])new Object[0]));
                        this.$event.asPopup().pack(true, true);
                        if (this.$list.getSelectedIndex() == -1) {
                            this.$list.setSelectedIndex(0);
                        }
                    }
                }), (int)1, null);
            }

            /*
             * WARNING - void declaration
             */
            public void onClosed(@NotNull LightweightWindowEvent event) {
                void $this$mapTo$iv$iv;
                SelectableWrapper it;
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                List list = this.$listModel.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"listModel.items");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (SelectableWrapper)element$iv$iv;
                    boolean bl = false;
                    if (!it.isSelected()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (SelectableWrapper)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getValue());
                }
                List selected = (List)destination$iv$iv;
                this.$result.complete(new CollectionDelta((Collection)this.$originalSelection, (Collection)selected));
            }

            private static final List beforeShown$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (List)$tmp0.invoke(p0);
            }
        }).createPopup().showUnderneathOf((Component)parentComponent);
        return result;
    }

    @NlsSafe
    @NotNull
    public final String getRepositoryDisplayName(@NotNull List<GHRepositoryCoordinates> allRepositories, @NotNull GHRepositoryCoordinates repository, boolean alwaysShowOwner) {
        Intrinsics.checkNotNullParameter(allRepositories, (String)"allRepositories");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        boolean showServer = this.needToShowRepositoryServer(allRepositories);
        boolean showOwner = showServer || alwaysShowOwner ? true : this.needToShowRepositoryOwner(allRepositories);
        StringBuilder builder = new StringBuilder();
        if (showServer) {
            builder.append(repository.getServerPath().toUrl(false)).append("/");
        }
        if (showOwner) {
            builder.append(repository.getRepositoryPath().getOwner()).append("/");
        }
        builder.append(repository.getRepositoryPath().getRepository());
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    public static /* synthetic */ String getRepositoryDisplayName$default(GHUIUtil gHUIUtil, List list, GHRepositoryCoordinates gHRepositoryCoordinates, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return gHUIUtil.getRepositoryDisplayName(list, gHRepositoryCoordinates, bl);
    }

    private final boolean needToShowRepositoryOwner(List<GHRepositoryCoordinates> repos) {
        boolean bl;
        block4: {
            if (repos.size() <= 1) {
                return false;
            }
            String firstOwner = ((GHRepositoryCoordinates)CollectionsKt.first(repos)).getRepositoryPath().getOwner();
            Iterable $this$any$iv = repos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GHRepositoryCoordinates it = (GHRepositoryCoordinates)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getRepositoryPath().getOwner(), (Object)firstOwner))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean needToShowRepositoryServer(List<GHRepositoryCoordinates> repos) {
        boolean bl;
        block4: {
            if (repos.size() <= 1) {
                return false;
            }
            GithubServerPath firstServer = ((GHRepositoryCoordinates)CollectionsKt.first(repos)).getServerPath();
            Iterable $this$any$iv = repos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GHRepositoryCoordinates it = (GHRepositoryCoordinates)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getServerPath(), (Object)firstServer))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final <T> void showChooserPopup$toggleSelection(JBList<SelectableWrapper<T>> list) {
        Iterator iterator = list.getSelectedValuesList().iterator();
        while (iterator.hasNext()) {
            SelectableWrapper item;
            item.setSelected(!(item = (SelectableWrapper)iterator.next()).isSelected());
        }
        list.repaint();
    }

    private static final void showChooserPopup$lambda$6(JBList $list, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$list, (String)"$list");
        GHUIUtil.showChooserPopup$toggleSelection($list);
    }

    public static final /* synthetic */ void access$showChooserPopup$toggleSelection(JBList list) {
        GHUIUtil.showChooserPopup$toggleSelection(list);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u0004J*\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0005\u0012\u0004\u0012\u00020\u00070\u00042\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rJ*\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0005\u0012\u0004\u0012\u00020\u00070\u00042\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionPresenters;", "", "()V", "Labels", "Lkotlin/Function1;", "Lcom/intellij/collaboration/ui/codereview/details/SelectableWrapper;", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "Lcom/intellij/collaboration/ui/codereview/list/search/ChooserPopupUtil$SelectablePopupItemPresentation$Simple;", "PRReviewers", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "Users", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "intellij.vcs.github"})
    public static final class SelectionPresenters {
        @NotNull
        public static final SelectionPresenters INSTANCE = new SelectionPresenters();

        private SelectionPresenters() {
        }

        @NotNull
        public final Function1<SelectableWrapper<GHPullRequestRequestedReviewer>, ChooserPopupUtil.SelectablePopupItemPresentation.Simple> PRReviewers(@NotNull IconsProvider<String> avatarIconsProvider) {
            Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
            return (Function1)new Function1<SelectableWrapper<GHPullRequestRequestedReviewer>, ChooserPopupUtil.SelectablePopupItemPresentation.Simple>(avatarIconsProvider){
                final /* synthetic */ IconsProvider<String> $avatarIconsProvider;
                {
                    this.$avatarIconsProvider = $avatarIconsProvider;
                    super(1);
                }

                @NotNull
                public final ChooserPopupUtil.SelectablePopupItemPresentation.Simple invoke(@NotNull SelectableWrapper<GHPullRequestRequestedReviewer> wrapper) {
                    Intrinsics.checkNotNullParameter(wrapper, (String)"wrapper");
                    return new ChooserPopupUtil.SelectablePopupItemPresentation.Simple(((GHPullRequestRequestedReviewer)wrapper.getValue()).getShortName(), this.$avatarIconsProvider.getIcon((Object)((GHPullRequestRequestedReviewer)wrapper.getValue()).getAvatarUrl(), 20), null, wrapper.isSelected());
                }
            };
        }

        @NotNull
        public final Function1<SelectableWrapper<GHUser>, ChooserPopupUtil.SelectablePopupItemPresentation.Simple> Users(@NotNull IconsProvider<String> avatarIconsProvider) {
            Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
            return (Function1)new Function1<SelectableWrapper<GHUser>, ChooserPopupUtil.SelectablePopupItemPresentation.Simple>(avatarIconsProvider){
                final /* synthetic */ IconsProvider<String> $avatarIconsProvider;
                {
                    this.$avatarIconsProvider = $avatarIconsProvider;
                    super(1);
                }

                @NotNull
                public final ChooserPopupUtil.SelectablePopupItemPresentation.Simple invoke(@NotNull SelectableWrapper<GHUser> wrapper) {
                    Intrinsics.checkNotNullParameter(wrapper, (String)"wrapper");
                    return new ChooserPopupUtil.SelectablePopupItemPresentation.Simple(((GHUser)wrapper.getValue()).getLogin(), this.$avatarIconsProvider.getIcon((Object)((GHUser)wrapper.getValue()).getAvatarUrl(), 20), null, wrapper.isSelected());
                }
            };
        }

        @NotNull
        public final Function1<SelectableWrapper<GHLabel>, ChooserPopupUtil.SelectablePopupItemPresentation.Simple> Labels() {
            return Labels.1.INSTANCE;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[GHPullRequestState.values().length];
            try {
                nArray[GHPullRequestState.CLOSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestState.MERGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestState.OPEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GithubIssueState.values().length];
            try {
                nArray[GithubIssueState.open.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GithubIssueState.closed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

