/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.associations.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import org.intellij.lang.xpath.xslt.associations.FileAssociationsManager;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;

class ToggleAssociationAction
extends ToggleAction {
    private final FileAssociationsManager myFileAssociationsManager;
    private final PsiFile myPsiFile;
    private final PsiFile myAssoc;

    ToggleAssociationAction(FileAssociationsManager fileAssociationsManager, PsiFile psiFile, PsiFile assoc) {
        super(ToggleAssociationAction.getPath(assoc, psiFile), XPathBundle.message("action.remove.association.to.description", assoc.getName()), null);
        this.myFileAssociationsManager = fileAssociationsManager;
        this.myPsiFile = psiFile;
        this.myAssoc = assoc;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ToggleAssociationAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @NlsSafe
    private static String getPath(PsiFile assoc, PsiFile psiFile) {
        VirtualFile virtualFile = assoc.getVirtualFile();
        assert (virtualFile != null);
        String path = VfsUtilCore.findRelativePath((VirtualFile)psiFile.getVirtualFile(), (VirtualFile)virtualFile, (char)File.separatorChar);
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)assoc.getProject()).getFileIndex();
        Module module = index.getModuleForFile(virtualFile);
        return path != null ? (module != null ? "[" + module.getName() + "] - " + path : path) : virtualFile.getPresentableUrl();
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleAssociationAction.$$$reportNull$$$0(1);
        }
        return true;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            ToggleAssociationAction.$$$reportNull$$$0(2);
        }
        assert (!state);
        this.myFileAssociationsManager.removeAssociation(this.myPsiFile, this.myAssoc);
        DaemonCodeAnalyzer.getInstance((Project)AnAction.getEventProject((AnActionEvent)e)).restart();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/associations/impl/ToggleAssociationAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/associations/impl/ToggleAssociationAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

