/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SimpleAttributeReference
implements PsiReference {
    protected final XmlAttribute myAttribute;

    protected SimpleAttributeReference(XmlAttribute attribute) {
        this.myAttribute = attribute;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getTextRange().substring(this.myAttribute.getValue());
        if (string == null) {
            SimpleAttributeReference.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElement getElement() {
        XmlAttributeValue value = this.myAttribute.getValueElement();
        assert (value != null);
        XmlAttributeValue xmlAttributeValue = value;
        if (xmlAttributeValue == null) {
            SimpleAttributeReference.$$$reportNull$$$0(1);
        }
        return xmlAttributeValue;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.getTextRange().shiftRight(1);
        if (textRange == null) {
            SimpleAttributeReference.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        SimpleAttributeReference simpleAttributeReference;
        if (element == null) {
            SimpleAttributeReference.$$$reportNull$$$0(3);
        }
        if ((simpleAttributeReference = this) instanceof PsiPolyVariantReference) {
            ResolveResult[] results;
            PsiPolyVariantReference reference = (PsiPolyVariantReference)simpleAttributeReference;
            for (ResolveResult result : results = reference.multiResolve(false)) {
                if (!Comparing.equal((Object)result.getElement(), (Object)element)) continue;
                return true;
            }
            return false;
        }
        return Comparing.equal((Object)this.resolve(), (Object)element);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            SimpleAttributeReference.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            SimpleAttributeReference.$$$reportNull$$$0(5);
        }
        this.myAttribute.setValue(this.getTextRange().replace(this.myAttribute.getValue(), newElementName));
        XmlAttributeValue value = this.myAttribute.getValueElement();
        assert (value != null);
        return value;
    }

    @Nullable
    public final PsiElement resolve() {
        return (PsiElement)ResolveCache.getInstance((Project)this.myAttribute.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)((ResolveCache.Resolver)(psiReference, b) -> this.resolveImpl()), false, false);
    }

    @Nullable
    protected abstract PsiElement resolveImpl();

    @NotNull
    protected abstract TextRange getTextRange();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/impl/references/SimpleAttributeReference";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/references/SimpleAttributeReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

