/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.function;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.internal.function.PathFunction;
import com.jayway.jsonpath.internal.function.json.Append;
import com.jayway.jsonpath.internal.function.json.KeySetFunction;
import com.jayway.jsonpath.internal.function.numeric.Average;
import com.jayway.jsonpath.internal.function.numeric.Max;
import com.jayway.jsonpath.internal.function.numeric.Min;
import com.jayway.jsonpath.internal.function.numeric.StandardDeviation;
import com.jayway.jsonpath.internal.function.numeric.Sum;
import com.jayway.jsonpath.internal.function.sequence.First;
import com.jayway.jsonpath.internal.function.sequence.Index;
import com.jayway.jsonpath.internal.function.sequence.Last;
import com.jayway.jsonpath.internal.function.text.Concatenate;
import com.jayway.jsonpath.internal.function.text.Length;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PathFunctionFactory {
    public static final Map<String, Class> FUNCTIONS;

    public static PathFunction newFunction(String name) throws InvalidPathException {
        Class functionClazz = FUNCTIONS.get(name);
        if (functionClazz == null) {
            throw new InvalidPathException("Function with name: " + name + " does not exist.");
        }
        try {
            return (PathFunction)functionClazz.newInstance();
        }
        catch (Exception e) {
            throw new InvalidPathException("Function of name: " + name + " cannot be created", e);
        }
    }

    static {
        HashMap<String, Class> map2 = new HashMap<String, Class>();
        map2.put("avg", Average.class);
        map2.put("stddev", StandardDeviation.class);
        map2.put("sum", Sum.class);
        map2.put("min", Min.class);
        map2.put("max", Max.class);
        map2.put("concat", Concatenate.class);
        map2.put("length", Length.class);
        map2.put("size", Length.class);
        map2.put("append", Append.class);
        map2.put("keys", KeySetFunction.class);
        map2.put("first", First.class);
        map2.put("last", Last.class);
        map2.put("index", Index.class);
        FUNCTIONS = Collections.unmodifiableMap(map2);
    }
}

