/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.gradienteditor;

import com.michaelbaranov.microba.common.AbstractBoundedTableModelWithSelection;
import com.michaelbaranov.microba.marker.MarkerMutationModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class DefaultGradientEditorModel
extends AbstractBoundedTableModelWithSelection
implements MarkerMutationModel {
    public static final int POSITION_COLUMN = 0;
    public static final int COLOR_COLUMN = 1;
    protected List position = new ArrayList(32);
    protected List color = new ArrayList(32);

    public DefaultGradientEditorModel() {
        this.setSelectionMode(0);
        this.position.add(new Integer(0));
        this.color.add(Color.BLACK);
        this.position.add(new Integer(255));
        this.color.add(Color.WHITE);
    }

    @Override
    public void removeMarkerAtIndex(int index) {
        if (this.isSelectedIndex(index)) {
            this.removeSelectionInterval(index, index);
        }
        this.position.remove(index);
        this.color.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    @Override
    public int addMarkAtPosition(int pos) {
        this.position.add(new Integer(pos));
        this.color.add(new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
        int index = this.position.size() - 1;
        this.fireTableRowsInserted(index, index);
        return index;
    }

    @Override
    public int getLowerBound() {
        return 0;
    }

    @Override
    public int getUpperBound() {
        return 255;
    }

    @Override
    public int getRowCount() {
        return this.position.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Color.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.position.get(rowIndex);
            }
            case 1: {
                return this.color.get(rowIndex);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                for (int i = 0; i < this.position.size(); ++i) {
                    if (rowIndex == i || !aValue.equals(this.position.get(i))) continue;
                    return;
                }
                this.position.remove(rowIndex);
                this.position.add(rowIndex, aValue);
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
            case 1: {
                this.color.remove(rowIndex);
                this.color.add(rowIndex, (Color)aValue);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0 || rowIndex >= 2;
    }
}

