/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.ast;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.CompositeASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.impl.ListCompositeNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/intellij/markdown/ast/ASTNodeBuilder;", "", "text", "", "(Ljava/lang/CharSequence;)V", "getText", "()Ljava/lang/CharSequence;", "createCompositeNode", "Lorg/intellij/markdown/ast/CompositeASTNode;", "type", "Lorg/intellij/markdown/IElementType;", "children", "", "Lorg/intellij/markdown/ast/ASTNode;", "createLeafNodes", "startOffset", "", "endOffset", "Companion", "markdown"})
public class ASTNodeBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence text;

    public ASTNodeBuilder(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
    }

    @NotNull
    protected final CharSequence getText() {
        return this.text;
    }

    @NotNull
    public List<ASTNode> createLeafNodes(@NotNull IElementType type, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.WHITE_SPACE)) {
            int nextEol;
            ArrayList<LeafASTNode> result2 = new ArrayList<LeafASTNode>();
            int lastEol = startOffset;
            while (lastEol < endOffset && (nextEol = Companion.indexOfSubSeq(this.text, lastEol, endOffset, '\n')) != -1) {
                if (nextEol > lastEol) {
                    result2.add(new LeafASTNode(MarkdownTokenTypes.WHITE_SPACE, lastEol, nextEol));
                }
                result2.add(new LeafASTNode(MarkdownTokenTypes.EOL, nextEol, nextEol + 1));
                lastEol = nextEol + 1;
            }
            if (endOffset > lastEol) {
                result2.add(new LeafASTNode(MarkdownTokenTypes.WHITE_SPACE, lastEol, endOffset));
            }
            return result2;
        }
        return CollectionsKt.listOf((Object)new LeafASTNode(type, startOffset, endOffset));
    }

    @NotNull
    public CompositeASTNode createCompositeNode(@NotNull IElementType type, @NotNull List<? extends ASTNode> children) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        IElementType iElementType = type;
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.UNORDERED_LIST) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ORDERED_LIST)) {
            return new ListCompositeNode(type, children);
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LIST_ITEM)) {
            return new ListItemCompositeNode(children);
        }
        return new CompositeASTNode(type, children);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/intellij/markdown/ast/ASTNodeBuilder$Companion;", "", "()V", "indexOfSubSeq", "", "s", "", "from", "to", "c", "", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        public final int indexOfSubSeq(@NotNull CharSequence s, int from, int to, char c) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            int n = from;
            int n2 = to - 1;
            if (n <= n2) {
                int i;
                do {
                    if (s.charAt(i = n++) != c) continue;
                    return i;
                } while (i != n2);
            }
            return -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

