/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.codeStyleMapping.valueConversions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.eclipse.codeStyleMapping.util.Convertor;
import org.jetbrains.idea.eclipse.codeStyleMapping.util.UnexpectedIncomingValue;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/eclipse/codeStyleMapping/valueConversions/BlankLinesConvertor;", "Lorg/jetbrains/idea/eclipse/codeStyleMapping/util/Convertor;", "", "", "()V", "convertIncoming", "value", "(Ljava/lang/String;)Ljava/lang/Integer;", "convertOutgoing", "intellij.eclipse"})
public final class BlankLinesConvertor
implements Convertor<String, Integer> {
    @NotNull
    public static final BlankLinesConvertor INSTANCE = new BlankLinesConvertor();

    private BlankLinesConvertor() {
    }

    @Override
    @NotNull
    public Integer convertIncoming(@NotNull String value) {
        int n;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            n = Integer.parseInt(StringsKt.removePrefix((String)value, (CharSequence)"-"));
        }
        catch (NumberFormatException e) {
            throw new UnexpectedIncomingValue((Object)value);
        }
        return n;
    }

    @Override
    @NotNull
    public String convertOutgoing(int value) {
        return String.valueOf(RangesKt.coerceIn((int)value, (int)0, (int)99));
    }
}

