/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.eventtrace.example;

import com.intellij.execution.filters.Filter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.eventtrace.abstractevent.SplitType;
import com.intellij.profiler.eventtrace.abstractevent.TraceColorizedEvent;
import com.intellij.profiler.eventtrace.abstractevent.TracePartialEvent;
import com.intellij.profiler.eventtrace.abstractevent.TraceSplitEvent;
import com.intellij.profiler.eventtrace.abstractevent.TraceTimeEvent;
import com.intellij.profiler.eventtrace.example.BracketEventTracer;
import com.intellij.profiler.eventtrace.holder.ClosableEventHolder;
import com.intellij.profiler.eventtrace.holder.HolderFactory;
import com.intellij.profiler.eventtrace.intervals.TraceEventLineInterval;
import com.intellij.profiler.eventtrace.intervals.TraceLineIntervalEvent;
import com.intellij.profiler.eventtrace.parser.IteratorCombinatorParser;
import com.intellij.profiler.eventtrace.parser.events.TraceEventParserTimeLine;
import com.intellij.profiler.eventtrace.parser.panels.EventTraceTimelineModel;
import com.intellij.profiler.eventtrace.parser.panels.TraceEventPanel;
import com.intellij.profiler.eventtrace.parser.panels.TraceEventTimeLinePanel;
import com.intellij.profiler.eventtrace.toolwindow.EventTraceToolWindowUi;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import java.awt.Color;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0005\u0003\u0004\u0005\u0006\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/eventtrace/example/BracketEventTracer;", "", "()V", "BracketEvent", "BracketEventParser", "BracketInterval", "BracketToolWindowUI", "IteratorParser", "intellij.profiler.common"})
public final class BracketEventTracer {

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bR\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00050\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/profiler/eventtrace/example/BracketEventTracer$BracketEvent;", "Lcom/intellij/profiler/eventtrace/abstractevent/TraceColorizedEvent;", "Lcom/intellij/profiler/eventtrace/abstractevent/TracePartialEvent;", "Lcom/intellij/profiler/eventtrace/abstractevent/TraceSplitEvent;", "line", "", "position", "splitType", "Lcom/intellij/profiler/eventtrace/abstractevent/SplitType;", "color", "Lcom/intellij/ui/JBColor;", "(JJLcom/intellij/profiler/eventtrace/abstractevent/SplitType;Lcom/intellij/ui/JBColor;)V", "getColor", "()Lcom/intellij/ui/JBColor;", "part", "", "", "getPart", "()Ljava/util/Map;", "getSplitType", "()Lcom/intellij/profiler/eventtrace/abstractevent/SplitType;", "start", "getStart", "()J", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "getTimeUnit", "()Ljava/util/concurrent/TimeUnit;", "intellij.profiler.common"})
    public static final class BracketEvent
    implements TraceColorizedEvent,
    TracePartialEvent,
    TraceSplitEvent {
        @NotNull
        private final SplitType splitType;
        @Nullable
        private final JBColor color;
        @NotNull
        private final TimeUnit timeUnit;
        @NotNull
        private final Map<String, Long> part;
        private final long start;

        public BracketEvent(long line, long position, @NotNull SplitType splitType, @Nullable JBColor color2) {
            Intrinsics.checkNotNullParameter((Object)((Object)splitType), (String)"splitType");
            this.splitType = splitType;
            this.color = color2;
            this.timeUnit = TimeUnit.MILLISECONDS;
            Pair[] pairArray = new Pair[]{new Pair((Object)"l", (Object)line)};
            this.part = MapsKt.hashMapOf((Pair[])pairArray);
            this.start = position * (long)1000;
        }

        @Override
        @NotNull
        public SplitType getSplitType() {
            return this.splitType;
        }

        @Override
        @Nullable
        public JBColor getColor() {
            return this.color;
        }

        @Override
        @NotNull
        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        @Override
        @NotNull
        public Map<String, Long> getPart() {
            return this.part;
        }

        @Override
        public long getStart() {
            return this.start;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/eventtrace/example/BracketEventTracer$BracketEventParser;", "Lcom/intellij/profiler/eventtrace/parser/events/TraceEventParserTimeLine;", "()V", "leaf", "Lcom/intellij/profiler/eventtrace/holder/HolderFactory$LeafHolderData;", "getLeaf", "()Lcom/intellij/profiler/eventtrace/holder/HolderFactory$LeafHolderData;", "nodes", "Ljava/util/ArrayList;", "Lcom/intellij/profiler/eventtrace/holder/HolderFactory$NodeHolderData;", "getNodes", "()Ljava/util/ArrayList;", "parse", "Lcom/intellij/profiler/eventtrace/holder/ClosableEventHolder;", "fileName", "", "s", "Ljava/io/File;", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nBracketEventTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BracketEventTracer.kt\ncom/intellij/profiler/eventtrace/example/BracketEventTracer$BracketEventParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,201:1\n1864#2,2:202\n1866#2:207\n1183#3,3:204\n*S KotlinDebug\n*F\n+ 1 BracketEventTracer.kt\ncom/intellij/profiler/eventtrace/example/BracketEventTracer$BracketEventParser\n*L\n144#1:202,2\n144#1:207\n145#1:204,3\n*E\n"})
    public static final class BracketEventParser
    extends TraceEventParserTimeLine {
        @NotNull
        private final ArrayList<HolderFactory.NodeHolderData> nodes;
        @NotNull
        private final HolderFactory.LeafHolderData leaf;

        public BracketEventParser() {
            Object[] objectArray = new HolderFactory.NodeHolderData[]{new HolderFactory.NodeHolderData("File", "file", "l", null)};
            this.nodes = CollectionsKt.arrayListOf((Object[])objectArray);
            this.leaf = new HolderFactory.LeafHolderData("Line", "line", new IteratorParser());
        }

        @Override
        @NotNull
        public ArrayList<HolderFactory.NodeHolderData> getNodes() {
            return this.nodes;
        }

        @Override
        @NotNull
        public HolderFactory.LeafHolderData getLeaf() {
            return this.leaf;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ClosableEventHolder parse(@NotNull String fileName, @NotNull File s) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            ClosableEventHolder holder = HolderFactory.Companion.getHolder(this.getNodes(), this.getLeaf());
            String str = FilesKt.readText$default((File)s, null, (int)1, null);
            String[] stringArray = new String[]{"\n"};
            List lines = StringsKt.split$default((CharSequence)str, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Iterable $this$forEachIndexed$iv = lines;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void line;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int i = n;
                boolean bl = false;
                CharSequence $this$forEachIndexed$iv2 = (CharSequence)line;
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (int j = 0; j < $this$forEachIndexed$iv2.length(); ++j) {
                    SplitType type;
                    void char_;
                    char item$iv2 = $this$forEachIndexed$iv2.charAt(j);
                    int n2 = index$iv2++;
                    char c = item$iv2;
                    int j2 = n2;
                    boolean bl2 = false;
                    void var23_24 = char_;
                    JBColor color2 = (var23_24 == 40 ? true : var23_24 == 41) ? JBColor.RED : ((var23_24 == 91 ? true : var23_24 == 93) ? JBColor.YELLOW : ((var23_24 == 123 ? true : var23_24 == 125) ? JBColor.BLUE : JBColor.PINK));
                    void var25_26 = char_;
                    SplitType splitType = ((var25_26 == 40 ? true : var25_26 == 91) ? true : var25_26 == 123) ? SplitType.BEGIN : (type = ((var25_26 == 41 ? true : var25_26 == 93) ? true : var25_26 == 125) ? SplitType.END : null);
                    if (type == null) continue;
                    holder.add(new BracketEvent(i, j2, type, color2));
                }
            }
            ClosableEventHolder.close$default(holder, null, 1, null);
            return holder;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\r\u0010!\u001a\u00070 \u00a2\u0006\u0002\b\"H\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/profiler/eventtrace/example/BracketEventTracer$BracketInterval;", "Lcom/intellij/profiler/eventtrace/intervals/TraceLineIntervalEvent;", "bracketEventStart", "Lcom/intellij/profiler/eventtrace/example/BracketEventTracer$BracketEvent;", "bracketEventEnd", "(Lcom/intellij/profiler/eventtrace/example/BracketEventTracer$BracketEvent;Lcom/intellij/profiler/eventtrace/example/BracketEventTracer$BracketEvent;)V", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "duration", "", "getDuration", "()J", "setDuration", "(J)V", "end", "getEnd", "start", "getStart", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "getTimeUnit", "()Ljava/util/concurrent/TimeUnit;", "toLabel", "Ljavax/swing/JComponent;", "filter", "Lcom/intellij/execution/filters/Filter;", "hyperLinkCreator", "Lkotlin/Function0;", "Ljavax/swing/event/HyperlinkListener;", "toShortString", "", "toString", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.profiler.common"})
    public static final class BracketInterval
    implements TraceLineIntervalEvent {
        private final long start;
        private final long end;
        @Nullable
        private final Color color;
        private long duration;
        @NotNull
        private final TimeUnit timeUnit;

        public BracketInterval(@NotNull BracketEvent bracketEventStart, @NotNull BracketEvent bracketEventEnd) {
            Intrinsics.checkNotNullParameter((Object)bracketEventStart, (String)"bracketEventStart");
            Intrinsics.checkNotNullParameter((Object)bracketEventEnd, (String)"bracketEventEnd");
            this.start = bracketEventStart.getStart();
            this.end = bracketEventEnd.getStart();
            this.color = (Color)bracketEventStart.getColor();
            this.duration = this.getEnd() - this.getStart();
            this.timeUnit = TimeUnit.MILLISECONDS;
        }

        @Override
        @NotNull
        public String toShortString() {
            return "";
        }

        @Override
        public long getStart() {
            return this.start;
        }

        @Override
        public long getEnd() {
            return this.end;
        }

        @Override
        @Nullable
        public Color getColor() {
            return this.color;
        }

        @Override
        public long getDuration() {
            return this.duration;
        }

        @Override
        public void setDuration(long l) {
            this.duration = l;
        }

        @Override
        @NotNull
        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        @Override
        @NotNull
        public String toString() {
            return "start=" + this.getStart() + ", end=" + this.getEnd();
        }

        @Override
        @NotNull
        public JComponent toLabel(@Nullable Filter filter, @Nullable Function0<? extends HyperlinkListener> hyperLinkCreator) {
            return (JComponent)new JBLabel(this.toString());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/eventtrace/example/BracketEventTracer$BracketToolWindowUI;", "Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceToolWindowUi;", "Lcom/intellij/profiler/eventtrace/parser/panels/EventTraceTimelineModel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "panel", "Lcom/intellij/profiler/eventtrace/parser/panels/TraceEventPanel;", "getPanel", "()Lcom/intellij/profiler/eventtrace/parser/panels/TraceEventPanel;", "parser", "Lkotlin/Function1;", "", "Lcom/intellij/profiler/eventtrace/parser/events/TraceEventParserTimeLine;", "getParser", "()Lkotlin/jvm/functions/Function1;", "addNewTab", "", "name", "", "path", "Ljava/nio/file/Path;", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nBracketEventTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BracketEventTracer.kt\ncom/intellij/profiler/eventtrace/example/BracketEventTracer$BracketToolWindowUI\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n*L\n1#1,201:1\n46#2,6:202\n*S KotlinDebug\n*F\n+ 1 BracketEventTracer.kt\ncom/intellij/profiler/eventtrace/example/BracketEventTracer$BracketToolWindowUI\n*L\n187#1:202,6\n*E\n"})
    public static final class BracketToolWindowUI
    extends EventTraceToolWindowUi<EventTraceTimelineModel> {
        @NotNull
        private final TraceEventPanel<EventTraceTimelineModel> panel;

        public BracketToolWindowUI(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project);
            this.panel = new TraceEventTimeLinePanel();
        }

        @Override
        @NotNull
        public Function1<Integer, TraceEventParserTimeLine> getParser() {
            return parser.1.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        public final void addNewTab(@NlsSafe @NotNull String name, @NotNull Path path) {
            void cancellable$iv;
            void title$iv;
            void project$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = CommonProfilerBundleKt.profilerMessage("profiler.eventtracer.getting.profiling.info", new Object[0]) + " " + name;
            Project project = this.getProject();
            boolean bl = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable((Project)project$iv, (String)title$iv, (boolean)cancellable$iv, this, name, path){
                final /* synthetic */ BracketToolWindowUI this$0;
                final /* synthetic */ String $name$inlined;
                final /* synthetic */ Path $path$inlined;
                {
                    this.this$0 = bracketToolWindowUI;
                    this.$name$inlined = string;
                    this.$path$inlined = path;
                    super($project, $title, $cancellable);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    if (!this.this$0.getProject().isDisposed()) {
                        Object object = this.this$0.getParser().invoke((Object)1);
                        TraceEventParserTimeLine $this$addNewTab_u24lambda_u241_u24lambda_u240 = (TraceEventParserTimeLine)object;
                        boolean bl2 = false;
                        $this$addNewTab_u24lambda_u241_u24lambda_u240.setProgressIndicator(it);
                        TraceEventParserTimeLine parser2 = (TraceEventParserTimeLine)object;
                        EventTraceToolWindowUi.addTab$default(this.this$0, this.$name$inlined, this.$path$inlined, parser2, null, null, 24, null);
                    }
                }
            });
        }

        @Override
        @NotNull
        public TraceEventPanel<EventTraceTimelineModel> getPanel() {
            return this.panel;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004R3\u0010\u0005\u001a!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b0\u0006\u00a2\u0006\u0002\b\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR+\u0010\f\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0004\u0012\u00020\r0\u0006\u00a2\u0006\u0002\b\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/eventtrace/example/BracketEventTracer$IteratorParser;", "Lcom/intellij/profiler/eventtrace/parser/IteratorCombinatorParser;", "Lcom/intellij/profiler/eventtrace/abstractevent/TraceTimeEvent;", "Lcom/intellij/profiler/eventtrace/intervals/TraceEventLineInterval;", "()V", "apply", "Lkotlin/Function1;", "", "", "Lkotlin/ExtensionFunctionType;", "getApply", "()Lkotlin/jvm/functions/Function1;", "enter", "", "getEnter", "intellij.profiler.common"})
    public static final class IteratorParser
    extends IteratorCombinatorParser<TraceTimeEvent, TraceEventLineInterval> {
        @Override
        @NotNull
        public Function1<Iterator<? extends TraceTimeEvent>, Boolean> getEnter() {
            return enter.1.INSTANCE;
        }

        @Override
        @NotNull
        public Function1<Iterator<? extends TraceTimeEvent>, List<TraceEventLineInterval>> getApply() {
            return apply.1.INSTANCE;
        }
    }
}

