/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.eventtrace.toolwindow;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ\u001e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\fR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "lastUpdate", "", "", "Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceService$ComponentPanel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCacheFile", "Lcom/intellij/ui/content/Content;", "id", "lastUpdateTime", "", "remove", "", "component", "setCacheFile", "ComponentPanel", "intellij.profiler.common"})
public final class EventTraceService {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, ComponentPanel> lastUpdate;

    public EventTraceService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.lastUpdate = new HashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Content getCacheFile(@NotNull String id, long lastUpdateTime) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.lastUpdate.containsKey(id)) {
            ComponentPanel componentPanel = this.lastUpdate.get(id);
            Intrinsics.checkNotNull((Object)componentPanel);
            ComponentPanel last = componentPanel;
            if (last.getLastUpdateTime() == lastUpdateTime) {
                return last.getPanel();
            }
            this.lastUpdate.remove(id);
            return null;
        }
        return null;
    }

    public final void setCacheFile(@NotNull String id, long lastUpdateTime, @NotNull Content component) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.lastUpdate.put(id, new ComponentPanel(lastUpdateTime, component));
    }

    public final void remove(@NotNull Content component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        for (Map.Entry<String, ComponentPanel> panels : this.lastUpdate.entrySet()) {
            if (!Intrinsics.areEqual((Object)panels.getValue().getPanel(), (Object)component)) continue;
            this.lastUpdate.remove(panels.getKey());
            break;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceService$ComponentPanel;", "", "lastUpdateTime", "", "panel", "Lcom/intellij/ui/content/Content;", "(JLcom/intellij/ui/content/Content;)V", "getLastUpdateTime", "()J", "getPanel", "()Lcom/intellij/ui/content/Content;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.profiler.common"})
    public static final class ComponentPanel {
        private final long lastUpdateTime;
        @NotNull
        private final Content panel;

        public ComponentPanel(long lastUpdateTime, @NotNull Content panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            this.lastUpdateTime = lastUpdateTime;
            this.panel = panel2;
        }

        public final long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @NotNull
        public final Content getPanel() {
            return this.panel;
        }

        public final long component1() {
            return this.lastUpdateTime;
        }

        @NotNull
        public final Content component2() {
            return this.panel;
        }

        @NotNull
        public final ComponentPanel copy(long lastUpdateTime, @NotNull Content panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            return new ComponentPanel(lastUpdateTime, panel2);
        }

        public static /* synthetic */ ComponentPanel copy$default(ComponentPanel componentPanel, long l, Content content, int n, Object object) {
            if ((n & 1) != 0) {
                l = componentPanel.lastUpdateTime;
            }
            if ((n & 2) != 0) {
                content = componentPanel.panel;
            }
            return componentPanel.copy(l, content);
        }

        @NotNull
        public String toString() {
            return "ComponentPanel(lastUpdateTime=" + this.lastUpdateTime + ", panel=" + this.panel + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.lastUpdateTime);
            result2 = result2 * 31 + this.panel.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComponentPanel)) {
                return false;
            }
            ComponentPanel componentPanel = (ComponentPanel)other;
            if (this.lastUpdateTime != componentPanel.lastUpdateTime) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.panel, (Object)componentPanel.panel);
        }
    }
}

