/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.eventtrace.utils;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.eventtrace.intervals.TraceEventLineIntervalList;
import com.intellij.profiler.eventtrace.utils.TreeUtilsKt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"compressRelaxTree", "", "v", "Ljavax/swing/tree/DefaultMutableTreeNode;", "it", "Lcom/intellij/openapi/progress/ProgressIndicator;", "part", "", "connect", "", "name1", "name2", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nTreeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeUtils.kt\ncom/intellij/profiler/eventtrace/utils/TreeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1864#2,3:69\n*S KotlinDebug\n*F\n+ 1 TreeUtils.kt\ncom/intellij/profiler/eventtrace/utils/TreeUtilsKt\n*L\n42#1:69,3\n*E\n"})
public final class TreeUtilsKt {
    private static final String connect(String name1, String name2) {
        if (((CharSequence)name1).length() == 0) {
            return name2;
        }
        if (((CharSequence)name2).length() == 0) {
            return name1;
        }
        return name1 + " |&| " + name2;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean compressRelaxTree(@NotNull DefaultMutableTreeNode v, @Nullable ProgressIndicator it, double part) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (it != null && it.isCanceled()) {
            return false;
        }
        double onePart = part / (double)(v.getChildCount() + 1);
        Enumeration<TreeNode> enumeration = v.children();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"v.children()");
        Iterator iterator2 = CollectionsKt.iterator(enumeration);
        while (iterator2.hasNext()) {
            TreeNode child = (TreeNode)iterator2.next();
            if (child.isLeaf()) continue;
            Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            boolean isEnded = TreeUtilsKt.compressRelaxTree((DefaultMutableTreeNode)child, it, onePart);
            if (isEnded) continue;
            return false;
        }
        if (v.getChildCount() == 1) {
            TreeNode treeNode = v.getFirstChild();
            Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)treeNode;
            Object object = child.getUserObject();
            if (object instanceof String) {
                Object object2 = child.getUserObject();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
                String name = (String)object2;
                Enumeration<TreeNode> enumeration2 = child.children();
                Intrinsics.checkNotNullExpressionValue(enumeration2, (String)"child.children()");
                ArrayList<TreeNode> arrayList = Collections.list(enumeration2);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
                List<DefaultMutableTreeNode> grandsons2 = ((List)arrayList).stream().map(arg_0 -> TreeUtilsKt.compressRelaxTree$lambda$0(compressRelaxTree.grandsons.1.INSTANCE, arg_0)).toList();
                v.removeAllChildren();
                Intrinsics.checkNotNullExpressionValue(grandsons2, (String)"grandsons");
                Iterable $this$forEachIndexed$iv = grandsons2;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void node2;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)item$iv;
                    int index = n;
                    boolean bl = false;
                    if (index == 0) {
                        if (node2.getUserObject() instanceof String) {
                            Object object3 = node2.getUserObject();
                            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
                            node2.setUserObject(TreeUtilsKt.connect(name, (String)object3));
                        }
                        if (node2.getUserObject() instanceof TraceEventLineIntervalList) {
                            Object object4 = node2.getUserObject();
                            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type com.intellij.profiler.eventtrace.intervals.TraceEventLineIntervalList");
                            TraceEventLineIntervalList traceEventLineIntervalList = (TraceEventLineIntervalList)object4;
                            Object object5 = node2.getUserObject();
                            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type com.intellij.profiler.eventtrace.intervals.TraceEventLineIntervalList");
                            traceEventLineIntervalList.setName(TreeUtilsKt.connect(name, ((TraceEventLineIntervalList)object5).getName()));
                        }
                    }
                    v.add((MutableTreeNode)node2);
                }
            } else if (object instanceof TraceEventLineIntervalList) {
                Object object6 = child.getUserObject();
                Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type com.intellij.profiler.eventtrace.intervals.TraceEventLineIntervalList");
                TraceEventLineIntervalList another = (TraceEventLineIntervalList)object6;
                Object object7 = v.getUserObject();
                Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type kotlin.String");
                String usName = (String)object7;
                another.setName(TreeUtilsKt.connect(usName, another.getName()));
                v.setUserObject(another);
                v.removeAllChildren();
            }
        }
        if (it != null) {
            it.setFraction(it.getFraction() + onePart);
        }
        return true;
    }

    public static /* synthetic */ boolean compressRelaxTree$default(DefaultMutableTreeNode defaultMutableTreeNode, ProgressIndicator progressIndicator, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 0.3333333333333333;
        }
        return TreeUtilsKt.compressRelaxTree(defaultMutableTreeNode, progressIndicator, d);
    }

    private static final DefaultMutableTreeNode compressRelaxTree$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DefaultMutableTreeNode)$tmp0.invoke(p0);
    }
}

