/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.NativeCall;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ui.NativeCallStackElementRenderer;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ui/NativeCallStackElementRenderer;", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "()V", "fillNativeText", "", "node", "Lcom/intellij/profiler/model/NativeCall;", "rect", "Ljava/awt/geom/Rectangle2D;", "fontMetrics", "Ljava/awt/FontMetrics;", "fillTextInsideNode", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nNativeCallStackElementRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeCallStackElementRenderer.kt\ncom/intellij/profiler/ui/NativeCallStackElementRenderer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,45:1\n10#2:46\n*S KotlinDebug\n*F\n+ 1 NativeCallStackElementRenderer.kt\ncom/intellij/profiler/ui/NativeCallStackElementRenderer\n*L\n41#1:46\n*E\n"})
public class NativeCallStackElementRenderer
extends BaseCallStackElementRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final NativeCallStackElementRenderer INSTANCE;

    protected NativeCallStackElementRenderer() {
    }

    @Override
    @NotNull
    public String fillTextInsideNode(@NotNull BaseCallStackElement node2, @NotNull Rectangle2D rect, @NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        if (node2 instanceof NativeCall) {
            try {
                return this.fillNativeText((NativeCall)node2, rect, fontMetrics);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.fillTextInsideNode(node2, rect, fontMetrics);
    }

    private final String fillNativeText(NativeCall node2, Rectangle2D rect, FontMetrics fontMetrics) {
        double maxWidth = rect.getWidth() - 0.0;
        String text2 = this.getText(node2);
        if ((double)fontMetrics.stringWidth(text2) < maxWidth) {
            return text2;
        }
        String methodWithClassOrFunction = node2.methodWithClassOrFunction();
        if ((double)fontMetrics.stringWidth(methodWithClassOrFunction) < maxWidth) {
            return methodWithClassOrFunction;
        }
        String methodWithClassOrFunctionNoArgs = StringsKt.substringBefore$default((String)methodWithClassOrFunction, (String)"(", null, (int)2, null);
        if ((double)fontMetrics.stringWidth(methodWithClassOrFunctionNoArgs) < maxWidth) {
            return methodWithClassOrFunctionNoArgs;
        }
        Pair<List<String>, String> pair = this.classPartsAndMethod(methodWithClassOrFunctionNoArgs, "::");
        List classParts = (List)pair.component1();
        String method = (String)pair.component2();
        if (!((Collection)classParts).isEmpty()) {
            try {
                String abbrevClass2 = CollectionsKt.joinToString$default((Iterable)classParts, (CharSequence)"::", null, null, (int)0, null, (Function1)fillNativeText.abbrevClass.1.INSTANCE, (int)30, null) + "::" + method;
                if ((double)fontMetrics.stringWidth(abbrevClass2) < maxWidth) {
                    return abbrevClass2;
                }
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
        if ((double)fontMetrics.stringWidth(method) < maxWidth) {
            return method;
        }
        return super.fillTextInsideNode(node2, rect, fontMetrics);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NativeCallStackElementRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        INSTANCE = new NativeCallStackElementRenderer();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ui/NativeCallStackElementRenderer$Companion;", "", "()V", "INSTANCE", "Lcom/intellij/profiler/ui/NativeCallStackElementRenderer;", "getINSTANCE", "()Lcom/intellij/profiler/ui/NativeCallStackElementRenderer;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NativeCallStackElementRenderer getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

