/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.table.TableColumnModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\f\r\u000e\u000fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH$J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ui/TableRowsProportionRule;", "", "()V", "adjust", "", "component", "Ljavax/swing/JComponent;", "tableModel", "Ljavax/swing/table/TableColumnModel;", "columnProportions", "", "save", "CustomFirst", "CustomFirstBase", "Equal", "PersistentCustomFirst", "Lcom/intellij/profiler/ui/TableRowsProportionRule$CustomFirstBase;", "Lcom/intellij/profiler/ui/TableRowsProportionRule$Equal;", "intellij.profiler.common"})
public abstract class TableRowsProportionRule {
    private TableRowsProportionRule() {
    }

    public final void adjust(@NotNull JComponent component, @NotNull TableColumnModel tableModel) {
        Container parent;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
        if (tableModel.getColumnCount() < 2) {
            return;
        }
        Container container = parent = component.getParent();
        int viewWidth = container != null ? container.getWidth() : component.getWidth();
        float[] widths = this.columnProportions(tableModel);
        int n = tableModel.getColumnCount();
        for (int c = 0; c < n; ++c) {
            tableModel.getColumn(c).setPreferredWidth((int)(widths[c] * (float)viewWidth));
        }
    }

    @NotNull
    protected abstract float[] columnProportions(@NotNull TableColumnModel var1);

    public void save(@NotNull TableColumnModel tableModel) {
        Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
    }

    public /* synthetic */ TableRowsProportionRule(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ui/TableRowsProportionRule$CustomFirst;", "Lcom/intellij/profiler/ui/TableRowsProportionRule$CustomFirstBase;", "regularProportion", "", "(F)V", "getRegularProportion", "()F", "intellij.profiler.common"})
    public static final class CustomFirst
    extends CustomFirstBase {
        private final float regularProportion;

        public CustomFirst(float regularProportion) {
            this.regularProportion = regularProportion;
        }

        public /* synthetic */ CustomFirst(float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                f = 0.1f;
            }
            this(f);
        }

        @Override
        public float getRegularProportion() {
            return this.regularProportion;
        }

        public CustomFirst() {
            this(0.0f, 1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ui/TableRowsProportionRule$CustomFirstBase;", "Lcom/intellij/profiler/ui/TableRowsProportionRule;", "()V", "regularProportion", "", "getRegularProportion", "()F", "columnProportions", "", "tableModel", "Ljavax/swing/table/TableColumnModel;", "intellij.profiler.common"})
    public static abstract class CustomFirstBase
    extends TableRowsProportionRule {
        public CustomFirstBase() {
            super(null);
        }

        public abstract float getRegularProportion();

        @Override
        @NotNull
        protected float[] columnProportions(@NotNull TableColumnModel tableModel) {
            Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
            float[] result2 = new float[tableModel.getColumnCount()];
            result2[0] = 1.0f - this.getRegularProportion() * (float)(tableModel.getColumnCount() - 1);
            int n = result2.length;
            for (int c = 1; c < n; ++c) {
                result2[c] = this.getRegularProportion();
            }
            return result2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ui/TableRowsProportionRule$Equal;", "Lcom/intellij/profiler/ui/TableRowsProportionRule;", "()V", "columnProportions", "", "tableModel", "Ljavax/swing/table/TableColumnModel;", "intellij.profiler.common"})
    public static final class Equal
    extends TableRowsProportionRule {
        @NotNull
        public static final Equal INSTANCE = new Equal();

        private Equal() {
            super(null);
        }

        @Override
        @NotNull
        protected float[] columnProportions(@NotNull TableColumnModel tableModel) {
            Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
            int n = 0;
            int n2 = tableModel.getColumnCount();
            float[] fArray = new float[n2];
            while (n < n2) {
                int n3 = n++;
                fArray[n3] = 1.0f / (float)tableModel.getColumnCount();
            }
            return fArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/ui/TableRowsProportionRule$PersistentCustomFirst;", "Lcom/intellij/profiler/ui/TableRowsProportionRule$CustomFirstBase;", "propertyGetter", "Lkotlin/Function0;", "", "propertySetter", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "regularProportion", "getRegularProportion", "()F", "save", "tableModel", "Ljavax/swing/table/TableColumnModel;", "intellij.profiler.common"})
    public static final class PersistentCustomFirst
    extends CustomFirstBase {
        @NotNull
        private final Function0<Float> propertyGetter;
        @NotNull
        private final Function1<Float, Unit> propertySetter;

        public PersistentCustomFirst(@NotNull Function0<Float> propertyGetter, @NotNull Function1<? super Float, Unit> propertySetter) {
            Intrinsics.checkNotNullParameter(propertyGetter, (String)"propertyGetter");
            Intrinsics.checkNotNullParameter(propertySetter, (String)"propertySetter");
            this.propertyGetter = propertyGetter;
            this.propertySetter = propertySetter;
        }

        @Override
        public float getRegularProportion() {
            return ((Number)this.propertyGetter.invoke()).floatValue();
        }

        @Override
        public void save(@NotNull TableColumnModel tableModel) {
            Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
            if (tableModel.getColumnCount() < 2) {
                return;
            }
            this.propertySetter.invoke((Object)Float.valueOf((float)tableModel.getColumn(0).getWidth() / (float)tableModel.getTotalColumnWidth()));
        }
    }
}

