/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.profiler.ui.flamegraph.DefaultFlameGraphModel;
import com.intellij.profiler.ui.flamegraph.FlameGraphModel;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.IntUnaryOperator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\t\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010\u0007Ju\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u00052\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u0012\u00a2\u0006\u0002\u0010\u0015J3\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0014J\b\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/profiler/ui/flamegraph/DefaultFlameGraphModel;", "T", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphModel;", "()V", "createNodes", "", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "()[Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "root", "size", "", "start", "", "end", "depth", "includeRoot", "", "computeChildren", "Lkotlin/Function1;", "", "stop", "(Ljava/lang/Object;IDDIZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)[Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "doCreateFlameGraphNode", "content", "(Ljava/lang/Object;DDI)Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "isEmpty", "isRootNodeVisible", "SimpleFlameGraphNode", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nFlameGraphModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlameGraphModel.kt\ncom/intellij/profiler/ui/flamegraph/DefaultFlameGraphModel\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n26#2:123\n1549#3:124\n1620#3,3:125\n1054#3:128\n1855#3,2:129\n*S KotlinDebug\n*F\n+ 1 FlameGraphModel.kt\ncom/intellij/profiler/ui/flamegraph/DefaultFlameGraphModel\n*L\n60#1:123\n83#1:124\n83#1:125,3\n84#1:128\n85#1:129,2\n*E\n"})
public abstract class DefaultFlameGraphModel<T>
implements FlameGraphModel<T> {
    @Override
    public boolean isEmpty() {
        return this.getRoot() == null;
    }

    @NotNull
    protected FlameGraphNode<T> doCreateFlameGraphNode(T content, double start2, double end, int depth) {
        return new SimpleFlameGraphNode<T>(content, start2, end, depth);
    }

    protected boolean isRootNodeVisible() {
        return true;
    }

    @Override
    @NotNull
    public FlameGraphNode<T>[] createNodes() {
        Object t = this.getRoot();
        if (t == null) {
            boolean $i$f$emptyArray = false;
            return new FlameGraphNode[0];
        }
        Object root = t;
        int initialDepth = this.isRootNodeVisible() ? 1 : 0;
        return this.createNodes(root, this.size(), 0.0, 1.0, initialDepth, true, (Function1)new Function1<T, List<? extends T>>(this){
            final /* synthetic */ DefaultFlameGraphModel<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<T> invoke(T it) {
                return this.this$0.getChildren(it);
            }
        }, createNodes.2.INSTANCE);
    }

    @NotNull
    public final FlameGraphNode<T>[] createNodes(T root, int size2, double start2, double end, int depth, boolean includeRoot, @NotNull Function1<? super T, ? extends List<? extends T>> computeChildren, @NotNull Function1<? super T, Boolean> stop) {
        Intrinsics.checkNotNullParameter(computeChildren, (String)"computeChildren");
        Intrinsics.checkNotNullParameter(stop, (String)"stop");
        int totalSize = includeRoot ? size2 : size2 - 1;
        FlameGraphNode[] list = new FlameGraphNode[totalSize];
        LinkedList<FlameGraphNode<T>> queue = new LinkedList<FlameGraphNode<T>>();
        FlameGraphNode<T> rootFlameGraphNode = this.doCreateFlameGraphNode(root, start2, end, depth);
        if (includeRoot) {
            queue.add(rootFlameGraphNode);
        } else {
            DefaultFlameGraphModel.createNodes$addChildren(queue, stop, computeChildren, this, rootFlameGraphNode);
        }
        while (!((Collection)queue).isEmpty()) {
            ProgressManager.checkCanceled();
            FlameGraphNode<T> current = queue.removeFirst();
            list[--totalSize] = current;
            T content = current.getContent();
            if (((Boolean)stop.invoke(content)).booleanValue()) continue;
            Intrinsics.checkNotNullExpressionValue(current, (String)"current");
            DefaultFlameGraphModel.createNodes$addChildren(queue, stop, computeChildren, this, current);
        }
        return list;
    }

    private final int size() {
        FilteredTraverserBase filteredTraverserBase = JBTreeTraverser.from(arg_0 -> DefaultFlameGraphModel.size$lambda$3((Function1)new Function1<T, Iterable<? extends T>>(this){
            final /* synthetic */ DefaultFlameGraphModel<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Iterable<T> invoke(T it) {
                return this.this$0.getChildren(it);
            }
        }, arg_0)).withRoot(this.getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase, (String)"private fun size(): Int \u2026ot(getRoot()).count()\n  }");
        return CollectionsKt.count((Iterable)((Iterable)filteredTraverserBase));
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> void createNodes$addChildren(LinkedList<FlameGraphNode<T>> $this$createNodes_u24addChildren, Function1<? super T, Boolean> $stop, Function1<? super T, ? extends List<? extends T>> $computeChildren, DefaultFlameGraphModel<T> this$0, FlameGraphNode<T> current) {
        void $this$sortedByDescending$iv;
        void $this$mapTo$iv$iv;
        T content = current.getContent();
        if (((Boolean)$stop.invoke(content)).booleanValue()) {
            return;
        }
        double width = current.getEnd() - current.getStart();
        double base = 0.0;
        base = current.getStart();
        List children2 = (List)$computeChildren.invoke(content);
        Iterable $this$map$iv = children2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)this$0.getFractionOfParent((void)content, it)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List childrenWithFraction = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getSecond()));
            }
        });
        Iterable $this$forEach$iv = childrenWithFraction;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Object child = pair.component1();
            double fractionOfParent = ((Number)pair.component2()).doubleValue();
            double delta = width * fractionOfParent;
            if (!(0.0 <= delta ? delta <= width : false)) {
                throw new IllegalArgumentException("fraction of parent must be in interval [0, 1] for " + child + " (was " + delta / width + ")");
            }
            $this$createNodes_u24addChildren.add(this$0.doCreateFlameGraphNode((void)child, base, Math.min(base + delta, current.getEnd()), current.getDepth() + 1));
            base += delta;
        }
    }

    private static final Iterable size$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0003\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ui/flamegraph/DefaultFlameGraphModel$SimpleFlameGraphNode;", "T", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "content", "start", "", "end", "depth", "", "(Ljava/lang/Object;DDI)V", "getContent", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getDepth", "()I", "getEnd", "()D", "getStart", "mapDepth", "transformDepth", "Ljava/util/function/IntUnaryOperator;", "intellij.profiler.common"})
    protected static final class SimpleFlameGraphNode<T>
    implements FlameGraphNode<T> {
        private final T content;
        private final double start;
        private final double end;
        private final int depth;

        public SimpleFlameGraphNode(T content, double start2, double end, int depth) {
            this.content = content;
            this.start = start2;
            this.end = end;
            this.depth = depth;
        }

        @Override
        public T getContent() {
            return this.content;
        }

        @Override
        public double getStart() {
            return this.start;
        }

        @Override
        public double getEnd() {
            return this.end;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        @NotNull
        public FlameGraphNode<T> mapDepth(@NotNull IntUnaryOperator transformDepth) {
            Intrinsics.checkNotNullParameter((Object)transformDepth, (String)"transformDepth");
            return new SimpleFlameGraphNode<T>(this.getContent(), this.getStart(), this.getEnd(), transformDepth.applyAsInt(this.getDepth()));
        }
    }
}

