/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.toolwindow.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.problems.vulnerabilities.Vulnerability;
import org.jetbrains.security.service.PackageChecker;
import org.jetbrains.security.service.PackageCheckerDisposable;
import org.jetbrains.security.service.PackageStatus;
import org.jetbrains.security.service.Unchecked;
import org.jetbrains.security.service.Vulnerable;
import org.jetbrains.security.toolwindow.preview.PackageTitlePanel;
import org.jetbrains.security.toolwindow.preview.VulnerabilityPanels;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B%\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001cH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J \u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001cH\u0016J\u001e\u0010%\u001a\u00020\u00172\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020\u0007H\u0002J\b\u0010*\u001a\u00020\u0017H\u0002J\b\u0010+\u001a\u00020\u0017H\u0002R\u0014\u0010\r\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/security/toolwindow/preview/PackagePreviewPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Ljavax/swing/Scrollable;", "Lcom/intellij/openapi/Disposable;", "Lkotlinx/coroutines/CoroutineScope;", "selectedPackageStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lorg/jetbrains/security/package/Package;", "project", "Lcom/intellij/openapi/project/Project;", "parentContext", "Lkotlin/coroutines/CoroutineContext;", "(Lkotlinx/coroutines/flow/StateFlow;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/CoroutineContext;)V", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "listPanel", "Ljavax/swing/JPanel;", "packageTitle", "Lorg/jetbrains/security/toolwindow/preview/PackageTitlePanel;", "pkgStatus", "Lorg/jetbrains/security/service/PackageStatus;", "clear", "", "dispose", "getPreferredScrollableViewportSize", "Ljava/awt/Dimension;", "getScrollableBlockIncrement", "", "visibleRect", "Ljava/awt/Rectangle;", "orientation", "direction", "getScrollableTracksViewportHeight", "", "getScrollableTracksViewportWidth", "getScrollableUnitIncrement", "renderVulnerabilityList", "vulnerabilities", "", "Lorg/jetbrains/security/problems/vulnerabilities/Vulnerability;", "pkg", "scrollToStart", "unselected", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nPackagePreviewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackagePreviewPanel.kt\norg/jetbrains/security/toolwindow/preview/PackagePreviewPanel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,100:1\n29#2,3:101\n*S KotlinDebug\n*F\n+ 1 PackagePreviewPanel.kt\norg/jetbrains/security/toolwindow/preview/PackagePreviewPanel\n*L\n32#1:101,3\n*E\n"})
public final class PackagePreviewPanel
extends SimpleToolWindowPanel
implements Scrollable,
Disposable,
CoroutineScope {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private PackageTitlePanel packageTitle;
    @NotNull
    private final StateFlow<PackageStatus> pkgStatus;
    @NotNull
    private JPanel listPanel;

    public PackagePreviewPanel(@NotNull StateFlow<Package> selectedPackageStateFlow, @NotNull Project project, @NotNull CoroutineContext parentContext) {
        Intrinsics.checkNotNullParameter(selectedPackageStateFlow, (String)"selectedPackageStateFlow");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentContext, (String)"parentContext");
        super(true);
        this.project = project;
        this.coroutineContext = parentContext.plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)).plus((CoroutineContext)new CoroutineName("PackageChecker.PackagePreviewPanel"));
        this.packageTitle = new PackageTitlePanel(null);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<PackageChecker> serviceClass$iv = PackageChecker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        this.pkgStatus = FlowKt.stateIn((Flow)FlowKt.flowCombine((Flow)((Flow)selectedPackageStateFlow), (Flow)((Flow)((PackageChecker)object).getVulnerabilitiesFlow()), (Function3)((Function3)new Function3<Package, Map<Package, ? extends PackageStatus>, Continuation<? super PackageStatus>, Object>(null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        PackageStatus packageStatus;
                        ResultKt.throwOnFailure((Object)object);
                        Package pkg = (Package)this.L$0;
                        Map statuses = (Map)this.L$1;
                        if (pkg != null) {
                            boolean bl = false;
                            Object object2 = statuses.get(pkg);
                            if (object2 == null) {
                                boolean bl2 = false;
                                object2 = new Unchecked(pkg);
                            }
                            packageStatus = (PackageStatus)object2;
                        } else {
                            packageStatus = null;
                        }
                        return packageStatus;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@Nullable Package p1, @NotNull Map<Package, ? extends PackageStatus> p2, @Nullable Continuation<? super PackageStatus> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this, (SharingStarted)SharingStarted.Companion.getEagerly(), null);
        this.listPanel = new JPanel();
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
        BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PackagePreviewPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)FlowKt.onEach((Flow)((Flow)this.this$0.pkgStatus), (Function2)((Function2)new Function2<PackageStatus, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ PackagePreviewPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        PackageStatus it = (PackageStatus)this.L$0;
                                        this.this$0.clear();
                                        this.this$0.packageTitle.setPackageStatus(it);
                                        if (it instanceof Vulnerable) {
                                            this.this$0.renderVulnerabilityList(((Vulnerable)it).getVulnerablePackage().getVulnerabilities(), ((Vulnerable)it).getPkg());
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@Nullable PackageStatus p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        })), (Function2)((Function2)new Function2<PackageStatus, Continuation<? super Unit>, Object>(null){
                            int label;

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@Nullable PackageStatus p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.packageTitle), "North");
        this.add(this.listPanel, "Center");
        this.packageTitle.setFocusable(true);
        this.listPanel.setFocusable(true);
        this.listPanel.setLayout(new BoxLayout(this.listPanel, 1));
        this.revalidate();
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    private final void renderVulnerabilityList(List<Vulnerability> vulnerabilities, Package pkg) {
        this.listPanel.add((Component)((Object)new VulnerabilityPanels(vulnerabilities, pkg, this.project)));
        this.revalidate();
        this.scrollToStart();
    }

    private final void unselected() {
        this.clear();
    }

    private final void clear() {
        this.listPanel.removeAll();
        this.revalidate();
    }

    private final void scrollToStart() {
        this.packageTitle.requestFocusInWindow();
        this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.revalidate();
    }

    @Override
    @NotNull
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"preferredSize");
        return dimension;
    }

    @Override
    public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        return 100;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void dispose() {
        JobKt.cancel$default((CoroutineContext)this.getCoroutineContext(), null, (int)1, null);
    }
}

