/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.util.PerformanceCounter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass;", "Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "className", "Lorg/jetbrains/kotlin/name/ClassId;", "classVersion", "", "classHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "innerClasses", "Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/ClassId;ILorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo;)V", "containingLibrary", "", "getContainingLibrary", "()Ljava/lang/String;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "location", "getLocation", "equals", "", "other", "", "getFileContents", "", "hashCode", "toString", "Factory", "frontend.common.jvm"})
public final class VirtualFileKotlinClass
extends FileBasedKotlinClass {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final VirtualFile file;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final PerformanceCounter perfCounter;

    private VirtualFileKotlinClass(VirtualFile file2, ClassId className2, int classVersion, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses) {
        super(className2, classVersion, classHeader, innerClasses);
        this.file = file2;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public String getLocation() {
        String string2 = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
        return string2;
    }

    @Override
    @Nullable
    public String getContainingLibrary() {
        String string2 = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
        String[] stringArray = new String[]{"!/"};
        return (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    @Override
    @NotNull
    protected byte[] getFileContents() {
        try {
            byte[] byArray = this.file.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"file.contentsToByteArray()");
            return byArray;
        }
        catch (IOException e) {
            throw VirtualFileKotlinClass.Factory.logFileReadingErrorMessage(e, this.file);
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof VirtualFileKotlinClass && Intrinsics.areEqual((Object)((VirtualFileKotlinClass)other).file, (Object)this.file);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.file;
    }

    public /* synthetic */ VirtualFileKotlinClass(VirtualFile file2, ClassId className2, int classVersion, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses, DefaultConstructorMarker $constructor_marker) {
        this(file2, className2, classVersion, classHeader, innerClasses);
    }

    static {
        Logger logger = Logger.getInstance(VirtualFileKotlinClass.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(VirtualFileKotlinClass::class.java)");
        LOG = logger;
        perfCounter = PerformanceCounter.Companion.create$default(PerformanceCounter.Companion, "Binary class from Kotlin file", false, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass$Factory;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "perfCounter", "Lorg/jetbrains/kotlin/util/PerformanceCounter;", "create", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "jvmMetadataVersion", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "fileContent", "", "create$frontend_common_jvm", "logFileReadingErrorMessage", "", "e", "renderFileReadingErrorMessage", "", "frontend.common.jvm"})
    public static final class Factory {
        private Factory() {
        }

        @Nullable
        public final KotlinClassFinder.Result create$frontend_common_jvm(@NotNull VirtualFile file2, @NotNull JvmMetadataVersion jvmMetadataVersion, @Nullable byte[] fileContent) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"jvmMetadataVersion");
            return (KotlinClassFinder.Result)perfCounter.time((Function0)new Function0<KotlinClassFinder.Result>(file2, fileContent, jvmMetadataVersion){
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ byte[] $fileContent;
                final /* synthetic */ JvmMetadataVersion $jvmMetadataVersion;
                {
                    this.$file = $file;
                    this.$fileContent = $fileContent;
                    this.$jvmMetadataVersion = $jvmMetadataVersion;
                    super(0);
                }

                @Nullable
                public final KotlinClassFinder.Result invoke() {
                    boolean bl = Intrinsics.areEqual((Object)this.$file.getExtension(), (Object)JavaClassFileType.INSTANCE.getDefaultExtension()) || Intrinsics.areEqual((Object)this.$file.getFileType(), (Object)JavaClassFileType.INSTANCE);
                    VirtualFile virtualFile = this.$file;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl2 = false;
                        String string2 = "Trying to read binary data from a non-class file " + virtualFile;
                        throw new AssertionError((Object)string2);
                    }
                    try {
                        byte[] byteContent;
                        byte[] byArray = this.$fileContent;
                        if (this.$fileContent == null) {
                            byte[] byArray2 = this.$file.contentsToByteArray(false);
                            byArray = byArray2;
                            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"file.contentsToByteArray(false)");
                        }
                        if (!((byteContent = byArray).length == 0)) {
                            KotlinClassFinder.Result result2;
                            VirtualFileKotlinClass kotlinJvmBinaryClass2;
                            VirtualFileKotlinClass virtualFileKotlinClass = kotlinJvmBinaryClass2 = (VirtualFileKotlinClass)FileBasedKotlinClass.create(byteContent, this.$jvmMetadataVersion, (Function4)new Function4<ClassId, Integer, KotlinClassHeader, FileBasedKotlinClass.InnerClassesInfo, VirtualFileKotlinClass>(this.$file){
                                final /* synthetic */ VirtualFile $file;
                                {
                                    this.$file = $file;
                                    super(4);
                                }

                                public final VirtualFileKotlinClass invoke(ClassId name2, Integer classVersion, KotlinClassHeader header, FileBasedKotlinClass.InnerClassesInfo innerClasses) {
                                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
                                    Intrinsics.checkNotNullExpressionValue((Object)classVersion, (String)"classVersion");
                                    int n = classVersion;
                                    Intrinsics.checkNotNullExpressionValue((Object)header, (String)"header");
                                    Intrinsics.checkNotNullExpressionValue((Object)innerClasses, (String)"innerClasses");
                                    return new VirtualFileKotlinClass(this.$file, name2, n, header, innerClasses, null);
                                }
                            });
                            if (virtualFileKotlinClass != null) {
                                VirtualFileKotlinClass it = virtualFileKotlinClass;
                                boolean bl3 = false;
                                result2 = new KotlinClassFinder.Result.KotlinClass(it, byteContent);
                            } else {
                                result2 = new KotlinClassFinder.Result.ClassFileContent(byteContent);
                            }
                            return result2;
                        }
                    }
                    catch (FileNotFoundException byteContent) {
                    }
                    catch (Throwable e) {
                        if (e instanceof ControlFlowException) {
                            throw e;
                        }
                        throw org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass$Factory.access$logFileReadingErrorMessage(VirtualFileKotlinClass.Factory, e, this.$file);
                    }
                    return null;
                }
            });
        }

        private final Throwable logFileReadingErrorMessage(Throwable e, VirtualFile file2) {
            String errorMessage2 = this.renderFileReadingErrorMessage(file2);
            LOG.warn(errorMessage2, e);
            return new IllegalStateException(errorMessage2, e);
        }

        private final String renderFileReadingErrorMessage(VirtualFile file2) {
            return "Could not read file: " + file2.getPath() + "; size in bytes: " + file2.getLength() + "; file type: " + file2.getFileType().getName();
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

