/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLinesProviderKt;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellSelectionModel;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellSelectionModelProvider;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"!\u0010\u0002\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00040\u00040\u0003\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u0004*\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0015\u0010\u000b\u001a\u00020\f*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"ID", "", "key", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellSelectionModel;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "cellSelectionModel", "Lcom/intellij/openapi/editor/Editor;", "getCellSelectionModel", "(Lcom/intellij/openapi/editor/Editor;)Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellSelectionModel;", "hasCellSelectionModelSupport", "", "getHasCellSelectionModelSupport", "(Lcom/intellij/openapi/editor/Editor;)Z", "getProvider", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellSelectionModelProvider;", "editor", "install", "intellij.notebooks.visualization"})
public final class NotebookCellSelectionModelProviderKt {
    @NotNull
    private static final Key<NotebookCellSelectionModel> key;
    @NotNull
    private static final String ID = "org.jetbrains.plugins.notebooks.notebookCellSelectionModelProvider";

    @RequiresEdt
    @Nullable
    public static final NotebookCellSelectionModel getCellSelectionModel(@NotNull Editor $this$cellSelectionModel) {
        Intrinsics.checkNotNullParameter((Object)$this$cellSelectionModel, (String)"<this>");
        ApplicationManager.getApplication().assertIsDispatchThread();
        NotebookCellSelectionModel notebookCellSelectionModel = (NotebookCellSelectionModel)key.get((UserDataHolder)$this$cellSelectionModel);
        if (notebookCellSelectionModel == null) {
            notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.install($this$cellSelectionModel);
        }
        return notebookCellSelectionModel;
    }

    public static final boolean getHasCellSelectionModelSupport(@NotNull Editor $this$hasCellSelectionModelSupport) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCellSelectionModelSupport, (String)"<this>");
        return key.get((UserDataHolder)$this$hasCellSelectionModelSupport) != null || NotebookCellSelectionModelProviderKt.getProvider($this$hasCellSelectionModelSupport) != null;
    }

    private static final NotebookCellSelectionModel install(Editor editor) {
        NotebookCellSelectionModelProvider notebookCellSelectionModelProvider = NotebookCellSelectionModelProviderKt.getProvider(editor);
        NotebookCellSelectionModel model = notebookCellSelectionModelProvider != null ? notebookCellSelectionModelProvider.create(editor) : null;
        key.set((UserDataHolder)editor, (Object)model);
        return model;
    }

    private static final NotebookCellSelectionModelProvider getProvider(Editor editor) {
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Language language = NotebookCellLinesProviderKt.getLanguage(project2, document);
        if (language == null) {
            return null;
        }
        Language language2 = language;
        return (NotebookCellSelectionModelProvider)NotebookCellSelectionModelProvider.Companion.forLanguage(language2);
    }

    static {
        Key key = Key.create((String)NotebookCellSelectionModel.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<NotebookCellSelec\u2026onModel::class.java.name)");
        NotebookCellSelectionModelProviderKt.key = key;
    }
}

