/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays;

import com.intellij.ide.ui.UISettings;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.EditorInlaysManager;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.InlayComponent;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.InlayDimensions;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.InlayEditorManagerKt;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.InlayElementDescriptor;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.InlayOutput;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.MouseWheelUtils;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.NotebookInlayComponentPsi;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.InlayProgressStatus;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 N2\u00020\u0001:\u0001NB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020 H\u0002J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\rH\u0002J\u001e\u0010%\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u00112\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\b\u0010)\u001a\u00020 H\u0002J\"\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020-2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/J\b\u00100\u001a\u00020 H\u0002J\u0006\u00101\u001a\u00020 J\u0012\u00102\u001a\u0004\u0018\u00010\u00112\u0006\u0010$\u001a\u00020\rH\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u00104\u001a\u00020\u00172\u0006\u00105\u001a\u00020\rH\u0002J\b\u00106\u001a\u00020 H\u0002J\u001a\u00107\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u00112\b\b\u0002\u00108\u001a\u00020\u0017H\u0002J\b\u00109\u001a\u00020 H\u0002J\f\u0010:\u001a\u0006\u0012\u0002\b\u00030;H\u0002J\u0018\u0010<\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020\u001dH\u0002J\u0010\u0010>\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J0\u0010?\u001a\b\u0012\u0004\u0012\u00020 0@2\u0006\u0010+\u001a\u00020\r2\u0010\b\u0002\u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'2\b\b\u0002\u0010A\u001a\u00020\u0017J\b\u0010B\u001a\u00020 H\u0002J \u0010C\u001a\u00020 2\u0006\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020FH\u0002J\u0010\u0010H\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u001c\u0010I\u001a\b\u0012\u0004\u0012\u00020 0@2\u0006\u0010+\u001a\u00020\r2\u0006\u0010J\u001a\u00020KJ\b\u0010L\u001a\u00020 H\u0002J\b\u0010M\u001a\u00020 H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/EditorInlaysManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "descriptor", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/InlayElementDescriptor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/impl/EditorImpl;Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/InlayElementDescriptor;)V", "getDescriptor", "()Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/InlayElementDescriptor;", "inlayElements", "Ljava/util/LinkedHashSet;", "Lcom/intellij/psi/PsiElement;", "Lkotlin/collections/LinkedHashSet;", "inlays", "", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/NotebookInlayComponentPsi;", "getProject", "()Lcom/intellij/openapi/project/Project;", "scrollKeeper", "Lcom/intellij/openapi/editor/ex/util/EditorScrollingPositionKeeper;", "toolbarUpdateScheduled", "", "viewportQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "addBlockElement", "Lcom/intellij/openapi/editor/Inlay;", "offset", "", "inlayComponent", "addCaretListener", "", "addDocumentListener", "addFoldingListener", "addInlayComponent", "cell", "addInlayOutputs", "inlayOutputs", "", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/InlayOutput;", "addResizeListener", "addTextToInlay", "psi", "message", "", "outputType", "Lcom/intellij/openapi/util/Key;", "addViewportListener", "dispose", "getInlayComponent", "getInlayComponentByOffset", "isOutputPositionCollapsed", "psiCell", "onCaretPositionChanged", "removeInlay", "cleanup", "restoreOutputs", "restoreToolbars", "Lorg/jetbrains/concurrency/CancellablePromise;", "scheduleIntervalUpdate", "length", "setupInlayComponent", "updateCell", "Ljava/util/concurrent/Future;", "createTextOutput", "updateInlayComponentsWidth", "updateInlayForViewport", "element", "viewportRange", "Lkotlin/ranges/IntRange;", "expansionRange", "updateInlayPosition", "updateInlayProgressStatus", "progressStatus", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayProgressStatus;", "updateInlays", "updateInlaysForViewport", "Companion", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nInlayEditorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayEditorManager.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/EditorInlaysManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,452:1\n1855#2,2:453\n766#2:456\n857#2,2:457\n1855#2,2:459\n288#2,2:463\n288#2,2:465\n1855#2,2:467\n1855#2,2:469\n1855#2,2:471\n1855#2,2:473\n1855#2,2:475\n1#3:455\n13579#4,2:461\n*S KotlinDebug\n*F\n+ 1 InlayEditorManager.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/EditorInlaysManager\n*L\n82#1:453,2\n252#1:456\n252#1:457,2\n252#1:459,2\n300#1:463,2\n302#1:465,2\n324#1:467,2\n328#1:469,2\n336#1:471,2\n367#1:473,2\n348#1:475,2\n255#1:461,2\n*E\n"})
public final class EditorInlaysManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final InlayElementDescriptor descriptor;
    @NotNull
    private final Map<PsiElement, NotebookInlayComponentPsi> inlays;
    @NotNull
    private final LinkedHashSet<PsiElement> inlayElements;
    @NotNull
    private final EditorScrollingPositionKeeper scrollKeeper;
    @NotNull
    private final MergingUpdateQueue viewportQueue;
    private volatile boolean toolbarUpdateScheduled;
    @NotNull
    private static final String VIEWPORT_TASK_NAME = "On viewport change";
    @NotNull
    private static final String VIEWPORT_TASK_IDENTITY = "On viewport change task";
    private static final int VIEWPORT_TIME_SPAN = 50;
    public static final int INLAY_PRIORITY = 0;
    @TestOnly
    private static boolean isEnabledInTests;

    public EditorInlaysManager(@NotNull Project project, @NotNull EditorImpl editor, @NotNull InlayElementDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.project = project;
        this.editor = editor;
        this.descriptor = descriptor;
        this.inlays = new LinkedHashMap();
        this.inlayElements = new LinkedHashSet();
        this.scrollKeeper = new EditorScrollingPositionKeeper((Editor)this.editor);
        this.viewportQueue = new MergingUpdateQueue(VIEWPORT_TASK_NAME, 50, true, null, (Disposable)this.project);
        this.addResizeListener();
        this.addCaretListener();
        this.addFoldingListener();
        this.addDocumentListener();
        this.addViewportListener();
        this.editor.getSettings().setRightMarginShown(false);
        UISettings.Companion.getInstance().setShowEditorToolTip(false);
        MouseWheelUtils.INSTANCE.wrapEditorMouseWheelListeners(this.editor);
        this.restoreToolbars().onSuccess(arg_0 -> EditorInlaysManager._init_$lambda$0(this, arg_0));
        this.onCaretPositionChanged();
        ApplicationManager.getApplication().invokeLater(() -> EditorInlaysManager._init_$lambda$1(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final InlayElementDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final void dispose() {
        Iterable $this$forEach$iv = this.inlays.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookInlayComponentPsi it = (NotebookInlayComponentPsi)element$iv;
            boolean bl = false;
            it.disposeInlay();
            it.dispose();
        }
        this.inlays.clear();
        this.inlayElements.clear();
    }

    @NotNull
    public final Future<Unit> updateCell(@NotNull PsiElement psi, @Nullable List<InlayOutput> inlayOutputs, boolean createTextOutput) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        FutureResult result = new FutureResult();
        if (ApplicationManager.getApplication().isUnitTestMode() && !isEnabledInTests) {
            FutureResult futureResult;
            FutureResult $this$updateCell_u24lambda_u243 = futureResult = result;
            boolean bl = false;
            $this$updateCell_u24lambda_u243.set((Object)Unit.INSTANCE);
            return (Future)futureResult;
        }
        ApplicationManager.getApplication().invokeLater(() -> EditorInlaysManager.updateCell$lambda$7(this, result, psi, inlayOutputs, createTextOutput));
        return (Future)result;
    }

    public static /* synthetic */ Future updateCell$default(EditorInlaysManager editorInlaysManager, PsiElement psiElement, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return editorInlaysManager.updateCell(psiElement, list, bl);
    }

    private final boolean isOutputPositionCollapsed(PsiElement psiCell) {
        return this.editor.getFoldingModel().isOffsetCollapsed(this.descriptor.getInlayOffset(psiCell));
    }

    public final void addTextToInlay(@NotNull PsiElement psi, @NotNull String message, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, psi, message, outputType){
            final /* synthetic */ EditorInlaysManager this$0;
            final /* synthetic */ PsiElement $psi;
            final /* synthetic */ String $message;
            final /* synthetic */ Key<?> $outputType;
            {
                this.this$0 = $receiver;
                this.$psi = $psi;
                this.$message = $message;
                this.$outputType = $outputType;
                super(0);
            }

            public final void invoke() {
                EditorInlaysManager.access$getScrollKeeper$p(this.this$0).savePosition();
                NotebookInlayComponentPsi notebookInlayComponentPsi = EditorInlaysManager.access$getInlayComponent(this.this$0, this.$psi);
                if (notebookInlayComponentPsi != null) {
                    notebookInlayComponentPsi.addText(this.$message, this.$outputType);
                }
                EditorInlaysManager.access$getScrollKeeper$p(this.this$0).restorePosition(true);
            }
        }), (int)1, null);
    }

    @NotNull
    public final Future<Unit> updateInlayProgressStatus(@NotNull PsiElement psi, @NotNull InlayProgressStatus progressStatus) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)progressStatus, (String)"progressStatus");
        FutureResult result = new FutureResult();
        ApplicationManager.getApplication().invokeLater(() -> EditorInlaysManager.updateInlayProgressStatus$lambda$8(this, psi, progressStatus, result));
        return (Future)result;
    }

    private final void updateInlaysForViewport() {
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ EditorInlaysManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (EditorInlaysManager.access$getEditor$p(this.this$0).isDisposed()) {
                    return;
                }
                IntRange viewportRange = InlayEditorManagerKt.calculateViewportRange(EditorInlaysManager.access$getEditor$p(this.this$0));
                IntRange expansionRange = InlayEditorManagerKt.calculateInlayExpansionRange(EditorInlaysManager.access$getEditor$p(this.this$0), viewportRange);
                for (PsiElement element : EditorInlaysManager.access$getInlayElements$p(this.this$0)) {
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                    EditorInlaysManager.access$updateInlayForViewport(this.this$0, element, viewportRange, expansionRange);
                }
            }
        }), (int)1, null);
    }

    private final void updateInlayForViewport(PsiElement element, IntRange viewportRange, IntRange expansionRange) {
        NotebookInlayComponentPsi inlay = this.inlays.get(element);
        if (inlay != null) {
            Rectangle bounds = inlay.getBounds();
            boolean isInViewport = bounds.y <= viewportRange.getLast() && bounds.y + bounds.height >= viewportRange.getFirst();
            inlay.onViewportChange(isInViewport);
        } else {
            int n = expansionRange.getFirst();
            int n2 = expansionRange.getLast();
            int n3 = element.getTextRange().getStartOffset();
            boolean bl = n <= n3 ? n3 <= n2 : false;
            if (bl) {
                EditorInlaysManager.updateCell$default(this, element, null, false, 6, null);
            }
        }
    }

    private final void addInlayOutputs(NotebookInlayComponentPsi inlayComponent, List<InlayOutput> inlayOutputs) {
        inlayComponent.addInlayOutputs(inlayOutputs, (Function0<Unit>)((Function0)new Function0<Unit>(this, inlayComponent){
            final /* synthetic */ EditorInlaysManager this$0;
            final /* synthetic */ NotebookInlayComponentPsi $inlayComponent;
            {
                this.this$0 = $receiver;
                this.$inlayComponent = $inlayComponent;
                super(0);
            }

            public final void invoke() {
                EditorInlaysManager.removeInlay$default(this.this$0, this.$inlayComponent, false, 2, null);
            }
        }));
    }

    private final void removeInlay(NotebookInlayComponentPsi inlayComponent, boolean cleanup) {
        PsiElement cell = inlayComponent.getCell();
        if (cleanup && cell.isValid()) {
            this.descriptor.cleanup(cell);
        }
        Container container = inlayComponent.getParent();
        if (container != null) {
            container.remove(inlayComponent);
        }
        inlayComponent.disposeInlay();
        inlayComponent.dispose();
        this.inlays.remove(cell);
    }

    static /* synthetic */ void removeInlay$default(EditorInlaysManager editorInlaysManager, NotebookInlayComponentPsi notebookInlayComponentPsi, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        editorInlaysManager.removeInlay(notebookInlayComponentPsi, bl);
    }

    private final void addFoldingListener() {
        FoldingListener listener2 = new FoldingListener(this){
            @NotNull
            private final ArrayList<addFoldingListener.Region> regions;
            final /* synthetic */ EditorInlaysManager this$0;
            {
                this.this$0 = $receiver;
                @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"org/jetbrains/plugins/notebooks/visualization/r/inlays/EditorInlaysManager$addFoldingListener$Region", "", "textRange", "Lcom/intellij/openapi/util/TextRange;", "isExpanded", "", "(Lcom/intellij/openapi/util/TextRange;Z)V", "()Z", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "component1", "component2", "copy", "(Lcom/intellij/openapi/util/TextRange;Z)Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/EditorInlaysManager$addFoldingListener$Region;", "equals", "other", "hashCode", "", "toString", "", "intellij.notebooks.visualization"})
                public final class addFoldingListener.Region {
                    @NotNull
                    private final TextRange textRange;
                    private final boolean isExpanded;

                    public addFoldingListener.Region(@NotNull TextRange textRange, boolean isExpanded) {
                        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
                        this.textRange = textRange;
                        this.isExpanded = isExpanded;
                    }

                    @NotNull
                    public final TextRange getTextRange() {
                        return this.textRange;
                    }

                    public final boolean isExpanded() {
                        return this.isExpanded;
                    }

                    @NotNull
                    public final TextRange component1() {
                        return this.textRange;
                    }

                    public final boolean component2() {
                        return this.isExpanded;
                    }

                    @NotNull
                    public final addFoldingListener.Region copy(@NotNull TextRange textRange, boolean isExpanded) {
                        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
                        return new addFoldingListener.Region(textRange, isExpanded);
                    }

                    public static /* synthetic */ addFoldingListener.Region copy$default(addFoldingListener.Region region, TextRange textRange, boolean bl, int n, Object object) {
                        if ((n & 1) != 0) {
                            textRange = region.textRange;
                        }
                        if ((n & 2) != 0) {
                            bl = region.isExpanded;
                        }
                        return region.copy(textRange, bl);
                    }

                    @NotNull
                    public String toString() {
                        return "Region(textRange=" + this.textRange + ", isExpanded=" + this.isExpanded + ")";
                    }

                    public int hashCode() {
                        int result = this.textRange.hashCode();
                        int n = (int)(this.isExpanded ? 1 : 0);
                        if (n != 0) {
                            n = 1;
                        }
                        result = result * 31 + n;
                        return result;
                    }

                    public boolean equals(@Nullable Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof addFoldingListener.Region)) {
                            return false;
                        }
                        addFoldingListener.Region region = (addFoldingListener.Region)other;
                        if (!Intrinsics.areEqual((Object)this.textRange, (Object)region.textRange)) {
                            return false;
                        }
                        return this.isExpanded == region.isExpanded;
                    }
                }
                this.regions = new ArrayList<E>();
            }

            public void onFoldRegionStateChange(@NotNull FoldRegion region) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                if (region.isValid()) {
                    TextRange textRange = TextRange.create((int)region.getStartOffset(), (int)region.getEndOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(region.startOffset, region.endOffset)");
                    this.regions.add(new Region(textRange, region.isExpanded()));
                }
            }

            /*
             * WARNING - void declaration
             */
            public void onFoldProcessingEnd() {
                void $this$filterTo$iv$iv;
                void $this$forEach$iv;
                Iterator<Map.Entry<K, V>> $this$filterTo$iv$iv2;
                Object $this$filter$iv;
                Map map = EditorInlaysManager.access$getInlays$p(this.this$0);
                EditorInlaysManager editorInlaysManager = this.this$0;
                boolean $i$f$filter = false;
                Iterator<T> iterator = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$filterTo = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> element$iv$iv;
                    Map.Entry<K, V> pair = element$iv$iv = iterator2.next();
                    boolean bl = false;
                    if (!EditorInlaysManager.access$isOutputPositionCollapsed(editorInlaysManager, (PsiElement)pair.getKey())) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$filter$iv = destination$iv$iv;
                editorInlaysManager = this.this$0;
                boolean $i$f$forEach22 = false;
                $this$filterTo$iv$iv2 = $this$forEach$iv.entrySet().iterator();
                while ($this$filterTo$iv$iv2.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> it = element$iv = $this$filterTo$iv$iv2.next();
                    boolean bl = false;
                    EditorInlaysManager.access$removeInlay(editorInlaysManager, (NotebookInlayComponentPsi)it.getValue(), false);
                }
                $this$filter$iv = EditorInlaysManager.access$getInlayElements$p(this.this$0);
                boolean $i$f$filter2 = false;
                Object $i$f$forEach22 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo2 = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    block8: {
                        void $this$any$iv;
                        void $this$filterTo$iv$iv3;
                        PsiElement key = (PsiElement)element$iv$iv;
                        boolean bl2 = false;
                        Iterable $this$filter$iv2 = this.regions;
                        boolean $i$f$filter3 = false;
                        Iterable iterable = $this$filter$iv2;
                        Collection destination$iv$iv3 = new ArrayList<E>();
                        boolean $i$f$filterTo3 = false;
                        for (T element$iv$iv2 : $this$filterTo$iv$iv3) {
                            Region it = (Region)element$iv$iv2;
                            boolean bl3 = false;
                            if (!it.isExpanded()) continue;
                            destination$iv$iv3.add(element$iv$iv2);
                        }
                        $this$filter$iv2 = (List)destination$iv$iv3;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (E element$iv : $this$any$iv) {
                                Region it = (Region)element$iv;
                                boolean bl4 = false;
                                if (!key.getTextRange().intersects(it.getTextRange())) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                EditorInlaysManager editorInlaysManager2 = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    EditorInlaysManager.updateCell$default(editorInlaysManager2, it, null, false, 6, null);
                }
                this.regions.clear();
                EditorInlaysManager.access$updateInlays(this.this$0);
            }
        };
        this.editor.getFoldingModel().addListener(listener2, this.editor.getDisposable());
    }

    private final void addDocumentListener() {
        this.editor.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ EditorInlaysManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.this$0.getProject().isDisposed()) {
                    return;
                }
                if (!EditorInlaysManager.access$getToolbarUpdateScheduled$p(this.this$0)) {
                    EditorInlaysManager.access$setToolbarUpdateScheduled$p(this.this$0, true);
                    PsiDocumentManager.getInstance((Project)this.this$0.getProject()).performForCommittedDocument((Document)EditorInlaysManager.access$getEditor$p(this.this$0).getDocument(), () -> addDocumentListener.1.documentChanged$lambda$0(this.this$0, event));
                }
                if (!this.this$0.getDescriptor().shouldUpdateInlays(event)) {
                    return;
                }
                PsiDocumentManager.getInstance((Project)this.this$0.getProject()).performForCommittedDocument((Document)EditorInlaysManager.access$getEditor$p(this.this$0).getDocument(), () -> addDocumentListener.1.documentChanged$lambda$1(this.this$0));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final void documentChanged$lambda$0(EditorInlaysManager this$0, DocumentEvent $event) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
                try {
                    EditorInlaysManager.access$scheduleIntervalUpdate(this$0, $event.getOffset(), $event.getNewFragment().length());
                }
                finally {
                    EditorInlaysManager.access$setToolbarUpdateScheduled$p(this$0, false);
                }
            }

            private static final void documentChanged$lambda$1(EditorInlaysManager this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                EditorInlaysManager.access$updateInlays(this$0);
            }
        }, this.editor.getDisposable());
    }

    /*
     * WARNING - void declaration
     */
    private final void scheduleIntervalUpdate(int offset, int length) {
        Object[] $this$forEach$iv;
        void $this$filterTo$iv$iv;
        PsiElement node;
        PsiFile psiFile = this.descriptor.getPsiFile();
        ASTNode aSTNode = psiFile.getNode().findLeafElementAt(offset);
        Object object = node = aSTNode != null ? aSTNode.getPsi() : null;
        while (node != null && !Intrinsics.areEqual((Object)node.getParent(), (Object)psiFile)) {
            node = node.getParent();
        }
        Iterable $this$filter$iv = this.inlayElements;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl = false;
            if (!(!it.isValid())) continue;
            collection.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection;
        boolean $i$f$forEach = false;
        for (Object e : $this$forEach$iv) {
            NotebookInlayComponentPsi inlay;
            PsiElement it = (PsiElement)e;
            boolean bl = false;
            if (this.getInlayComponent(it) == null) continue;
            boolean bl2 = false;
            EditorInlaysManager.removeInlay$default(this, inlay, false, 2, null);
        }
        this.inlayElements.removeIf(arg_0 -> EditorInlaysManager.scheduleIntervalUpdate$lambda$12(scheduleIntervalUpdate.3.INSTANCE, arg_0));
        while (node != null && node.getTextRange().getStartOffset() < offset + length) {
            PsiElement[] psiElementArray = PsiTreeUtil.collectElements((PsiElement)node, arg_0 -> EditorInlaysManager.scheduleIntervalUpdate$lambda$13(this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"collectElements(node) { \u2026tor.isInlayElement(psi) }");
            $this$forEach$iv = psiElementArray;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement psi = (PsiElement)element$iv;
                boolean bl = false;
                this.inlayElements.add(psi);
            }
            node = node.getNextSibling();
        }
    }

    private final void addResizeListener() {
        this.editor.getComponent().addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ EditorInlaysManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                EditorInlaysManager.access$updateInlayComponentsWidth(this.this$0);
            }
        });
    }

    private final void addViewportListener() {
        this.editor.getScrollPane().getViewport().addChangeListener(arg_0 -> EditorInlaysManager.addViewportListener$lambda$15(this, arg_0));
    }

    private final void restoreOutputs() {
        this.updateInlaysForViewport();
    }

    private final CancellablePromise<?> restoreToolbars() {
        ArrayList<PsiElement> inlaysPsiElements = new ArrayList<PsiElement>();
        CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> EditorInlaysManager.restoreToolbars$lambda$16(this, inlaysPsiElements)).finishOnUiThread(ModalityState.nonModal(), arg_0 -> EditorInlaysManager.restoreToolbars$lambda$17((Function1)new Function1<Void, Unit>(this, inlaysPsiElements){
            final /* synthetic */ EditorInlaysManager this$0;
            final /* synthetic */ ArrayList<PsiElement> $inlaysPsiElements;
            {
                this.this$0 = $receiver;
                this.$inlaysPsiElements = $inlaysPsiElements;
                super(1);
            }

            public final void invoke(Void it) {
                EditorInlaysManager.access$getInlayElements$p(this.this$0).clear();
                EditorInlaysManager.access$getInlayElements$p(this.this$0).addAll((Collection)this.$inlaysPsiElements);
            }
        }, arg_0)).inSmartMode(this.project).submit((Executor)NonUrgentExecutor.getInstance());
        Intrinsics.checkNotNullExpressionValue((Object)cancellablePromise, (String)"private fun restoreToolb\u2026ecutor.getInstance())\n  }");
        return cancellablePromise;
    }

    private final NotebookInlayComponentPsi getInlayComponentByOffset(int offset) {
        NotebookInlayComponentPsi notebookInlayComponentPsi;
        if (offset == this.editor.getDocument().getTextLength()) {
            Object v0;
            block4: {
                Iterable $this$firstOrNull$iv = this.inlays.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!((PsiElement)it.getKey()).getTextRange().containsOffset(offset)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            notebookInlayComponentPsi = entry != null ? (NotebookInlayComponentPsi)entry.getValue() : null;
        } else {
            Object v3;
            block5: {
                Iterable $this$firstOrNull$iv = this.inlays.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!((PsiElement)it.getKey()).getTextRange().contains(offset)) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            Map.Entry entry = v3;
            notebookInlayComponentPsi = entry != null ? (NotebookInlayComponentPsi)entry.getValue() : null;
        }
        return notebookInlayComponentPsi;
    }

    private final void addCaretListener() {
        this.editor.getCaretModel().addCaretListener(new CaretListener(this){
            final /* synthetic */ EditorInlaysManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void caretPositionChanged(@NotNull CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!Intrinsics.areEqual((Object)EditorInlaysManager.access$getEditor$p(this.this$0).getCaretModel().getPrimaryCaret(), (Object)e.getCaret())) {
                    return;
                }
                EditorInlaysManager.access$onCaretPositionChanged(this.this$0);
            }
        }, this.editor.getDisposable());
    }

    private final void onCaretPositionChanged() {
        if (this.editor.isDisposed()) {
            return;
        }
        NotebookInlayComponentPsi cellUnderCaret = this.getInlayComponentByOffset(this.editor.logicalPositionToOffset(this.editor.getCaretModel().getLogicalPosition()));
        if (cellUnderCaret == null) {
            Iterable $this$forEach$iv = this.inlays.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NotebookInlayComponentPsi it = (NotebookInlayComponentPsi)element$iv;
                boolean bl = false;
                it.setSelected(false);
            }
        } else if (!cellUnderCaret.getSelected()) {
            Iterable $this$forEach$iv = this.inlays.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NotebookInlayComponentPsi it = (NotebookInlayComponentPsi)element$iv;
                boolean bl = false;
                it.setSelected(false);
            }
            cellUnderCaret.setSelected(true);
        }
    }

    private final void updateInlays() {
        Iterable $this$forEach$iv = this.inlays.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookInlayComponentPsi it = (NotebookInlayComponentPsi)element$iv;
            boolean bl = false;
            this.updateInlayPosition(it);
        }
    }

    private final void setupInlayComponent(NotebookInlayComponentPsi inlayComponent) {
        inlayComponent.setBeforeHeightChanged((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ EditorInlaysManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                EditorInlaysManager.access$getScrollKeeper$p(this.this$0).savePosition();
            }
        }));
        inlayComponent.setAfterHeightChanged((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ EditorInlaysManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                EditorInlaysManager.access$setupInlayComponent$updateInlaysInEditor((Editor)EditorInlaysManager.access$getEditor$p(this.this$0));
                EditorInlaysManager.access$getScrollKeeper$p(this.this$0).restorePosition(true);
            }
        }));
    }

    private final void updateInlayComponentsWidth() {
        int inlayWidth = InlayDimensions.INSTANCE.calculateInlayWidth((EditorEx)this.editor);
        if (inlayWidth > 0) {
            Iterable $this$forEach$iv = this.inlays.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NotebookInlayComponentPsi it = (NotebookInlayComponentPsi)element$iv;
                boolean bl = false;
                it.setSize(inlayWidth, it.getHeight());
                Inlay<?> inlay = it.getInlay();
                if (inlay != null) {
                    inlay.updateSize();
                }
            }
        }
    }

    private final void updateInlayPosition(NotebookInlayComponentPsi inlayComponent) {
        int offset = this.descriptor.getInlayOffset(inlayComponent.getCell());
        Inlay<?> inlay = inlayComponent.getInlay();
        Intrinsics.checkNotNull(inlay);
        if (inlay.getOffset() != offset) {
            inlayComponent.disposeInlay();
            Inlay<NotebookInlayComponentPsi> inlay2 = this.addBlockElement(offset, inlayComponent);
            inlayComponent.assignInlay(inlay2);
        }
        Inlay<?> inlay3 = inlayComponent.getInlay();
        Intrinsics.checkNotNull(inlay3);
        inlayComponent.updateComponentBounds(inlay3);
    }

    private final Inlay<NotebookInlayComponentPsi> addBlockElement(int offset, NotebookInlayComponentPsi inlayComponent) {
        Inlay inlay = this.editor.getInlayModel().addBlockElement(offset, true, false, 0, (EditorCustomElementRenderer)inlayComponent);
        Intrinsics.checkNotNullExpressionValue((Object)inlay, (String)"editor.inlayModel.addBlo\u2026PRIORITY, inlayComponent)");
        return inlay;
    }

    private final NotebookInlayComponentPsi addInlayComponent(PsiElement cell) {
        NotebookInlayComponentPsi existingInlay = this.inlays.get(cell);
        if (existingInlay != null) {
            throw new Exception("Cell already added.");
        }
        InlayDimensions.INSTANCE.init(this.editor);
        int offset = this.descriptor.getInlayOffset(cell);
        NotebookInlayComponentPsi inlayComponent = new NotebookInlayComponentPsi(cell, this.editor);
        EditorGutter editorGutter = this.editor.getGutter();
        Intrinsics.checkNotNull((Object)editorGutter, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorGutterComponentEx");
        int gutterWidth = ((EditorGutterComponentEx)editorGutter).getWidth();
        int editorWideWidth = this.editor.getComponent().getWidth() - inlayComponent.getWidth() - gutterWidth - InlayDimensions.INSTANCE.getRightBorder();
        if (editorWideWidth <= 0) {
            editorWideWidth = InlayDimensions.INSTANCE.getWidth();
        }
        inlayComponent.setBounds(0, this.editor.offsetToXY((int)offset).y + this.editor.getLineHeight(), editorWideWidth, InlayDimensions.INSTANCE.getSmallHeight());
        this.editor.getContentComponent().add((Component)inlayComponent);
        Inlay<NotebookInlayComponentPsi> inlay = this.addBlockElement(offset, inlayComponent);
        inlayComponent.assignInlay(inlay);
        this.inlays.put(cell, inlayComponent);
        this.setupInlayComponent(inlayComponent);
        return inlayComponent;
    }

    private final NotebookInlayComponentPsi getInlayComponent(PsiElement cell) {
        return this.inlays.get(cell);
    }

    private static final void _init_$lambda$0(EditorInlaysManager this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.restoreOutputs();
    }

    private static final void _init_$lambda$1(EditorInlaysManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.editor.isDisposed()) {
            return;
        }
        this$0.updateInlayComponentsWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void updateCell$lambda$7$lambda$6(EditorInlaysManager this$0, FutureResult $result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        try {
            this$0.scrollKeeper.savePosition();
            this$0.updateInlays();
            this$0.scrollKeeper.restorePosition(true);
        }
        finally {
            $result.set((Object)Unit.INSTANCE);
        }
    }

    private static final void updateCell$lambda$7(EditorInlaysManager this$0, FutureResult $result, PsiElement $psi, List $inlayOutputs, boolean $createTextOutput) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$psi, (String)"$psi");
        try {
            List<InlayOutput> outputs;
            if (this$0.editor.isDisposed()) {
                $result.set((Object)Unit.INSTANCE);
                return;
            }
            if (!$psi.isValid()) {
                NotebookInlayComponentPsi notebookInlayComponentPsi = this$0.getInlayComponent($psi);
                if (notebookInlayComponentPsi != null) {
                    NotebookInlayComponentPsi oldInlay = notebookInlayComponentPsi;
                    boolean bl = false;
                    this$0.removeInlay(oldInlay, false);
                }
                $result.set((Object)Unit.INSTANCE);
                return;
            }
            if (this$0.isOutputPositionCollapsed($psi)) {
                $result.set((Object)Unit.INSTANCE);
                return;
            }
            List<InlayOutput> list = $inlayOutputs;
            if (list == null) {
                list = this$0.descriptor.getInlayOutputs($psi);
            }
            if ((outputs = list) == null) {
                $result.set((Object)Unit.INSTANCE);
                return;
            }
            this$0.scrollKeeper.savePosition();
            NotebookInlayComponentPsi notebookInlayComponentPsi = this$0.getInlayComponent($psi);
            if (notebookInlayComponentPsi != null) {
                NotebookInlayComponentPsi oldInlay = notebookInlayComponentPsi;
                boolean bl = false;
                this$0.removeInlay(oldInlay, false);
            }
            if (outputs.isEmpty() && !$createTextOutput) {
                $result.set((Object)Unit.INSTANCE);
                return;
            }
            NotebookInlayComponentPsi component = this$0.addInlayComponent($psi);
            if (!((Collection)outputs).isEmpty()) {
                this$0.addInlayOutputs(component, outputs);
            }
            if ($createTextOutput) {
                component.createOutputComponent();
            }
            this$0.scrollKeeper.restorePosition(true);
        }
        catch (Throwable e) {
            $result.set((Object)Unit.INSTANCE);
            throw e;
        }
        ApplicationManager.getApplication().invokeLater(() -> EditorInlaysManager.updateCell$lambda$7$lambda$6(this$0, $result));
    }

    private static final void updateInlayProgressStatus$lambda$8(EditorInlaysManager this$0, PsiElement $psi, InlayProgressStatus $progressStatus, FutureResult $result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$psi, (String)"$psi");
        Intrinsics.checkNotNullParameter((Object)$progressStatus, (String)"$progressStatus");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        NotebookInlayComponentPsi notebookInlayComponentPsi = this$0.getInlayComponent($psi);
        if (notebookInlayComponentPsi != null) {
            notebookInlayComponentPsi.updateProgressStatus($progressStatus);
        }
        $result.set((Object)Unit.INSTANCE);
    }

    private static final boolean scheduleIntervalUpdate$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean scheduleIntervalUpdate$lambda$13(EditorInlaysManager this$0, PsiElement psi) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        return this$0.descriptor.isInlayElement(psi);
    }

    private static final void addViewportListener$lambda$15(EditorInlaysManager this$0, ChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.viewportQueue.queue(new Update(this$0){
            final /* synthetic */ EditorInlaysManager this$0;
            {
                this.this$0 = $receiver;
                super((Object)"On viewport change task");
            }

            public void run() {
                EditorInlaysManager.access$updateInlaysForViewport(this.this$0);
            }
        });
    }

    private static final void restoreToolbars$lambda$16(EditorInlaysManager this$0, ArrayList $inlaysPsiElements) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$inlaysPsiElements, (String)"$inlaysPsiElements");
        PsiTreeUtil.processElements((PsiElement)((PsiElement)this$0.descriptor.getPsiFile()), (PsiElementProcessor)new PsiElementProcessor(this$0, $inlaysPsiElements){
            final /* synthetic */ EditorInlaysManager this$0;
            final /* synthetic */ ArrayList<PsiElement> $inlaysPsiElements;
            {
                this.this$0 = $receiver;
                this.$inlaysPsiElements = $inlaysPsiElements;
            }

            public final boolean execute(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (this.this$0.getDescriptor().isInlayElement(element)) {
                    this.$inlaysPsiElements.add(element);
                }
                return true;
            }
        });
    }

    private static final void restoreToolbars$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void setupInlayComponent$updateInlaysInEditor(Editor editor) {
        LogicalPosition logicalPosition = editor.xyToLogicalPosition(new Point(0, Integer.MAX_VALUE));
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"editor.xyToLogicalPositi\u2026(Point(0, Int.MAX_VALUE))");
        LogicalPosition end = logicalPosition;
        int offsetEnd = editor.logicalPositionToOffset(end);
        List list = editor.getInlayModel().getBlockElementsInRange(0, offsetEnd);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"editor.inlayModel.getBlo\u2026entsInRange(0, offsetEnd)");
        List inlays = list;
        Iterable $this$forEach$iv = inlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Inlay inlay = (Inlay)element$iv;
            boolean bl = false;
            if (!(inlay.getRenderer() instanceof InlayComponent)) continue;
            EditorCustomElementRenderer editorCustomElementRenderer = inlay.getRenderer();
            Intrinsics.checkNotNull((Object)editorCustomElementRenderer, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.r.inlays.InlayComponent");
            InlayComponent inlayComponent = (InlayComponent)editorCustomElementRenderer;
            Intrinsics.checkNotNullExpressionValue((Object)inlay, (String)"inlay");
            inlayComponent.updateComponentBounds(inlay);
        }
    }

    public static final /* synthetic */ EditorScrollingPositionKeeper access$getScrollKeeper$p(EditorInlaysManager $this) {
        return $this.scrollKeeper;
    }

    public static final /* synthetic */ NotebookInlayComponentPsi access$getInlayComponent(EditorInlaysManager $this, PsiElement cell) {
        return $this.getInlayComponent(cell);
    }

    public static final /* synthetic */ EditorImpl access$getEditor$p(EditorInlaysManager $this) {
        return $this.editor;
    }

    public static final /* synthetic */ LinkedHashSet access$getInlayElements$p(EditorInlaysManager $this) {
        return $this.inlayElements;
    }

    public static final /* synthetic */ void access$updateInlayForViewport(EditorInlaysManager $this, PsiElement element, IntRange viewportRange, IntRange expansionRange) {
        $this.updateInlayForViewport(element, viewportRange, expansionRange);
    }

    public static final /* synthetic */ Map access$getInlays$p(EditorInlaysManager $this) {
        return $this.inlays;
    }

    public static final /* synthetic */ void access$updateInlays(EditorInlaysManager $this) {
        $this.updateInlays();
    }

    public static final /* synthetic */ boolean access$isOutputPositionCollapsed(EditorInlaysManager $this, PsiElement psiCell) {
        return $this.isOutputPositionCollapsed(psiCell);
    }

    public static final /* synthetic */ void access$removeInlay(EditorInlaysManager $this, NotebookInlayComponentPsi inlayComponent, boolean cleanup) {
        $this.removeInlay(inlayComponent, cleanup);
    }

    public static final /* synthetic */ boolean access$getToolbarUpdateScheduled$p(EditorInlaysManager $this) {
        return $this.toolbarUpdateScheduled;
    }

    public static final /* synthetic */ void access$setToolbarUpdateScheduled$p(EditorInlaysManager $this, boolean bl) {
        $this.toolbarUpdateScheduled = bl;
    }

    public static final /* synthetic */ void access$scheduleIntervalUpdate(EditorInlaysManager $this, int offset, int length) {
        $this.scheduleIntervalUpdate(offset, length);
    }

    public static final /* synthetic */ void access$updateInlayComponentsWidth(EditorInlaysManager $this) {
        $this.updateInlayComponentsWidth();
    }

    public static final /* synthetic */ void access$onCaretPositionChanged(EditorInlaysManager $this) {
        $this.onCaretPositionChanged();
    }

    public static final /* synthetic */ void access$setupInlayComponent$updateInlaysInEditor(Editor editor) {
        EditorInlaysManager.setupInlayComponent$updateInlaysInEditor(editor);
    }

    public static final /* synthetic */ void access$updateInlaysForViewport(EditorInlaysManager $this) {
        $this.updateInlaysForViewport();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/EditorInlaysManager$Companion;", "", "()V", "INLAY_PRIORITY", "", "VIEWPORT_TASK_IDENTITY", "", "VIEWPORT_TASK_NAME", "VIEWPORT_TIME_SPAN", "isEnabledInTests", "", "()Z", "setEnabledInTests", "(Z)V", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEnabledInTests() {
            return isEnabledInTests;
        }

        public final void setEnabledInTests(boolean bl) {
            isEnabledInTests = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

