/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.xml;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.JavaCoverageViewExtension;
import com.intellij.coverage.xml.XMLReportAnnotator;
import com.intellij.coverage.xml.XMLReportEditorAnnotator;
import com.intellij.coverage.xml.XMLReportEngineKt;
import com.intellij.coverage.xml.XMLReportRunner;
import com.intellij.coverage.xml.XMLReportSuite;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u00020\u00042\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J(\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016Jm\u0010\u000f\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0010\u0010\u0019\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016\u00a2\u0006\u0002\u0010#J$\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\"2\b\u0010&\u001a\u0004\u0018\u00010\b2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u0011H\u0016J\u001c\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u00062\b\u0010/\u001a\u0004\u0018\u000100H\u0016J%\u00101\u001a\u00020\u000e2\u000e\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001a2\u0006\u0010!\u001a\u00020\"H\u0016\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u0002052\u0006\u0010!\u001a\u00020\"H\u0016J\u0012\u00106\u001a\f0\u0013\u00a2\u0006\u0002\b7\u00a2\u0006\u0002\b8H\u0016J\u0010\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\u0006H\u0016J\u0018\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\u0014\u0010@\u001a\u00020\u00042\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J \u0010A\u001a\u00020\u00042\u0006\u0010B\u001a\u00020C2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010D\u001a\u00020EH\u0016\u00a8\u0006F"}, d2={"Lcom/intellij/coverage/xml/XMLReportEngine;", "Lcom/intellij/coverage/CoverageEngine;", "()V", "acceptedByFilters", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "suite", "Lcom/intellij/coverage/CoverageSuitesBundle;", "canHavePerTestCoverage", "conf", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "coverageEditorHighlightingApplicableTo", "createCoverageEnabledConfiguration", "", "createCoverageSuite", "covRunner", "Lcom/intellij/coverage/CoverageRunner;", "name", "", "coverageDataFileProvider", "Lcom/intellij/coverage/CoverageFileProvider;", "config", "Lcom/intellij/execution/configurations/coverage/CoverageEnabledConfiguration;", "Lcom/intellij/coverage/CoverageSuite;", "filters", "", "lastCoverageTimeStamp", "", "suiteToMerge", "coverageByTestEnabled", "tracingEnabled", "trackTestFolders", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/coverage/CoverageRunner;Ljava/lang/String;Lcom/intellij/coverage/CoverageFileProvider;[Ljava/lang/String;JLjava/lang/String;ZZZLcom/intellij/openapi/project/Project;)Lcom/intellij/coverage/CoverageSuite;", "createCoverageViewExtension", "Lcom/intellij/coverage/view/JavaCoverageViewExtension;", "suiteBundle", "stateBean", "Lcom/intellij/coverage/view/CoverageViewManager$StateBean;", "createEmptyCoverageSuite", "Lcom/intellij/coverage/xml/XMLReportSuite;", "coverageRunner", "createSrcFileAnnotator", "Lcom/intellij/coverage/xml/XMLReportEditorAnnotator;", "file", "editor", "Lcom/intellij/openapi/editor/Editor;", "findTestsByNames", "testNames", "([Ljava/lang/String;Lcom/intellij/openapi/project/Project;)Ljava/lang/Void;", "getCoverageAnnotator", "Lcom/intellij/coverage/xml/XMLReportAnnotator;", "getPresentableText", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getQualifiedNames", "sourceFile", "getTestMethodName", "element", "Lcom/intellij/psi/PsiElement;", "testProxy", "Lcom/intellij/execution/testframework/AbstractTestProxy;", "isApplicableTo", "recompileProjectAndRerunAction", "module", "Lcom/intellij/openapi/module/Module;", "chooseSuiteAction", "Ljava/lang/Runnable;", "intellij.java.coverage"})
public final class XMLReportEngine
extends CoverageEngine {
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @Nullable String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMerge, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)covRunner, (String)"covRunner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)coverageDataFileProvider, (String)"coverageDataFileProvider");
        if (!(covRunner instanceof XMLReportRunner)) {
            return null;
        }
        return (CoverageSuite)new XMLReportSuite(this, name, coverageDataFileProvider, lastCoverageTimeStamp, trackTestFolders, (XMLReportRunner)covRunner, project);
    }

    @NotNull
    public Void createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @NotNull CoverageEnabledConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)covRunner, (String)"covRunner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)coverageDataFileProvider, (String)"coverageDataFileProvider");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        throw new IllegalStateException("Should not be called".toString());
    }

    @Nullable
    public XMLReportSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        Intrinsics.checkNotNullParameter((Object)coverageRunner, (String)"coverageRunner");
        if (!(coverageRunner instanceof XMLReportRunner)) {
            return null;
        }
        return new XMLReportSuite(this, (XMLReportRunner)coverageRunner);
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        CoverageSuitesBundle coverageSuitesBundle = CoverageDataManager.getInstance((Project)psiFile.getProject()).getCurrentSuitesBundle();
        if (coverageSuitesBundle == null) {
            return false;
        }
        CoverageSuitesBundle suite = coverageSuitesBundle;
        return this.acceptedByFilters(psiFile, suite);
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Pair<String, String> pair = XMLReportEngineKt.packageAndFileName(psiFile);
        if (pair == null) {
            return false;
        }
        Pair<String, String> pair2 = pair;
        String packageName2 = (String)pair2.component1();
        String fileName = (String)pair2.component2();
        CoverageSuite[] coverageSuiteArray = suite.getSuites();
        Intrinsics.checkNotNullExpressionValue((Object)coverageSuiteArray, (String)"suite.suites");
        for (CoverageSuite xmlSuite : coverageSuiteArray) {
            if (!(xmlSuite instanceof XMLReportSuite) || ((XMLReportSuite)xmlSuite).getFileInfo(packageName2, fileName) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public JavaCoverageViewExtension createCoverageViewExtension(@NotNull Project project, @Nullable CoverageSuitesBundle suiteBundle, @Nullable CoverageViewManager.StateBean stateBean) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        XMLReportAnnotator xMLReportAnnotator = this.getCoverageAnnotator(project);
        return new JavaCoverageViewExtension(project, suiteBundle, stateBean, xMLReportAnnotator){

            protected boolean isBranchInfoAvailable(@Nullable CoverageRunner coverageRunner, boolean branchCoverage) {
                return true;
            }
        };
    }

    @NotNull
    public XMLReportEditorAnnotator createSrcFileAnnotator(@Nullable PsiFile file, @Nullable Editor editor) {
        return new XMLReportEditorAnnotator(file, editor);
    }

    public boolean isApplicableTo(@NotNull RunConfigurationBase<?> conf) {
        Intrinsics.checkNotNullParameter(conf, (String)"conf");
        return false;
    }

    public boolean canHavePerTestCoverage(@NotNull RunConfigurationBase<?> conf) {
        Intrinsics.checkNotNullParameter(conf, (String)"conf");
        return false;
    }

    @NotNull
    public String getPresentableText() {
        String string = JavaCoverageBundle.message("coverage.xml.report.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"coverage.xml.report.title\")");
        return string;
    }

    @NotNull
    public XMLReportAnnotator getCoverageAnnotator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return XMLReportAnnotator.Companion.getInstance(project);
    }

    public boolean recompileProjectAndRerunAction(@NotNull Module module, @NotNull CoverageSuitesBundle suite, @NotNull Runnable chooseSuiteAction) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter((Object)chooseSuiteAction, (String)"chooseSuiteAction");
        return false;
    }

    @NotNull
    public Void getQualifiedNames(@NotNull PsiFile sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        throw new IllegalStateException("Should not be called".toString());
    }

    @NotNull
    public Void findTestsByNames(@NotNull String[] testNames, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)testNames, (String)"testNames");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        throw new IllegalStateException("Should not be called".toString());
    }

    @NotNull
    public Void getTestMethodName(@NotNull PsiElement element, @NotNull AbstractTestProxy testProxy) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)testProxy, (String)"testProxy");
        throw new IllegalStateException("Should not be called".toString());
    }

    @NotNull
    public Void createCoverageEnabledConfiguration(@NotNull RunConfigurationBase<?> conf) {
        Intrinsics.checkNotNullParameter(conf, (String)"conf");
        throw new IllegalStateException("Should not be called".toString());
    }
}

