/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.actions;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.execution.ExecutionHandler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class TargetAction
extends DumbAwareAction {
    private final String myBuildName;
    private final List<String> myTargets;
    private final String myDebugString;

    public TargetAction(AntBuildFile buildFile, @NlsActions.ActionText String displayName, List<@NlsSafe String> targets, @NlsActions.ActionDescription String description) {
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setText(displayName, false);
        templatePresentation.setDescription(description);
        this.myBuildName = buildFile.getPresentableName();
        this.myTargets = targets;
        this.myDebugString = "Target action: " + displayName + "; Build: " + buildFile.getPresentableName() + "; Project: " + buildFile.getProject().getPresentableUrl();
    }

    @NonNls
    public String toString() {
        return this.myDebugString;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            TargetAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        for (AntBuildFileBase buildFile : AntConfiguration.getInstance(project).getBuildFileList()) {
            String name = buildFile.getPresentableName();
            if (name == null || !this.myBuildName.equals(name)) continue;
            List<String> targets = this.myTargets.size() == 1 && TargetAction.getDefaultTargetName().equals(this.myTargets.iterator().next()) ? Collections.emptyList() : this.myTargets;
            ExecutionHandler.runBuild(buildFile, targets, null, e.getDataContext(), Collections.emptyList(), AntBuildListener.NULL);
            return;
        }
    }

    @Nls
    public static String getDefaultTargetName() {
        return AntBundle.message("ant.target.name.default.target", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/ant/config/actions/TargetAction", "actionPerformed"));
    }
}

