/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.AntConfigurationListener;
import com.intellij.lang.ant.config.AntNoFileException;
import com.intellij.lang.ant.config.ExecutionEvent;
import com.intellij.lang.ant.config.actions.TargetAction;
import com.intellij.lang.ant.config.impl.AntBuildFileImpl;
import com.intellij.lang.ant.config.impl.AntBuildModelImpl;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.config.impl.AntReference;
import com.intellij.lang.ant.config.impl.AntWorkspaceConfiguration;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.config.impl.ExecuteAfterCompilationEvent;
import com.intellij.lang.ant.config.impl.ExecuteBeforeCompilationEvent;
import com.intellij.lang.ant.config.impl.ExecuteCompositeTargetEvent;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.lang.ant.config.impl.MetaTarget;
import com.intellij.lang.ant.config.impl.WrongNameFormatException;
import com.intellij.lang.ant.dom.AntDomFileDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.ValueProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="AntConfiguration", storages={@Storage(value="ant.xml")}, useLoadedStateAsExisting=false)
public class AntConfigurationImpl
extends AntConfigurationBase
implements PersistentStateComponent<Element>,
Disposable {
    public static final ValueProperty<AntReference> DEFAULT_ANT = new ValueProperty("defaultAnt", (Object)AntReference.BUNDLED_ANT);
    private static final ValueProperty<AntConfiguration> INSTANCE = new ValueProperty("$instance", null);
    public static final AbstractProperty<String> DEFAULT_JDK_NAME = new AbstractProperty<String>(){

        public String getName() {
            return "$defaultJDKName";
        }

        @Nullable
        public String getDefault(AbstractProperty.AbstractPropertyContainer container) {
            return this.get(container);
        }

        @Nullable
        public String get(@NotNull AbstractProperty.AbstractPropertyContainer container) {
            if (container == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!container.hasProperty((AbstractProperty)this)) {
                return null;
            }
            AntConfiguration antConfiguration = (AntConfiguration)((Object)INSTANCE.get(container));
            return ProjectRootManager.getInstance((Project)antConfiguration.getProject()).getProjectSdkName();
        }

        public String copy(String jdkName) {
            return jdkName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/lang/ant/config/impl/AntConfigurationImpl$1", "get"));
        }
    };
    private static final Logger LOG = Logger.getInstance(AntConfigurationImpl.class);
    @NonNls
    private static final String BUILD_FILE = "buildFile";
    @NonNls
    private static final String CONTEXT_MAPPING = "contextMapping";
    @NonNls
    private static final String CONTEXT = "context";
    @NonNls
    private static final String URL = "url";
    @NonNls
    private static final String EXECUTE_ON_ELEMENT = "executeOn";
    @NonNls
    private static final String EVENT_ELEMENT = "event";
    @NonNls
    private static final String TARGET_ELEMENT = "target";
    private final PsiManager myPsiManager;
    private final List<AntBuildFileBase> myBuildFiles = new CopyOnWriteArrayList<AntBuildFileBase>();
    private final AtomicReference<List<Pair<Element, String>>> myBuildFilesConfiguration = new AtomicReference();
    private final Map<ExecutionEvent, Pair<AntBuildFile, String>> myEventToTargetMap = Collections.synchronizedMap(new HashMap());
    private final Map<AntBuildFile, AntBuildModelBase> myModelToBuildFileMap = Collections.synchronizedMap(new HashMap());
    private final Map<VirtualFile, VirtualFile> myAntFileToContextFileMap = Collections.synchronizedMap(new HashMap());
    private final EventDispatcher<AntConfigurationListener> myEventDispatcher = EventDispatcher.create(AntConfigurationListener.class);
    private volatile boolean myInitialized = false;
    private volatile Thread myInitThread;

    public AntConfigurationImpl(final Project project) {
        super(project);
        this.getProperties().registerProperty(DEFAULT_ANT, AntReference.EXTERNALIZER);
        this.getProperties().rememberKey(INSTANCE);
        this.getProperties().rememberKey(DEFAULT_JDK_NAME);
        INSTANCE.set((AbstractProperty.AbstractPropertyContainer)this.getProperties(), (Object)this);
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.addAntConfigurationListener(new AntConfigurationListener(){

            @Override
            public void configurationLoaded() {
                this.restartDaemon();
            }

            @Override
            public void buildFileChanged(AntBuildFile buildFile) {
                this.restartDaemon();
            }

            @Override
            public void buildFileAdded(AntBuildFile buildFile) {
                this.restartDaemon();
            }

            @Override
            public void buildFileRemoved(AntBuildFile buildFile) {
                this.restartDaemon();
            }

            private void restartDaemon() {
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> DaemonCodeAnalyzer.getInstance((Project)project).restart());
            }
        });
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){
            private final AsyncFileListener.ChangeApplier NO_OP = new AsyncFileListener.ChangeApplier(){};

            @Nullable
            public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    3.$$$reportNull$$$0(0);
                }
                HashSet<VirtualFile> toDelete = null;
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    if (toDelete == null) {
                        toDelete = new HashSet<VirtualFile>();
                    }
                    toDelete.add(vFileEvent.getFile());
                }
                if (toDelete == null) {
                    return this.NO_OP;
                }
                HashSet<AntBuildFileBase> antFiles = null;
                for (AntBuildFileBase file : AntConfigurationImpl.this.myBuildFiles) {
                    if (!toDelete.contains(file.getVirtualFile())) continue;
                    if (antFiles == null) {
                        antFiles = new HashSet<AntBuildFileBase>();
                    }
                    antFiles.add(file);
                }
                return antFiles == null ? this.NO_OP : new FileDeletionChangeApplier(toDelete, antFiles);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/ant/config/impl/AntConfigurationImpl$3", "prepareChange"));
            }
        }, (Disposable)this);
    }

    public void dispose() {
    }

    public Element getState() {
        Element state = new Element("state");
        this.getProperties().writeExternal(state);
        ReadAction.run(() -> {
            ArrayList<VirtualFile> files;
            for (AntBuildFileBase buildFile : this.myBuildFiles) {
                Element element = new Element(BUILD_FILE);
                element.setAttribute(URL, buildFile.getVirtualFile().getUrl());
                buildFile.writeProperties(element);
                this.saveEvents(element, buildFile);
                state.addContent(element);
            }
            Map<VirtualFile, VirtualFile> map = this.myAntFileToContextFileMap;
            synchronized (map) {
                files = new ArrayList<VirtualFile>(this.myAntFileToContextFileMap.keySet());
            }
            files.sort(Comparator.comparing(VirtualFile::getUrl));
            for (VirtualFile file : files) {
                Element element = new Element(CONTEXT_MAPPING);
                element.setAttribute(URL, file.getUrl());
                VirtualFile contextFile = this.myAntFileToContextFileMap.get(file);
                if (contextFile != null) {
                    element.setAttribute(CONTEXT, contextFile.getUrl());
                }
                state.addContent(element);
            }
        });
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element state) {
        if (state == null) {
            AntConfigurationImpl.$$$reportNull$$$0(0);
        }
        try {
            ArrayList<Pair> files = new ArrayList<Pair>();
            Iterator iterator = state.getChildren(BUILD_FILE).iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                iterator.remove();
                String url = element.getAttributeValue(URL);
                if (url == null) continue;
                files.add(Pair.create((Object)element, (Object)url));
            }
            this.myBuildFilesConfiguration.set(files);
            VirtualFileManager vfManager = VirtualFileManager.getInstance();
            this.myAntFileToContextFileMap.clear();
            for (Element element : state.getChildren(CONTEXT_MAPPING)) {
                String url = element.getAttributeValue(URL);
                String contextUrl = element.getAttributeValue(CONTEXT);
                assert (url != null);
                VirtualFile file = vfManager.findFileByUrl(url);
                assert (contextUrl != null);
                VirtualFile contextFile = vfManager.findFileByUrl(contextUrl);
                if (file == null || contextFile == null) continue;
                this.myAntFileToContextFileMap.put(file, contextFile);
            }
            this.getProperties().readExternal(state);
        }
        finally {
            this.queueInitialization();
        }
    }

    public void noStateLoaded() {
        this.myInitialized = true;
    }

    private void queueInitialization() {
        StartupManager.getInstance((Project)this.getProject()).runAfterOpened(() -> AntConfigurationImpl.queueLater((Task)new Task.Backgroundable(this.getProject(), AntBundle.message("progress.text.loading.ant.config", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                Project project;
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((project = this.getProject()) == null || project.isDisposed()) {
                    AntConfigurationImpl.this.myInitialized = true;
                    return;
                }
                List configFiles = AntConfigurationImpl.this.myBuildFilesConfiguration.getAndSet(null);
                if (configFiles != null) {
                    AntConfigurationImpl.this.applyConfigFiles(indicator, configFiles);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/ant/config/impl/AntConfigurationImpl$4", "run"));
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void applyConfigFiles(@NotNull ProgressIndicator indicator, List<Pair<Element, String>> configFiles) {
        if (indicator == null) {
            AntConfigurationImpl.$$$reportNull$$$0(1);
        }
        indicator.setIndeterminate(true);
        indicator.pushState();
        try {
            indicator.setText(AntBundle.message("progress.text.loading.ant.config", new Object[0]));
            this.myInitThread = Thread.currentThread();
            this.runNonBlocking(() -> {
                for (AntBuildFile antBuildFile : this.myBuildFiles) {
                    this.removeBuildFileImpl(antBuildFile);
                }
            });
            VirtualFileManager vfManager = VirtualFileManager.getInstance();
            ArrayList<Pair> buildFiles = new ArrayList<Pair>(configFiles.size());
            for (Pair<Element, String> elemUrl : configFiles) {
                Pair bf = this.runNonBlocking(() -> {
                    Element element = (Element)elemUrl.getFirst();
                    VirtualFile file = vfManager.findFileByUrl((String)elemUrl.getSecond());
                    if (file != null) {
                        try {
                            return Pair.create((Object)element, (Object)this.addBuildFileImpl(file, element));
                        }
                        catch (AntNoFileException antNoFileException) {
                        }
                        catch (InvalidDataException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                    return null;
                }, null);
                if (bf == null) continue;
                buildFiles.add(bf);
            }
            for (Pair elemBuildFile : buildFiles) {
                this.runNonBlocking(() -> {
                    AntBuildFileBase buildFile = (AntBuildFileBase)elemBuildFile.getSecond();
                    buildFile.updateProperties();
                    for (Element e : ((Element)elemBuildFile.getFirst()).getChildren(EXECUTE_ON_ELEMENT)) {
                        String eventId = e.getAttributeValue(EVENT_ELEMENT);
                        ExecutionEvent event = null;
                        String targetName = e.getAttributeValue(TARGET_ELEMENT);
                        if ("beforeCompilation".equals(eventId)) {
                            event = ExecuteBeforeCompilationEvent.getInstance();
                        } else if ("afterCompilation".equals(eventId)) {
                            event = ExecuteAfterCompilationEvent.getInstance();
                        } else if ("compositeTask".equals(eventId)) {
                            try {
                                event = new ExecuteCompositeTargetEvent(targetName);
                            }
                            catch (WrongNameFormatException e1) {
                                LOG.info((Throwable)e1);
                                event = null;
                            }
                        }
                        if (event == null) continue;
                        try {
                            event.readExternal(e, this.getProject());
                            this.setTargetForEvent(buildFile, targetName, event);
                        }
                        catch (InvalidDataException readFailed) {
                            LOG.info(readFailed.getMessage());
                        }
                    }
                });
            }
            ReadAction.run(() -> {
                try {
                    AntWorkspaceConfiguration.getInstance(this.getProject()).loadFileProperties();
                }
                catch (InvalidDataException e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    this.incModificationCount();
                    this.updateRegisteredActions();
                }
            });
        }
        finally {
            this.myInitThread = null;
            LOG.info("AntConfiguration: initialized");
            this.myInitialized = true;
            ApplicationManager.getApplication().invokeLater(() -> ((AntConfigurationListener)this.myEventDispatcher.getMulticaster()).configurationLoaded(), ModalityState.any());
            indicator.popState();
        }
    }

    @Override
    public void ensureInitialized() {
        if (!this.isInitialized()) {
            ProgressIndicatorUtils.awaitWithCheckCanceled(() -> {
                if (!this.isInitialized()) {
                    TimeoutUtil.sleep((long)10L);
                    return this.isInitialized();
                }
                return true;
            });
        }
    }

    @Override
    public boolean isInitialized() {
        return this.myInitialized;
    }

    @Override
    public boolean hasBuildFiles() {
        if (!this.myBuildFiles.isEmpty() || !this.myInitialized) {
            return true;
        }
        List<Pair<Element, String>> files = this.myBuildFilesConfiguration.get();
        return files != null && !files.isEmpty();
    }

    @Override
    public AntBuildFile[] getBuildFiles() {
        return this.myBuildFiles.toArray(new AntBuildFileBase[0]);
    }

    @Override
    public List<AntBuildFileBase> getBuildFileList() {
        return this.myBuildFiles;
    }

    @Override
    @Nullable
    public AntBuildFile addBuildFile(final VirtualFile file) throws AntNoFileException {
        final Ref result = Ref.create(null);
        final Ref ex = Ref.create(null);
        String title = AntBundle.message("dialog.title.register.ant.build.file", file.getPresentableUrl());
        ProgressManager.getInstance().run((Task)new Task.Modal(this.getProject(), title, false){

            @NotNull
            public Task.NotificationInfo getNotificationInfo() {
                return new Task.NotificationInfo("Ant", AntBundle.message("system.notification.title.ant.task.finished", new Object[0]), "");
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                indicator.pushState();
                try {
                    indicator.setText(AntBundle.message("progress.text.register.ant.build.file", file.getPresentableUrl()));
                    AntConfigurationImpl.this.incModificationCount();
                    boolean added = AntConfigurationImpl.this.runNonBlocking(() -> {
                        try {
                            for (AntBuildFile antBuildFile : AntConfigurationImpl.this.getBuildFileList()) {
                                VirtualFile vFile = antBuildFile.getVirtualFile();
                                if (vFile == null || !vFile.equals(file)) continue;
                                result.set((Object)antBuildFile);
                                return Boolean.FALSE;
                            }
                            result.set((Object)AntConfigurationImpl.this.addBuildFileImpl(file, null));
                            AntConfigurationImpl.this.updateRegisteredActions();
                            return Boolean.TRUE;
                        }
                        catch (AntNoFileException e) {
                            ex.set((Object)e);
                            return Boolean.FALSE;
                        }
                    }, Boolean.FALSE);
                    if (added) {
                        ApplicationManager.getApplication().invokeLater(() -> ((AntConfigurationListener)AntConfigurationImpl.this.myEventDispatcher.getMulticaster()).buildFileAdded((AntBuildFile)result.get()), ModalityState.any());
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    indicator.popState();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/ant/config/impl/AntConfigurationImpl$5", "run"));
            }
        });
        if (ex.get() != null) {
            throw (AntNoFileException)ex.get();
        }
        return (AntBuildFile)result.get();
    }

    @Override
    public void removeBuildFile(@NotNull AntBuildFile file) {
        if (file == null) {
            AntConfigurationImpl.$$$reportNull$$$0(2);
        }
        this.removeBuildFiles(Collections.singleton((AntBuildFileBase)file));
    }

    private boolean removeBuildFiles(Collection<AntBuildFileBase> files) {
        boolean removed = false;
        for (AntBuildFileBase file : files) {
            this.incModificationCount();
            removed |= this.removeBuildFileImpl(file);
        }
        this.updateRegisteredActions();
        return removed;
    }

    @Override
    public void addAntConfigurationListener(AntConfigurationListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeAntConfigurationListener(AntConfigurationListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    @Override
    public boolean isFilterTargets() {
        return this.getAntWorkspaceConfiguration().FILTER_TARGETS;
    }

    @Override
    public void setFilterTargets(boolean value) {
        this.getAntWorkspaceConfiguration().FILTER_TARGETS = value;
    }

    @Override
    public AntBuildTarget[] getMetaTargets(AntBuildFile buildFile) {
        List<ExecutionEvent> events = this.getEventsByClass();
        if (events.isEmpty()) {
            return AntBuildTargetBase.EMPTY_ARRAY;
        }
        return (AntBuildTarget[])events.stream().map(event -> (MetaTarget)this.getTargetForEvent((ExecutionEvent)event)).filter(target -> target != null && buildFile.equals(target.getBuildFile())).toArray(AntBuildTarget[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExecutionEvent> getEventsForTarget(AntBuildTarget target) {
        ArrayList<ExecutionEvent> list = new ArrayList<ExecutionEvent>();
        Map<ExecutionEvent, Pair<AntBuildFile, String>> map = this.myEventToTargetMap;
        synchronized (map) {
            for (ExecutionEvent event : this.myEventToTargetMap.keySet()) {
                AntBuildTarget targetForEvent = this.getTargetForEvent(event);
                if (!target.equals(targetForEvent)) continue;
                list.add(event);
            }
        }
        return list;
    }

    @Override
    @Nullable
    public AntBuildTarget getTargetForEvent(ExecutionEvent event) {
        Pair<AntBuildFile, String> pair = this.myEventToTargetMap.get(event);
        if (pair == null) {
            return null;
        }
        AntBuildFileBase buildFile = (AntBuildFileBase)pair.first;
        if (!this.myBuildFiles.contains(buildFile)) {
            return null;
        }
        String targetName = (String)pair.second;
        AntBuildTarget antBuildTarget = buildFile.getModel().findTarget(targetName);
        if (antBuildTarget != null) {
            return antBuildTarget;
        }
        for (ExecutionEvent ev : this.getEventsByClass()) {
            String name = "compositeTask".equals(ev.getTypeId()) ? ((ExecuteCompositeTargetEvent)ev).getMetaTargetName() : ev.getPresentableName();
            if (!Comparing.strEqual((String)targetName, (String)name)) continue;
            return new MetaTarget(buildFile, ev.getPresentableName(), ((ExecuteCompositeTargetEvent)ev).getTargetNames());
        }
        return null;
    }

    @Override
    public void setTargetForEvent(AntBuildFile buildFile, String targetName, ExecutionEvent event) {
        this.myEventToTargetMap.put(event, (Pair<AntBuildFile, String>)Pair.create((Object)buildFile, (Object)targetName));
    }

    @Override
    public void clearTargetForEvent(ExecutionEvent event) {
        this.myEventToTargetMap.remove(event);
    }

    @Override
    public void updateBuildFile(AntBuildFile buildFile) {
        this.incModificationCount();
        ((AntConfigurationListener)this.myEventDispatcher.getMulticaster()).buildFileChanged(buildFile);
        this.updateRegisteredActions();
    }

    @Override
    public boolean isAutoScrollToSource() {
        return this.getAntWorkspaceConfiguration().IS_AUTOSCROLL_TO_SOURCE;
    }

    @Override
    public void setAutoScrollToSource(boolean value) {
        this.getAntWorkspaceConfiguration().IS_AUTOSCROLL_TO_SOURCE = value;
    }

    @Override
    public AntInstallation getProjectDefaultAnt() {
        return ((AntReference)DEFAULT_ANT.get((AbstractProperty.AbstractPropertyContainer)this.getProperties())).find(GlobalAntConfiguration.getInstance());
    }

    @Override
    @Nullable
    public AntBuildModelBase getModelIfRegistered(@NotNull AntBuildFileBase buildFile) {
        if (buildFile == null) {
            AntConfigurationImpl.$$$reportNull$$$0(3);
        }
        return this.myBuildFiles.contains(buildFile) ? this.getModel(buildFile) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEvents(Element element, AntBuildFile buildFile) {
        ArrayList<Element> events = null;
        HashSet<String> savedEvents = new HashSet<String>();
        Map<ExecutionEvent, Pair<AntBuildFile, String>> map = this.myEventToTargetMap;
        synchronized (map) {
            for (ExecutionEvent event : this.myEventToTargetMap.keySet()) {
                Pair<AntBuildFile, String> pair = this.myEventToTargetMap.get(event);
                if (!buildFile.equals(pair.first)) continue;
                Element eventElement = new Element(EXECUTE_ON_ELEMENT);
                eventElement.setAttribute(EVENT_ELEMENT, event.getTypeId());
                eventElement.setAttribute(TARGET_ELEMENT, (String)pair.second);
                String id = event.writeExternal(eventElement, this.getProject());
                if (savedEvents.contains(id)) continue;
                savedEvents.add(id);
                if (events == null) {
                    events = new ArrayList<Element>();
                }
                events.add(eventElement);
            }
        }
        if (events != null) {
            events.sort(EventElementComparator.INSTANCE);
            for (Element eventElement : events) {
                element.addContent(eventElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AntBuildModelBase getModel(@NotNull AntBuildFile buildFile) {
        AntBuildModelBase model;
        if (buildFile == null) {
            AntConfigurationImpl.$$$reportNull$$$0(4);
        }
        if ((model = this.myModelToBuildFileMap.get(buildFile)) == null) {
            Map<AntBuildFile, AntBuildModelBase> map = this.myModelToBuildFileMap;
            synchronized (map) {
                model = new AntBuildModelImpl(buildFile);
                AntBuildModelBase prev = this.myModelToBuildFileMap.put(buildFile, model);
                if (prev != null) {
                    model = prev;
                    this.myModelToBuildFileMap.put(buildFile, prev);
                }
            }
        }
        return model;
    }

    @Override
    @Nullable
    public AntBuildFile findBuildFileByActionId(String id) {
        for (AntBuildFile antBuildFile : this.myBuildFiles) {
            AntBuildModelBase model = (AntBuildModelBase)antBuildFile.getModel();
            if (id.equals(model.getDefaultTargetActionId())) {
                return antBuildFile;
            }
            if (!model.hasTargetWithActionId(id)) continue;
            return antBuildFile;
        }
        return null;
    }

    private AntBuildFileBase addBuildFileImpl(VirtualFile file, @Nullable Element element) throws AntNoFileException {
        PsiFile xmlFile = this.myPsiManager.findFile(file);
        if (!(xmlFile instanceof XmlFile)) {
            throw new AntNoFileException(AntBundle.message("ant.cannot.add.build.file.reason.file.is.not.xml", new Object[0]), file);
        }
        AntSupport.markFileAsAntFile(file, xmlFile.getProject(), true);
        if (!AntDomFileDescription.isAntFile((XmlFile)xmlFile)) {
            throw new AntNoFileException(AntBundle.message("ant.cannot.add.build.file.reason.file.not.ant.file", new Object[0]), file);
        }
        AntBuildFileImpl buildFile = new AntBuildFileImpl(xmlFile, this);
        if (element != null) {
            buildFile.readProperties(element);
        }
        this.myBuildFiles.add(buildFile);
        return buildFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRegisteredActions() {
        Project project = this.getProject();
        if (project.isDisposed()) {
            return;
        }
        ArrayList<Pair> actionList = new ArrayList<Pair>();
        for (AntBuildFileBase buildFile : this.myBuildFiles) {
            AntBuildModelBase model = buildFile.getModel();
            String defaultTargetActionId = model.getDefaultTargetActionId();
            if (defaultTargetActionId != null) {
                TargetAction action = new TargetAction(buildFile, TargetAction.getDefaultTargetName(), Collections.singletonList(TargetAction.getDefaultTargetName()), null);
                actionList.add(new Pair((Object)defaultTargetActionId, (Object)action));
            }
            AntConfigurationImpl.collectTargetActions(model.getFilteredTargets(), actionList, buildFile);
            AntConfigurationImpl.collectTargetActions(this.getMetaTargets(buildFile), actionList, buildFile);
        }
        Object object = this;
        synchronized (object) {
            ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
            for (String oldId : actionManager.getActionIdList(AntConfiguration.getActionIdPrefix(project))) {
                actionManager.unregisterAction(oldId);
            }
            if (!actionList.isEmpty()) {
                HashSet<String> registeredIds = new HashSet<String>();
                for (Pair pair : actionList) {
                    if (registeredIds.contains(pair.first)) continue;
                    registeredIds.add((String)pair.first);
                    actionManager.registerAction((String)pair.first, (AnAction)pair.second);
                }
            }
        }
    }

    private AntWorkspaceConfiguration getAntWorkspaceConfiguration() {
        return AntWorkspaceConfiguration.getInstance(this.getProject());
    }

    private static void collectTargetActions(AntBuildTarget[] targets, List<? super Pair<String, AnAction>> actionList, AntBuildFile buildFile) {
        for (AntBuildTarget target : targets) {
            String actionId = ((AntBuildTargetBase)target).getActionId();
            if (actionId == null) continue;
            TargetAction action = new TargetAction(buildFile, target.getName(), target.getTargetNames(), target.getNotEmptyDescription());
            actionList.add((Pair<String, AnAction>)new Pair((Object)actionId, (Object)action));
        }
    }

    private boolean removeBuildFileImpl(@NotNull AntBuildFile buildFile) {
        XmlFile antFile;
        if (buildFile == null) {
            AntConfigurationImpl.$$$reportNull$$$0(5);
        }
        if ((antFile = buildFile.getAntFile()) != null) {
            AntSupport.markFileAsAntFile(antFile.getOriginalFile().getVirtualFile(), antFile.getProject(), false);
        }
        boolean removed = this.myBuildFiles.remove(buildFile);
        if (removed |= this.myModelToBuildFileMap.remove(buildFile) != null) {
            ((AntConfigurationListener)this.myEventDispatcher.getMulticaster()).buildFileRemoved(buildFile);
        }
        return removed;
    }

    @Override
    public boolean executeTargetBeforeCompile(CompileContext compileContext, DataContext dataContext) {
        return this.runTargetSynchronously(compileContext, dataContext, ExecuteBeforeCompilationEvent.getInstance());
    }

    @Override
    public boolean executeTargetAfterCompile(CompileContext compileContext, DataContext dataContext) {
        return this.runTargetSynchronously(compileContext, dataContext, ExecuteAfterCompilationEvent.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runTargetSynchronously(CompileContext compileContext, DataContext dataContext, ExecutionEvent event) {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ProgressIndicator progress = compileContext.getProgressIndicator();
        progress.pushState();
        try {
            AntBuildTarget target;
            if (!this.isInitialized()) {
                progress.setText(AntBundle.message("progress.text.loading.ant.config", new Object[0]));
                this.ensureInitialized();
            }
            if ((target = this.getTargetForEvent(event)) == null) {
                boolean bl = true;
                return bl;
            }
            if ("afterCompilation".equals(event.getTypeId()) && compileContext.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                compileContext.addMessage(CompilerMessageCategory.INFORMATION, AntBundle.message("message.skip.ant.target.after.compilation.errors", target.getDisplayName()), null, -1, -1);
                boolean bl = true;
                return bl;
            }
            progress.setText(AntBundle.message("progress.text.running.ant.tasks", new Object[0]));
            boolean bl = AntConfigurationImpl.executeTargetSynchronously(dataContext, target);
            return bl;
        }
        finally {
            progress.popState();
        }
    }

    public static boolean executeTargetSynchronously(DataContext dataContext, AntBuildTarget target) {
        return AntConfigurationImpl.executeTargetSynchronously(dataContext, target, Collections.emptyList());
    }

    public static boolean executeTargetSynchronously(DataContext dataContext, AntBuildTarget target, List<BuildFileProperty> additionalProperties) {
        final Semaphore targetDone = new Semaphore();
        targetDone.down();
        final Ref result = Ref.create((Object)Boolean.FALSE);
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
                if (project == null || project.isDisposed()) {
                    targetDone.up();
                } else {
                    target.run(dataContext, additionalProperties, new AntBuildListener(){

                        @Override
                        public void buildFinished(int state, int errorCount) {
                            result.set((Object)(state == 0 && errorCount == 0 ? 1 : 0));
                            targetDone.up();
                        }
                    });
                }
            }
            catch (Throwable e) {
                targetDone.up();
                LOG.error(e);
            }
        });
        targetDone.waitFor();
        return (Boolean)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExecutionEvent> getEventsByClass() {
        Thread initThread = this.myInitThread;
        if (initThread == null || initThread != Thread.currentThread()) {
            this.ensureInitialized();
        }
        ArrayList<ExecutionEvent> list = new ArrayList<ExecutionEvent>();
        Map<ExecutionEvent, Pair<AntBuildFile, String>> map = this.myEventToTargetMap;
        synchronized (map) {
            for (ExecutionEvent event : this.myEventToTargetMap.keySet()) {
                if (!(event instanceof ExecuteCompositeTargetEvent)) continue;
                list.add(event);
            }
        }
        return list;
    }

    private static void queueLater(Task task) {
        Application app = ApplicationManager.getApplication();
        if (task.isHeadless()) {
            app.invokeLater(() -> ((Task)task).queue());
        } else {
            task.queue();
        }
    }

    @Override
    public void setContextFile(@NotNull XmlFile file, @Nullable XmlFile context) {
        if (file == null) {
            AntConfigurationImpl.$$$reportNull$$$0(6);
        }
        if (context != null) {
            this.myAntFileToContextFileMap.put(file.getVirtualFile(), context.getVirtualFile());
        } else {
            this.myAntFileToContextFileMap.remove(file.getVirtualFile());
        }
    }

    @Override
    @Nullable
    public XmlFile getContextFile(@Nullable XmlFile file) {
        if (file == null) {
            return null;
        }
        VirtualFile context = this.myAntFileToContextFileMap.get(file.getVirtualFile());
        if (context == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(context);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        return AntDomFileDescription.isAntFile(xmlFile) ? xmlFile : null;
    }

    @Override
    @Nullable
    public AntBuildFileBase getAntBuildFile(@NotNull PsiFile file) {
        VirtualFile vFile;
        if (file == null) {
            AntConfigurationImpl.$$$reportNull$$$0(7);
        }
        if ((vFile = file.getVirtualFile()) != null) {
            for (AntBuildFileBase bFile : this.myBuildFiles) {
                if (!vFile.equals(bFile.getVirtualFile())) continue;
                return bFile;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public XmlFile getEffectiveContextFile(XmlFile file) {
        return new Object(){

            @Nullable
            XmlFile findContext(XmlFile file, Set<? super PsiElement> processed) {
                if (file != null) {
                    processed.add((PsiElement)file);
                    XmlFile contextFile = AntConfigurationImpl.this.getContextFile(file);
                    return contextFile == null || processed.contains(contextFile) ? file : this.findContext(contextFile, processed);
                }
                return null;
            }
        }.findContext(file, new HashSet());
    }

    private void runNonBlocking(@NotNull Runnable task) {
        if (task == null) {
            AntConfigurationImpl.$$$reportNull$$$0(8);
        }
        this.runNonBlocking(() -> {
            task.run();
            return null;
        }, null);
    }

    private <T> T runNonBlocking(@NotNull Callable<? extends T> task, T defValue) {
        if (task == null) {
            AntConfigurationImpl.$$$reportNull$$$0(9);
        }
        try {
            return (T)ReadAction.nonBlocking(task).expireWith((Disposable)this).executeSynchronously();
        }
        catch (ProcessCanceledException ex) {
            return defValue;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = BUILD_FILE;
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ant/config/impl/AntConfigurationImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyConfigFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeBuildFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getModelIfRegistered";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeBuildFileImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setContextFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getAntBuildFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "runNonBlocking";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EventElementComparator
    implements Comparator<Element> {
        static final Comparator<? super Element> INSTANCE = new EventElementComparator();
        private static final String[] COMPARABLE_ATTRIB_NAMES = new String[]{"event", "target", "presentableName"};

        private EventElementComparator() {
        }

        @Override
        public int compare(Element o1, Element o2) {
            for (String attribName : COMPARABLE_ATTRIB_NAMES) {
                int valuesEqual = Comparing.compare((Comparable)((Object)o1.getAttributeValue(attribName)), (Comparable)((Object)o2.getAttributeValue(attribName)));
                if (valuesEqual == 0) continue;
                return valuesEqual;
            }
            return 0;
        }
    }

    private class FileDeletionChangeApplier
    implements AsyncFileListener.ChangeApplier {
        private final Set<VirtualFile> myDeleted;
        private final Set<AntBuildFileBase> myAntFiles;

        FileDeletionChangeApplier(Set<VirtualFile> deleted, Set<AntBuildFileBase> antFiles) {
            this.myDeleted = deleted;
            this.myAntFiles = antFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeVfsChange() {
            Map<VirtualFile, VirtualFile> map = AntConfigurationImpl.this.myAntFileToContextFileMap;
            synchronized (map) {
                Iterator<Map.Entry<VirtualFile, VirtualFile>> it = AntConfigurationImpl.this.myAntFileToContextFileMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<VirtualFile, VirtualFile> entry = it.next();
                    if (!this.myDeleted.contains(entry.getKey()) && !this.myDeleted.contains(entry.getValue())) continue;
                    it.remove();
                }
            }
        }

        public void afterVfsChange() {
            ApplicationManager.getApplication().executeOnPooledThread(() -> AntConfigurationImpl.this.runNonBlocking(() -> AntConfigurationImpl.this.removeBuildFiles(this.myAntFiles)));
        }
    }
}

