/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.AntConfigurationListener;
import com.intellij.lang.ant.config.actions.ActivateAntToolWindowAction;
import com.intellij.lang.ant.config.impl.AntUnlinkedProjectAware;
import com.intellij.lang.ant.config.impl.AntUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemProjectLinkListener;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/ant/config/impl/AntUnlinkedProjectAware;", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemUnlinkedProjectAware;", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "isBuildFile", "", "project", "Lcom/intellij/openapi/project/Project;", "buildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isLinkedProject", "externalProjectPath", "", "linkAndLoadProject", "", "subscribe", "listener", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemProjectLinkListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.ant"})
@SourceDebugExtension(value={"SMAP\nAntUnlinkedProjectAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AntUnlinkedProjectAware.kt\ncom/intellij/lang/ant/config/impl/AntUnlinkedProjectAware\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1229#2,2:68\n3792#3:70\n4307#3,2:71\n1855#4,2:73\n*S KotlinDebug\n*F\n+ 1 AntUnlinkedProjectAware.kt\ncom/intellij/lang/ant/config/impl/AntUnlinkedProjectAware\n*L\n32#1:68,2\n43#1:70\n43#1:71,2\n44#1:73,2\n*E\n"})
public final class AntUnlinkedProjectAware
implements ExternalSystemUnlinkedProjectAware {
    @NotNull
    private final ProjectSystemId systemId = AntUtil.getSYSTEM_ID();

    @NotNull
    public ProjectSystemId getSystemId() {
        return this.systemId;
    }

    public boolean isBuildFile(@NotNull Project project, @NotNull VirtualFile buildFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        return AntUtil.getKNOWN_ANT_FILES().contains(buildFile.getName());
    }

    /*
     * WARNING - void declaration
     */
    public boolean isLinkedProject(@NotNull Project project, @NotNull String externalProjectPath) {
        boolean bl;
        block1: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
            AntConfigurationBase antConfiguration = AntConfigurationBase.getInstance(project);
            AntBuildFile[] antBuildFileArray = antConfiguration.getBuildFiles();
            Intrinsics.checkNotNullExpressionValue((Object)antBuildFileArray, (String)"antConfiguration.buildFiles");
            Sequence sequence = SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])antBuildFileArray), (Function1)isLinkedProject.1.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!FileUtil.pathsEqual((String)PathUtil.getParentPath((String)it), (String)externalProjectPath)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void linkAndLoadProject(@NotNull Project project, @NotNull String externalProjectPath) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile externalProjectDir = localFileSystem.findFileByPath(externalProjectPath);
        if (externalProjectDir == null) {
            String shortPath = UiUtils.getPresentablePath((String)externalProjectPath);
            Object[] objectArray = new Object[]{this.getSystemId().getReadableName(), shortPath};
            throw new IllegalArgumentException(ExternalSystemBundle.message((String)"error.project.does.not.exist", (Object[])objectArray));
        }
        AntConfigurationBase antConfiguration = AntConfigurationBase.getInstance(project);
        VirtualFile[] virtualFileArray = externalProjectDir.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"externalProjectDir.children");
        Object[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!this.isBuildFile(project, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List antBuildFiles = (List)destination$iv$iv;
        Iterable $this$forEach$iv = antBuildFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            antConfiguration.addBuildFile(it);
        }
        if (!((Collection)antBuildFiles).isEmpty()) {
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Ant");
            if (toolWindow == null) {
                toolWindow = ActivateAntToolWindowAction.Manager.createToolWindow(project);
            }
            ToolWindow window = toolWindow;
            window.activate(null);
        }
    }

    public void subscribe(@NotNull Project project, @NotNull ExternalSystemProjectLinkListener listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        AntConfigurationBase antConfiguration = AntConfigurationBase.getInstance(project);
        antConfiguration.addAntConfigurationListener(new AntConfigurationListener(listener){
            final /* synthetic */ ExternalSystemProjectLinkListener $listener;
            {
                this.$listener = $listener;
            }

            public void buildFileAdded(@NotNull AntBuildFile buildFile) {
                Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
                VirtualFile virtualFile = buildFile.getVirtualFile();
                if (virtualFile == null) {
                    return;
                }
                VirtualFile virtualFile2 = virtualFile;
                String string = PathUtil.getParentPath((String)virtualFile2.getPath());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(virtualFile.path)");
                this.$listener.onProjectLinked(string);
            }

            public void buildFileRemoved(@NotNull AntBuildFile buildFile) {
                Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
            }
        });
    }
}

