/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public final class ExternalsDefinitionParser {
    @NotNull
    public static Map<String, String> parseExternalsProperty(@NotNull String externals) throws SvnBindException {
        if (externals == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(0);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String external : StringUtil.splitByLines((String)externals, (boolean)true)) {
            map.put(ExternalsDefinitionParser.parseRelativeDirectory(external), external);
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @NotNull
    public static String parseRelativeDirectory(@NotNull String s) throws SvnBindException {
        String result;
        int length;
        if (s == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(2);
        }
        if (ExternalsDefinitionParser.isUnescapedQuote(s = s.trim(), (length = s.length()) - 1)) {
            int index = ExternalsDefinitionParser.lastUnescapedIndexOf(s, length - 1, '\"');
            ExternalsDefinitionParser.assertIndex(s, index, SvnBundle.message("error.could.not.find.start.quote", new Object[0]));
            result = s.substring(index + 1, length - 1);
        } else {
            int index = ExternalsDefinitionParser.lastUnescapedIndexOf(s, length, ' ');
            ExternalsDefinitionParser.assertIndex(s, index, SvnBundle.message("error.could.not.find.separating.space", new Object[0]));
            result = s.substring(index + 1);
        }
        return ExternalsDefinitionParser.unescape(result);
    }

    private static void assertIndex(@NlsSafe @NotNull String s, int index, @NlsContexts.DialogMessage @NotNull String message) throws SvnBindException {
        if (s == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(3);
        }
        if (message == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(4);
        }
        if (index < 0) {
            throw new SvnBindException(message + " - " + s);
        }
    }

    @NotNull
    private static String unescape(@NotNull String s) {
        if (s == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(5);
        }
        String string = s.replace("\\", "");
        if (string == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static int lastUnescapedIndexOf(@NotNull String s, int from, char c) {
        if (s == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(7);
        }
        int result = from;
        while ((result = s.lastIndexOf(c, result - 1)) != -1 && !ExternalsDefinitionParser.isUnescaped(s, result, c)) {
        }
        return result;
    }

    private static boolean isUnescapedQuote(@NotNull String s, int index) {
        if (s == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(8);
        }
        return ExternalsDefinitionParser.isUnescaped(s, index, '\"');
    }

    private static boolean isUnescaped(@NotNull String s, int index, char c) {
        if (s == null) {
            ExternalsDefinitionParser.$$$reportNull$$$0(9);
        }
        return StringUtil.isChar((CharSequence)s, (int)index, (char)c) && !StringUtil.isChar((CharSequence)s, (int)(index - 1), (char)'\\');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externals";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/properties/ExternalsDefinitionParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseExternalsProperty";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "unescape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseExternalsProperty";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseRelativeDirectory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "assertIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unescape";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lastUnescapedIndexOf";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isUnescapedQuote";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUnescaped";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6 -> new IllegalStateException(string);
        };
    }
}

