/*
 * Decompiled with CFR 0.152.
 */
package training.dsl;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonSample;
import training.dsl.LessonSamplePosition;
import training.dsl.LessonUtil;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0004\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"createFromTemplate", "Ltraining/dsl/LessonSample;", "template", "insert", "", "parseCarets", "text", "positions", "", "Ltraining/dsl/LessonSamplePosition;", "parseLessonSample", "rowText", "prepareSampleFromCurrentState", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.featuresTrainer"})
public final class LessonSampleKt {
    @NotNull
    public static final LessonSample createFromTemplate(@NotNull LessonSample template, @NotNull String insert) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)insert, (String)"insert");
        return new LessonSample(LessonUtil.INSTANCE.insertIntoSample(template, insert), MapsKt.mapOf((Pair)new Pair((Object)0, (Object)new LessonSamplePosition(0, template.getStartOffset(), template.getSelection()))));
    }

    @NotNull
    public static final LessonSample parseLessonSample(@NotNull String rowText) {
        Intrinsics.checkNotNullParameter((Object)rowText, (String)"rowText");
        String text2 = ((CharSequence)rowText).length() == 0 || StringsKt.last((CharSequence)rowText) == '\n' ? rowText : rowText + "\n";
        List positionList = new ArrayList();
        String resultText = LessonSampleKt.parseCarets(text2, positionList);
        Map positions = new LinkedHashMap();
        if (!((Collection)positionList).isEmpty()) {
            for (LessonSamplePosition position : positionList) {
                if (positions.get(position.getId()) != null) {
                    throw new IllegalStateException("several same id in the sample".toString());
                }
                positions.put(position.getId(), position);
            }
        } else {
            positions.put(0, new LessonSamplePosition(0, 0, null, 4, null));
        }
        return new LessonSample(resultText, positions);
    }

    private static final String parseCarets(String text2, List<LessonSamplePosition> positions) {
        StringBuilder result2 = new StringBuilder();
        Ref.IntRef idx = new Ref.IntRef();
        String selectionEnd = "</select>";
        Ref.IntRef previousEndIdx = new Ref.IntRef();
        while (idx.element >= 0 && idx.element < text2.length()) {
            int id;
            idx.element = StringsKt.indexOf$default((CharSequence)text2, (char)'<', (int)idx.element, (boolean)false, (int)4, null);
            Ref.IntRef startIdx = new Ref.IntRef();
            startIdx.element = idx.element;
            if (idx.element < 0) break;
            int n = idx.element;
            idx.element = n + 1;
            if (LessonSampleKt.parseCarets$acceptPrefix(text2, idx, "caret")) {
                if (LessonSampleKt.parseCarets$acceptPrefix(text2, idx, ">")) {
                    LessonSampleKt.parseCarets$appendText(result2, text2, previousEndIdx, startIdx, idx);
                    positions.add(new LessonSamplePosition(0, result2.length(), null, 4, null));
                    continue;
                }
                if (!LessonSampleKt.parseCarets$equalSymbol(idx, text2, ' ')) continue;
                Integer n2 = LessonSampleKt.parseCarets$parseId(text2, idx, "/>");
                if (n2 == null) {
                    continue;
                }
                id = n2;
                LessonSampleKt.parseCarets$appendText(result2, text2, previousEndIdx, startIdx, idx);
                positions.add(new LessonSamplePosition(id, result2.length(), null, 4, null));
                continue;
            }
            if (!LessonSampleKt.parseCarets$acceptPrefix(text2, idx, "select")) continue;
            if (LessonSampleKt.parseCarets$acceptPrefix(text2, idx, ">")) {
                Integer n3 = LessonSampleKt.parseCarets$parseSelection(result2, idx, text2, selectionEnd, startIdx, previousEndIdx);
                if (n3 == null) {
                    continue;
                }
                int startSelection = n3;
                positions.add(new LessonSamplePosition(0, result2.length(), (Pair<Integer, Integer>)new Pair((Object)startSelection, (Object)result2.length())));
                continue;
            }
            if (!LessonSampleKt.parseCarets$equalSymbol(idx, text2, ' ')) continue;
            Integer n4 = LessonSampleKt.parseCarets$parseId(text2, idx, ">");
            if (n4 == null) {
                continue;
            }
            id = n4;
            Integer n5 = LessonSampleKt.parseCarets$parseSelection(result2, idx, text2, selectionEnd, startIdx, previousEndIdx);
            if (n5 == null) {
                continue;
            }
            int startSelection = n5;
            positions.add(new LessonSamplePosition(id, result2.length(), (Pair<Integer, Integer>)new Pair((Object)startSelection, (Object)result2.length())));
        }
        result2.append(text2.subSequence(previousEndIdx.element, text2.length()));
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    @NotNull
    public static final LessonSample prepareSampleFromCurrentState(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        String string = editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"editor.document.text");
        String text2 = string;
        Caret caret2 = editor.getCaretModel().getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret2, (String)"editor.caretModel.currentCaret");
        Caret currentCaret = caret2;
        LessonSamplePosition position = currentCaret.hasSelection() ? new LessonSamplePosition(0, currentCaret.getOffset(), (Pair<Integer, Integer>)new Pair((Object)currentCaret.getSelectionStart(), (Object)currentCaret.getSelectionEnd())) : new LessonSamplePosition(0, currentCaret.getOffset(), null, 4, null);
        return new LessonSample(text2, MapsKt.mapOf((Pair)new Pair((Object)0, (Object)position)));
    }

    private static final void parseCarets$skipSpace(Ref.IntRef idx, String $text) {
        while (idx.element < $text.length() && $text.charAt(idx.element) == ' ') {
            int n = idx.element;
            idx.element = n + 1;
        }
    }

    private static final boolean parseCarets$equalSymbol(Ref.IntRef idx, String $text, char c) {
        return idx.element < $text.length() && $text.charAt(idx.element) == c;
    }

    private static final boolean parseCarets$acceptPrefix(String $text, Ref.IntRef idx, String prefix) {
        if (StringsKt.startsWith$default((CharSequence)$text.subSequence(idx.element, $text.length()), (CharSequence)prefix, (boolean)false, (int)2, null)) {
            idx.element += prefix.length();
            return true;
        }
        return false;
    }

    private static final Integer parseCarets$parseId(String $text, Ref.IntRef idx, String suffix) {
        LessonSampleKt.parseCarets$skipSpace(idx, $text);
        if (!LessonSampleKt.parseCarets$acceptPrefix($text, idx, "id")) {
            return null;
        }
        LessonSampleKt.parseCarets$skipSpace(idx, $text);
        if (!LessonSampleKt.parseCarets$acceptPrefix($text, idx, "=")) {
            return null;
        }
        LessonSampleKt.parseCarets$skipSpace(idx, $text);
        int end = StringsKt.indexOf$default((CharSequence)$text, (String)suffix, (int)idx.element, (boolean)false, (int)4, null);
        if (end == -1) {
            return null;
        }
        int id = Integer.parseInt(((Object)$text.subSequence(idx.element, end)).toString());
        idx.element = end + suffix.length();
        return id;
    }

    private static final void parseCarets$appendText(StringBuilder result2, String $text, Ref.IntRef previousEndIdx, Ref.IntRef startIdx, Ref.IntRef idx) {
        result2.append($text.subSequence(previousEndIdx.element, startIdx.element));
        previousEndIdx.element = idx.element;
    }

    private static final Integer parseCarets$parseSelection(StringBuilder result2, Ref.IntRef idx, String $text, String selectionEnd, Ref.IntRef startIdx, Ref.IntRef previousEndIdx) {
        LessonSampleKt.parseCarets$appendText(result2, $text, previousEndIdx, startIdx, idx);
        int startSelection = result2.length();
        idx.element = StringsKt.indexOf$default((CharSequence)$text, (String)selectionEnd, (int)idx.element, (boolean)false, (int)4, null);
        if (idx.element == -1) {
            return null;
        }
        startIdx.element = idx.element;
        idx.element += selectionEnd.length();
        LessonSampleKt.parseCarets$appendText(result2, $text, previousEndIdx, startIdx, idx);
        return startSelection;
    }
}

