/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.authentication.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.ui.login.LoginPanelModelBase;
import com.intellij.collaboration.auth.ui.login.LoginTokenGenerator;
import com.intellij.collaboration.util.URIUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.GitLabServersManager;
import org.jetbrains.plugins.gitlab.GitLabServersManagerKt;
import org.jetbrains.plugins.gitlab.api.GitLabApi;
import org.jetbrains.plugins.gitlab.api.GitLabApiManager;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.api.request.GitLabUsersApiKt;
import org.jetbrains.plugins.gitlab.authentication.GitLabSecurityUtil;
import org.jetbrains.plugins.gitlab.authentication.ui.GitLabTokenLoginPanelModel;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0011\u0010\f\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0006\u0010\u0011\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gitlab/authentication/ui/GitLabTokenLoginPanelModel;", "Lcom/intellij/collaboration/auth/ui/login/LoginPanelModelBase;", "Lcom/intellij/collaboration/auth/ui/login/LoginTokenGenerator;", "requiredUsername", "", "uniqueAccountPredicate", "Lkotlin/Function2;", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "canGenerateToken", "serverUri", "checkToken", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createServerPath", "uri", "generateToken", "getServerPath", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabTokenLoginPanelModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabTokenLoginPanelModel.kt\norg/jetbrains/plugins/gitlab/authentication/ui/GitLabTokenLoginPanelModel\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,61:1\n43#2,3:62\n43#2,3:65\n*S KotlinDebug\n*F\n+ 1 GitLabTokenLoginPanelModel.kt\norg/jetbrains/plugins/gitlab/authentication/ui/GitLabTokenLoginPanelModel\n*L\n25#1:62,3\n30#1:65,3\n*E\n"})
public final class GitLabTokenLoginPanelModel
extends LoginPanelModelBase
implements LoginTokenGenerator {
    @Nullable
    private final String requiredUsername;
    @NotNull
    private final Function2<GitLabServerPath, String, Boolean> uniqueAccountPredicate;

    public GitLabTokenLoginPanelModel(@Nullable String requiredUsername, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        this.requiredUsername = requiredUsername;
        this.uniqueAccountPredicate = uniqueAccountPredicate;
    }

    public /* synthetic */ GitLabTokenLoginPanelModel(String string, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string, (Function2<? super GitLabServerPath, ? super String, Boolean>)function2);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object checkToken(@NotNull Continuation<? super String> var1_1) {
        if (!(var1_1 instanceof checkToken.1)) ** GOTO lbl-1000
        var10_2 = var1_1;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ GitLabTokenLoginPanelModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.checkToken((Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                server = this.createServerPath(this.getServerUri());
                $i$f$service = false;
                serviceClass$iv = GitLabApiManager.class;
                var6_11 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (var6_11 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                api = ((GitLabApiManager)var6_11).getClient(this.getToken());
                $continuation.L$0 = this;
                $continuation.L$1 = server;
                $continuation.L$2 = api;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GitLabUserDTO>, Object>(api, server, null){
                    int label;
                    final /* synthetic */ GitLabApi $api;
                    final /* synthetic */ GitLabServerPath $server;
                    {
                        this.$api = $api;
                        this.$server = $server;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = GitLabUsersApiKt.getCurrentUser(this.$api.getGraphQL(), this.$server, (Continuation<? super GitLabUserDTO>)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GitLabUserDTO> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl33
            }
            case 1: {
                api = (GitLabApi)$continuation.L$2;
                server = (GitLabServerPath)$continuation.L$1;
                this = (GitLabTokenLoginPanelModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                v1 = (GitLabUserDTO)v0;
                if (v1 == null) {
                    throw new IllegalArgumentException(GitLabBundle.message("account.token.invalid", new Object[0]));
                }
                user = v1;
                $i$f$service = false;
                serviceClass$iv = GitLabServersManager.class;
                var7_13 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (var7_13 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                $continuation.L$0 = this;
                $continuation.L$1 = server;
                $continuation.L$2 = user;
                $continuation.label = 2;
                v2 = GitLabServersManagerKt.validateServerVersion((GitLabServersManager)var7_13, server, api, (Continuation<? super Unit>)$continuation);
                if (v2 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl56
            }
            case 2: {
                user = (GitLabUserDTO)$continuation.L$2;
                server = (GitLabServerPath)$continuation.L$1;
                this = (GitLabTokenLoginPanelModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl56:
                // 2 sources

                username = user.getUsername();
                if (this.requiredUsername != null && !Intrinsics.areEqual((Object)username, (Object)this.requiredUsername)) {
                    $i$a$-require-GitLabTokenLoginPanelModel$checkToken$2 = false;
                    var8_18 = new Object[]{this.requiredUsername, username};
                    $i$a$-require-GitLabTokenLoginPanelModel$checkToken$2 = GitLabBundle.message("account.username.mismatch", var8_18);
                    throw new IllegalArgumentException($i$a$-require-GitLabTokenLoginPanelModel$checkToken$2.toString());
                }
                if (!((Boolean)this.uniqueAccountPredicate.invoke((Object)server, (Object)username)).booleanValue()) {
                    $i$a$-require-GitLabTokenLoginPanelModel$checkToken$3 = false;
                    var8_19 = new Object[]{username};
                    var7_17 = GitLabBundle.message("account.not.unique", var8_19);
                    throw new IllegalArgumentException(var7_17.toString());
                }
                return username;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final GitLabServerPath getServerPath() {
        return this.createServerPath(this.getServerUri());
    }

    private final GitLabServerPath createServerPath(String uri) {
        String normalized = URIUtil.INSTANCE.normalizeAndValidateHttpUri(uri);
        return new GitLabServerPath(normalized);
    }

    public boolean canGenerateToken(@NotNull String serverUri) {
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        return URIUtil.INSTANCE.isValidHttpUri(serverUri);
    }

    @Nullable
    public String generateToken(@NotNull String serverUri) {
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        String string = GitLabSecurityUtil.INSTANCE.buildNewTokenUrl$intellij_vcs_gitlab(serverUri);
        if (string == null) {
            return null;
        }
        String newTokenUrl = string;
        BrowserUtil.browse((String)newTokenUrl);
        return null;
    }
}

