/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.sun.management.OperatingSystemMXBean;
import io.opentelemetry.api.trace.Span;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import javax.swing.SwingUtilities;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;

public class Timer {
    public static final Timer instance = new Timer();
    private String myActivityName = "default";
    private volatile long myStartTime;
    private volatile long myStopTime;
    private LongAccumulator myLongestDelay;
    private volatile double myHighestCPULoad;
    private volatile long myHighestRAMUsage;
    private final AtomicLong myTotalDelay = new AtomicLong();
    private final AtomicLong myTotalCPULoad = new AtomicLong();
    private final AtomicLong myTotalRAMUsage = new AtomicLong();
    private final AtomicLong myCounter = new AtomicLong();
    private final AtomicLong myHWCounter = new AtomicLong();
    private Span mySpan;
    private ScheduledExecutorService executor;
    private long totalTime;

    public void start() {
        this.start("default", true);
    }

    public void start(String activityName, boolean withSpan) {
        this.myActivityName = activityName;
        this.myStartTime = System.currentTimeMillis();
        this.myLongestDelay = new LongAccumulator(Math::max, 0L);
        this.myHighestCPULoad = 0.0;
        this.myHighestRAMUsage = 0L;
        this.myTotalRAMUsage.set(0L);
        this.myTotalCPULoad.set(0L);
        this.myTotalDelay.set(0L);
        this.myCounter.set(0L);
        this.myHWCounter.set(0L);
        this.executor = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"Performance plugin timer");
        SystemInfo info = new SystemInfo();
        int processId = info.getOperatingSystem().getProcessId();
        OSProcess process = info.getOperatingSystem().getProcess(processId);
        this.executor.scheduleWithFixedDelay(() -> {
            long before = System.currentTimeMillis();
            try {
                SwingUtilities.invokeAndWait(() -> {});
                long after = System.currentTimeMillis();
                long delay = after - before;
                this.myTotalDelay.addAndGet(delay);
                this.myCounter.incrementAndGet();
                this.myLongestDelay.accumulate(delay);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS);
        OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        this.executor.scheduleWithFixedDelay(() -> {
            this.myHWCounter.incrementAndGet();
            double cpuLoad = bean.getProcessCpuLoad();
            if (cpuLoad > 0.0 && cpuLoad <= 1.0) {
                this.myTotalCPULoad.addAndGet(Math.round(cpuLoad * 100.0));
                if (this.myHighestCPULoad < cpuLoad) {
                    this.myHighestCPULoad = cpuLoad;
                }
            }
            long ramUsage = process.getResidentSetSize();
            this.myTotalRAMUsage.addAndGet(ramUsage);
            if (this.myHighestRAMUsage < ramUsage) {
                this.myHighestRAMUsage = ramUsage;
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        if (withSpan) {
            String spanName = activityName.equals("default") ? "timer" : activityName;
            this.mySpan = PerformanceTestSpan.TRACER.spanBuilder(spanName).setParent(PerformanceTestSpan.getContext()).startSpan();
        }
    }

    public void stop() {
        if (this.mySpan != null) {
            this.mySpan.setAttribute("max_awt_delay", this.getLongestDelay());
            this.mySpan.setAttribute("average_awt_delay", this.getAverageDelay());
            this.mySpan.end();
        }
        this.myStopTime = System.currentTimeMillis();
        this.totalTime = this.myStopTime - this.myStartTime;
        this.executor.shutdownNow();
    }

    public void reportToTeamCity() {
        Timer.logValue(this.myActivityName, this.totalTime);
        Timer.logValue(this.myActivityName + " | Total Time Execution", this.totalTime);
        Timer.logValue(this.myActivityName + " | Responsiveness", this.getLongestDelay());
        Timer.logValue(this.myActivityName + " | Average Responsiveness", this.getAverageDelay());
        Timer.logValue(this.myActivityName + " | Average RAM Usage (%)", this.getAverageRAMUsage());
        Timer.logValue(this.myActivityName + " | Average CPU Usage", this.getAverageCPULoad());
        Timer.logValue(this.myActivityName + " | Max RAM Usage", this.myHighestRAMUsage);
        Timer.logValue(this.myActivityName + " | Max CPU Usage", this.myHighestCPULoad);
    }

    public long getLongestDelay() {
        return this.myLongestDelay.get();
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public long getStopTime() {
        return this.myStopTime;
    }

    public double getAverageCPULoad() {
        long counterValue = this.myHWCounter.get();
        return counterValue != 0L ? (double)this.myTotalCPULoad.get() / (double)counterValue : 0.0;
    }

    public int getAverageRAMUsage() {
        long counterValue = this.myHWCounter.get();
        return counterValue != 0L ? (int)(this.myTotalRAMUsage.get() / counterValue) : 0;
    }

    public long getAverageDelay() {
        long counterValue = this.myCounter.get();
        return counterValue != 0L ? this.myTotalDelay.get() / counterValue : 0L;
    }

    public String getActivityName() {
        return this.myActivityName;
    }

    public boolean isStarted() {
        return this.executor != null && !this.executor.isShutdown();
    }

    private static void logValue(String key, long value) {
        if (value >= 0L) {
            System.out.println("##teamcity[buildStatisticValue key='" + key + "' value='" + value + "']");
        }
    }

    private static void logValue(String key, double value) {
        if (value >= 0.0) {
            System.out.println("##teamcity[buildStatisticValue key='" + key + "' value='" + value + "']");
        }
    }
}

