/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.commands.RunClassInPlugin;
import io.opentelemetry.api.trace.Tracer;
import java.lang.reflect.Constructor;
import java.net.URLClassLoader;
import org.jetbrains.annotations.NotNull;

public class RunServiceInPlugin
extends RunClassInPlugin {
    public static final String PREFIX = "%runServiceInPlugin";
    public static final String SPAN_NAME = "runServiceInPlugin";

    public RunServiceInPlugin(@NotNull String text, int line) {
        if (text == null) {
            RunServiceInPlugin.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @Override
    protected void runWithClassLoader(@NotNull Project project, URLClassLoader classLoader) throws ReflectiveOperationException {
        if (project == null) {
            RunServiceInPlugin.$$$reportNull$$$0(1);
        }
        ClassLoaderUtil.runWithClassLoader((ClassLoader)classLoader, () -> {
            Class<?> aClass = classLoader.loadClass(this.myClazzName);
            Object service = RunServiceInPlugin.getService(project, aClass);
            if (service == null) {
                throw new RuntimeException("Cannot find an instance of class " + this.myClazzName + " and cannot instantiate it with Project");
            }
            TraceUtil.runWithSpanThrows((Tracer)PerformanceTestSpan.TRACER, (String)SPAN_NAME, globalSpan -> this.invokeMethod(project, aClass, service));
        });
    }

    private static Object getService(@NotNull Project project, Class<?> aClass) throws ReflectiveOperationException {
        Object service;
        if (project == null) {
            RunServiceInPlugin.$$$reportNull$$$0(2);
        }
        if ((service = project.getService(aClass)) == null) {
            try {
                Constructor<?> aClassConstructor = aClass.getConstructor(Project.class);
                service = aClassConstructor.newInstance(project);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return service;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/commands/RunServiceInPlugin";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithClassLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getService";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

