/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class ShowAltEnter
extends AbstractCommand
implements Disposable {
    public static final String PREFIX = "%altEnter";
    public static final String SPAN_NAME = "showQuickFixes";

    public ShowAltEnter(@NotNull String text, int line) {
        if (text == null) {
            ShowAltEnter.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            ShowAltEnter.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String extractCommandList = this.extractCommandArgument(PREFIX);
        String[] commandList = extractCommandList.split("\\|");
        String actionName = commandList[0];
        boolean invoke = commandList.length == 1 || Boolean.parseBoolean(commandList[1]);
        ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> {
            @NotNull Project project = context.getProject();
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor != null) {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                if (psiFile != null) {
                    TraceUtil.runWithSpanThrows((Tracer)PerformanceTestSpan.TRACER, (String)SPAN_NAME, span -> {
                        ShowIntentionsPass.IntentionsInfo intentions = ShowIntentionActionsHandler.calcIntentions((Project)project, (Editor)editor, (PsiFile)psiFile);
                        if (!actionName.isEmpty()) {
                            ArrayList combined = new ArrayList();
                            combined.addAll(intentions.intentionsToShow);
                            combined.addAll(intentions.inspectionFixesToShow);
                            combined.addAll(intentions.errorFixesToShow);
                            combined.addAll(intentions.notificationActionsToShow);
                            span.setAttribute("number", (long)combined.size());
                            Optional<HighlightInfo.IntentionActionDescriptor> singleIntention = combined.stream().filter(s -> s.getAction().getText().startsWith(actionName)).findFirst();
                            if (singleIntention.isEmpty()) {
                                actionCallback.reject(actionName + " is not found among " + combined);
                            }
                            if (invoke) {
                                singleIntention.ifPresent(c -> ShowIntentionActionsHandler.chooseActionAndInvoke((PsiFile)psiFile, (Editor)editor, (IntentionAction)c.getAction(), (String)c.getAction().getText()));
                            }
                        }
                        if (!invoke || actionName.isEmpty()) {
                            CachedIntentions cachedIntentions = CachedIntentions.create((Project)project, (PsiFile)psiFile, (Editor)editor, (ShowIntentionsPass.IntentionsInfo)intentions);
                            IntentionHintComponent.showIntentionHint((Project)project, (PsiFile)psiFile, (Editor)editor, (boolean)true, (CachedIntentions)cachedIntentions);
                        }
                    });
                    actionCallback.setDone();
                } else {
                    actionCallback.reject("PSI File is null");
                }
            } else {
                actionCallback.reject("Editor is not opened");
            }
        }));
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            ShowAltEnter.$$$reportNull$$$0(2);
        }
        return promise;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/ShowAltEnter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/ShowAltEnter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

