/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.commands.TestTipsAndFeaturesIntegrationCommand;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J8\u0010\f\u001a\u00020\u0003\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0002J\u0016\u0010\u0017\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0002J\u0016\u0010\u0018\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0002J$\u0010\u0019\u001a\u00020\u00032\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/performancePlugin/commands/TestTipsAndFeaturesIntegrationCommand;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "findIncorrectValues", "T", "values", "", "message", "predicate", "Lkotlin/Function1;", "", "testEveryFeatureHasDisplayName", "features", "Lcom/intellij/featureStatistics/FeatureDescriptor;", "testEveryFeatureHasLinkedTip", "testEveryGroupHasDisplayName", "testEveryTipLinkedToAtLeastOneFeature", "tips", "Lcom/intellij/ide/util/TipAndTrickBean;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nTestTipsAndFeaturesIntegrationCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestTipsAndFeaturesIntegrationCommand.kt\ncom/jetbrains/performancePlugin/commands/TestTipsAndFeaturesIntegrationCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1549#2:73\n1620#2,3:74\n1603#2,9:77\n1855#2:86\n1856#2:88\n1612#2:89\n766#2:90\n857#2,2:91\n766#2:93\n857#2,2:94\n1#3:87\n*S KotlinDebug\n*F\n+ 1 TestTipsAndFeaturesIntegrationCommand.kt\ncom/jetbrains/performancePlugin/commands/TestTipsAndFeaturesIntegrationCommand\n*L\n18#1:73\n18#1:74,3\n54#1:77,9\n54#1:86\n54#1:88\n54#1:89\n54#1:90\n54#1:91,2\n62#1:93\n62#1:94,2\n54#1:87\n*E\n"})
public final class TestTipsAndFeaturesIntegrationCommand
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%testTipsAndFeaturesIntegration";

    public TestTipsAndFeaturesIntegrationCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        StringBuilder stringBuilder;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper callback = new ActionCallbackProfilerStopper();
        List tips = TipAndTrickBean.EP_NAME.getExtensionList();
        ProductivityFeaturesRegistry productivityFeaturesRegistry = ProductivityFeaturesRegistry.getInstance();
        if (productivityFeaturesRegistry == null) {
            throw new IllegalStateException("ProductivityFeaturesRegistry doesn't created".toString());
        }
        ProductivityFeaturesRegistry registry = productivityFeaturesRegistry;
        Set set = registry.getFeatureIds();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"registry.featureIds");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(registry.getFeatureDescriptor((String)p0));
        }
        List features = (List)destination$iv$iv;
        StringBuilder $this$_execute_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_execute_u24lambda_u240.append(this.testEveryTipLinkedToAtLeastOneFeature(tips, features));
        $this$_execute_u24lambda_u240.append(this.testEveryFeatureHasLinkedTip(features));
        $this$_execute_u24lambda_u240.append(this.testEveryFeatureHasDisplayName(features));
        $this$_execute_u24lambda_u240.append(this.testEveryGroupHasDisplayName(features));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String issues = string;
        if (((CharSequence)issues).length() > 0) {
            throw new Exception(issues);
        }
        callback.setDone();
        return Promises.toPromise((ActionCallback)callback);
    }

    private final String testEveryTipLinkedToAtLeastOneFeature(List<TipAndTrickBean> tips, List<? extends FeatureDescriptor> features) {
        return this.findIncorrectValues(tips, "Tips that are not linked to any feature", (Function1)new Function1<TipAndTrickBean, Boolean>(features){
            final /* synthetic */ List<FeatureDescriptor> $features;
            {
                this.$features = $features;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TipAndTrickBean tip) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)tip, (String)"tip");
                    Iterable iterable = this.$features;
                    for (T t : iterable) {
                        FeatureDescriptor it = (FeatureDescriptor)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getTipId(), (Object)tip.getId())) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                return v0 == null;
            }
        });
    }

    private final String testEveryFeatureHasLinkedTip(List<? extends FeatureDescriptor> features) {
        return this.findIncorrectValues(features, "Features without specified tip file", testEveryFeatureHasLinkedTip.1.INSTANCE);
    }

    private final String testEveryFeatureHasDisplayName(List<? extends FeatureDescriptor> features) {
        return this.findIncorrectValues(features, "Features without display name", testEveryFeatureHasDisplayName.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final String testEveryGroupHasDisplayName(List<? extends FeatureDescriptor> features) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = features;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FeatureDescriptor it = (FeatureDescriptor)element$iv$iv;
            boolean bl2 = false;
            if (it.getGroupId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!StringsKt.startsWith$default((String)it, (String)"!", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List groupsWithoutDisplayName = (List)destination$iv$iv;
        return !((Collection)groupsWithoutDisplayName).isEmpty() ? "Groups without display name:\n" + CollectionsKt.joinToString$default((Iterable)groupsWithoutDisplayName, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n" : "";
    }

    /*
     * WARNING - void declaration
     */
    private final <T> String findIncorrectValues(List<? extends T> values, String message, Function1<? super T, Boolean> predicate) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = values;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List incorrect = (List)destination$iv$iv;
        return !((Collection)incorrect).isEmpty() ? message + ":\n" + CollectionsKt.joinToString$default((Iterable)incorrect, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n" : "";
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/performancePlugin/commands/TestTipsAndFeaturesIntegrationCommand$Companion;", "", "()V", "PREFIX", "", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

