/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.HashMap;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.PluginValidationManager;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.internal.AbstractMavenPluginParametersValidator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

@Singleton
@Named
class DeprecatedCoreExpressionValidator
extends AbstractMavenPluginParametersValidator {
    private static final HashMap<String, String> DEPRECATED_CORE_PARAMETERS;
    private static final String ARTIFACT_REPOSITORY_REASON = "ArtifactRepository type is deprecated and its use in Mojos should be avoided.";

    @Inject
    DeprecatedCoreExpressionValidator(PluginValidationManager pluginValidationManager) {
        super(pluginValidationManager);
    }

    @Override
    protected String getParameterLogReason(Parameter parameter) {
        return "uses deprecated parameter expression '" + parameter.getDefaultValue() + "': " + DEPRECATED_CORE_PARAMETERS.get(parameter.getDefaultValue());
    }

    @Override
    protected void doValidate(MavenSession mavenSession, MojoDescriptor mojoDescriptor, Class<?> mojoClass, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        if (mojoDescriptor.getParameters() == null) {
            return;
        }
        mojoDescriptor.getParameters().stream().filter(this::isDeprecated).map(this::formatParameter).forEach(m -> this.pluginValidationManager.reportPluginMojoValidationIssue(mavenSession, mojoDescriptor, mojoClass, (String)m));
    }

    private boolean isDeprecated(Parameter parameter) {
        return Objects.equals(ArtifactRepository.class.getName(), parameter.getType()) && DEPRECATED_CORE_PARAMETERS.containsKey(parameter.getDefaultValue());
    }

    static {
        HashMap<String, String> deprecatedCoreParameters = new HashMap<String, String>();
        deprecatedCoreParameters.put("${localRepository}", ARTIFACT_REPOSITORY_REASON);
        deprecatedCoreParameters.put("${session.localRepository}", ARTIFACT_REPOSITORY_REASON);
        DEPRECATED_CORE_PARAMETERS = deprecatedCoreParameters;
    }
}

