/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.util.ArrayList;
import java.util.Collection;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.Project;

public class LegacyIdeaProjectModelAdapter
implements Build {
    private final String myName;
    private final BuildIdentifier myBuildIdentifier;
    private final Collection<Project> myProjectModels;

    public LegacyIdeaProjectModelAdapter(@NotNull IdeaProject ideaProject) {
        if (ideaProject == null) {
            LegacyIdeaProjectModelAdapter.$$$reportNull$$$0(0);
        }
        this.myName = ideaProject.getName();
        DomainObjectSet ideaModules = ideaProject.getChildren();
        assert (!ideaModules.isEmpty());
        IdeaModule ideaModule = (IdeaModule)ideaModules.getAt(0);
        this.myBuildIdentifier = ideaModule.getGradleProject().getProjectIdentifier().getBuildIdentifier();
        this.myProjectModels = new ArrayList<Project>(ideaModules.size());
        for (final IdeaModule module : ideaModules) {
            this.myProjectModels.add(new Project(){

                @Override
                public String getName() {
                    return module.getGradleProject().getName();
                }

                public ProjectIdentifier getProjectIdentifier() {
                    return module.getGradleProject().getProjectIdentifier();
                }
            });
        }
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.myBuildIdentifier;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Collection<Project> getProjects() {
        return this.myProjectModels;
    }

    @Override
    public BuildIdentifier getParentBuildIdentifier() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaProject", "org/jetbrains/plugins/gradle/model/LegacyIdeaProjectModelAdapter", "<init>"));
    }
}

