/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.annotators;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.editorconfig.language.highlighting.EditorConfigSyntaxHighlighter;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigAsteriskPattern;
import org.editorconfig.language.psi.EditorConfigCharClassExclamation;
import org.editorconfig.language.psi.EditorConfigCharClassLetter;
import org.editorconfig.language.psi.EditorConfigDoubleAsteriskPattern;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigFlatOptionKey;
import org.editorconfig.language.psi.EditorConfigFlatPattern;
import org.editorconfig.language.psi.EditorConfigOption;
import org.editorconfig.language.psi.EditorConfigOptionValueIdentifier;
import org.editorconfig.language.psi.EditorConfigQualifiedKeyPart;
import org.editorconfig.language.psi.EditorConfigQualifiedOptionKey;
import org.editorconfig.language.psi.EditorConfigQuestionPattern;
import org.editorconfig.language.psi.EditorConfigRawOptionValue;
import org.editorconfig.language.psi.EditorConfigRootDeclarationKey;
import org.editorconfig.language.psi.EditorConfigRootDeclarationValue;
import org.editorconfig.language.psi.EditorConfigVisitor;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigDeclarationDescriptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u000203H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/editorconfig/language/codeinsight/annotators/EditorConfigAnnotatorVisitor;", "Lorg/editorconfig/language/psi/EditorConfigVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "checkEdgeDots", "", "edgeElement", "Lcom/intellij/psi/PsiElement;", "neighbourElement", "checkInnerDots", "key", "Lorg/editorconfig/language/psi/EditorConfigQualifiedOptionKey;", "checkLineBreaks", "option", "Lorg/editorconfig/language/psi/EditorConfigOption;", "special", "pattern", "visitAsteriskPattern", "Lorg/editorconfig/language/psi/EditorConfigAsteriskPattern;", "visitCharClassExclamation", "exclamation", "Lorg/editorconfig/language/psi/EditorConfigCharClassExclamation;", "visitCharClassLetter", "letter", "Lorg/editorconfig/language/psi/EditorConfigCharClassLetter;", "visitDoubleAsteriskPattern", "Lorg/editorconfig/language/psi/EditorConfigDoubleAsteriskPattern;", "visitFlatOptionKey", "flatKey", "Lorg/editorconfig/language/psi/EditorConfigFlatOptionKey;", "visitFlatPattern", "flatPattern", "Lorg/editorconfig/language/psi/EditorConfigFlatPattern;", "visitOption", "visitOptionValueIdentifier", "identifier", "Lorg/editorconfig/language/psi/EditorConfigOptionValueIdentifier;", "visitQualifiedKeyPart", "keyPart", "Lorg/editorconfig/language/psi/EditorConfigQualifiedKeyPart;", "visitQualifiedOptionKey", "visitQuestionPattern", "Lorg/editorconfig/language/psi/EditorConfigQuestionPattern;", "visitRawOptionValue", "rawOptionValue", "Lorg/editorconfig/language/psi/EditorConfigRawOptionValue;", "visitRootDeclarationKey", "Lorg/editorconfig/language/psi/EditorConfigRootDeclarationKey;", "visitRootDeclarationValue", "value", "Lorg/editorconfig/language/psi/EditorConfigRootDeclarationValue;", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigAnnotatorVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigAnnotatorVisitor.kt\norg/editorconfig/language/codeinsight/annotators/EditorConfigAnnotatorVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1855#2,2:145\n*S KotlinDebug\n*F\n+ 1 EditorConfigAnnotatorVisitor.kt\norg/editorconfig/language/codeinsight/annotators/EditorConfigAnnotatorVisitor\n*L\n24#1:145,2\n*E\n"})
public final class EditorConfigAnnotatorVisitor
extends EditorConfigVisitor {
    @NotNull
    private final AnnotationHolder holder;

    public EditorConfigAnnotatorVisitor(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    @Override
    public void visitQualifiedOptionKey(@NotNull EditorConfigQualifiedOptionKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PsiElement psiElement = key.getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"key.firstChild");
        this.checkEdgeDots(psiElement, key.getFirstChild().getNextSibling());
        PsiElement psiElement2 = key.getLastChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"key.lastChild");
        this.checkEdgeDots(psiElement2, key.getLastChild().getPrevSibling());
        this.checkInnerDots(key);
    }

    private final void checkInnerDots(EditorConfigQualifiedOptionKey key) {
        PsiElement firstDot = null;
        PsiElement lastDot = null;
        JBIterable jBIterable = SyntaxTraverser.psiTraverser().children((Object)key);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"psiTraverser().children(key)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)EditorConfigElementTypes.DOT)) {
                if (firstDot == null) {
                    firstDot = it;
                }
                lastDot = it;
                continue;
            }
            if (!Intrinsics.areEqual(firstDot, lastDot)) {
                TextRange range;
                String message2 = EditorConfigBundle.INSTANCE.get("annotator.error.multiple-dots");
                PsiElement psiElement = firstDot;
                Intrinsics.checkNotNull((Object)psiElement);
                int start = psiElement.getTextRange().getStartOffset();
                PsiElement psiElement2 = lastDot;
                Intrinsics.checkNotNull((Object)psiElement2);
                int end = psiElement2.getTextRange().getEndOffset();
                Intrinsics.checkNotNullExpressionValue((Object)TextRange.create((int)start, (int)end), (String)"create(start, end)");
                this.holder.newAnnotation(HighlightSeverity.ERROR, message2).range(range).create();
                firstDot = null;
                lastDot = null;
                continue;
            }
            firstDot = null;
            lastDot = null;
        }
    }

    private final void checkEdgeDots(PsiElement edgeElement, PsiElement neighbourElement) {
        if (!Intrinsics.areEqual((Object)edgeElement.getNode().getElementType(), (Object)EditorConfigElementTypes.DOT)) {
            return;
        }
        PsiElement psiElement = neighbourElement;
        if (Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)EditorConfigElementTypes.DOT)) {
            return;
        }
        String message2 = EditorConfigBundle.INSTANCE.get("annotator.error.key.dangling-dot");
        this.holder.newAnnotation(HighlightSeverity.ERROR, message2).range(edgeElement).create();
    }

    @Override
    public void visitOption(@NotNull EditorConfigOption option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        this.checkLineBreaks(option);
    }

    private final void checkLineBreaks(EditorConfigOption option) {
        if (!option.textContains('\n')) {
            return;
        }
        String message2 = EditorConfigBundle.INSTANCE.get("annotator.error.option.suspicious.line.break");
        this.holder.newAnnotation(HighlightSeverity.ERROR, message2).range((PsiElement)option).create();
    }

    @Override
    public void visitFlatOptionKey(@NotNull EditorConfigFlatOptionKey flatKey) {
        Intrinsics.checkNotNullParameter((Object)flatKey, (String)"flatKey");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)flatKey).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_KEY()).create();
    }

    @Override
    public void visitQualifiedKeyPart(@NotNull EditorConfigQualifiedKeyPart keyPart) {
        Intrinsics.checkNotNullParameter((Object)keyPart, (String)"keyPart");
        EditorConfigDescriptor descriptor2 = keyPart.getDescriptor(false);
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)keyPart).textAttributes(descriptor2 instanceof EditorConfigDeclarationDescriptor ? EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_KEY() : EditorConfigSyntaxHighlighter.INSTANCE.getKEY_DESCRIPTION()).create();
    }

    @Override
    public void visitOptionValueIdentifier(@NotNull EditorConfigOptionValueIdentifier identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)identifier).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_VALUE()).create();
    }

    @Override
    public void visitRawOptionValue(@NotNull EditorConfigRawOptionValue rawOptionValue) {
        Intrinsics.checkNotNullParameter((Object)rawOptionValue, (String)"rawOptionValue");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)rawOptionValue).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_VALUE()).create();
    }

    @Override
    public void visitFlatPattern(@NotNull EditorConfigFlatPattern flatPattern) {
        Intrinsics.checkNotNullParameter((Object)flatPattern, (String)"flatPattern");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)flatPattern).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPATTERN()).create();
        if (!flatPattern.textContains('\\')) {
            return;
        }
        String text = flatPattern.getText();
        int offset = flatPattern.getTextOffset();
        for (int index = 0; index < text.length(); ++index) {
            if (text.charAt(index) != '\\') continue;
            TextRange range = new TextRange(offset + index, offset + index + 2);
            if (StringsKt.contains$default((CharSequence)" \r\n\t\\#;!?*[]{}", (char)text.charAt(++index), (boolean)false, (int)2, null)) {
                this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getVALID_CHAR_ESCAPE()).create();
                continue;
            }
            String message2 = EditorConfigBundle.INSTANCE.get("annotator.error.illegal.char.escape");
            this.holder.newAnnotation(HighlightSeverity.INFORMATION, message2).range(range).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getINVALID_CHAR_ESCAPE()).create();
        }
    }

    @Override
    public void visitAsteriskPattern(@NotNull EditorConfigAsteriskPattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.special(pattern);
    }

    @Override
    public void visitDoubleAsteriskPattern(@NotNull EditorConfigDoubleAsteriskPattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.special(pattern);
    }

    private final void special(PsiElement pattern) {
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(pattern).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getSPECIAL_SYMBOL()).create();
    }

    @Override
    public void visitCharClassExclamation(@NotNull EditorConfigCharClassExclamation exclamation) {
        Intrinsics.checkNotNullParameter((Object)exclamation, (String)"exclamation");
        this.special(exclamation);
    }

    @Override
    public void visitQuestionPattern(@NotNull EditorConfigQuestionPattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.special(pattern);
    }

    @Override
    public void visitCharClassLetter(@NotNull EditorConfigCharClassLetter letter) {
        Intrinsics.checkNotNullParameter((Object)letter, (String)"letter");
        if (!letter.isEscape()) {
            this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)letter).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPATTERN()).create();
        } else if (letter.isValidEscape()) {
            this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)letter).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getVALID_CHAR_ESCAPE()).create();
        } else {
            this.holder.newAnnotation(HighlightSeverity.INFORMATION, EditorConfigBundle.INSTANCE.get("annotator.error.illegal.char.escape")).range((PsiElement)letter).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getINVALID_CHAR_ESCAPE()).create();
        }
    }

    @Override
    public void visitRootDeclarationKey(@NotNull EditorConfigRootDeclarationKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)key).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_KEY()).create();
    }

    @Override
    public void visitRootDeclarationValue(@NotNull EditorConfigRootDeclarationValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)value).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_VALUE()).create();
    }
}

