/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.util.containers.PeekableIteratorWrapper;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/codeInsight/actions/ChangedRangesShifter;", "", "()V", "dirtyEarlyShift", "", "dirtyEnd", "dirtyHasEarly", "", "dirtyLaterShift", "dirtyStart", "earlyShift", "laterShift", "result", "", "Lcom/intellij/diff/util/Range;", "execute", "", "earlyChanges", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "laterChanges", "flush", "", "nextLine", "handleEarly", "range", "handleLater", "markDirtyRange", "start", "end", "intellij.platform.vcs.impl"})
public final class ChangedRangesShifter {
    @NotNull
    private final List<Range> result = new ArrayList();
    private int dirtyStart = -1;
    private int dirtyEnd = -1;
    private boolean dirtyHasEarly;
    private int earlyShift;
    private int laterShift;
    private int dirtyEarlyShift;
    private int dirtyLaterShift;

    @NotNull
    public final List<Range> execute(@NotNull FairDiffIterable earlyChanges, @NotNull FairDiffIterable laterChanges) {
        Intrinsics.checkNotNullParameter((Object)earlyChanges, (String)"earlyChanges");
        Intrinsics.checkNotNullParameter((Object)laterChanges, (String)"laterChanges");
        PeekableIteratorWrapper it1 = new PeekableIteratorWrapper(earlyChanges.changes());
        PeekableIteratorWrapper it2 = new PeekableIteratorWrapper(laterChanges.changes());
        while (it1.hasNext() || it2.hasNext()) {
            if (!it2.hasNext()) {
                Object object = it1.next();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it1.next()");
                this.handleEarly((Range)object);
                continue;
            }
            if (!it1.hasNext()) {
                Object object = it2.next();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it2.next()");
                this.handleLater((Range)object);
                continue;
            }
            Range range1 = (Range)it1.peek();
            Range range2 = (Range)it2.peek();
            if (range1.start2 <= range2.start1) {
                Object object = it1.next();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it1.next()");
                this.handleEarly((Range)object);
                continue;
            }
            Object object = it2.next();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it2.next()");
            this.handleLater((Range)object);
        }
        this.flush(Integer.MAX_VALUE);
        return this.result;
    }

    private final void handleEarly(Range range) {
        this.flush(range.start2);
        this.dirtyEarlyShift -= DiffIterableUtil.getRangeDelta((Range)range);
        this.markDirtyRange(range.start2, range.end2);
        this.dirtyHasEarly = true;
    }

    private final void handleLater(Range range) {
        this.flush(range.start1);
        this.dirtyLaterShift += DiffIterableUtil.getRangeDelta((Range)range);
        this.markDirtyRange(range.start1, range.end1);
    }

    private final void markDirtyRange(int start2, int end) {
        if (this.dirtyEnd == -1) {
            this.dirtyStart = start2;
            this.dirtyEnd = end;
        } else {
            this.dirtyEnd = Math.max(this.dirtyEnd, end);
        }
    }

    private final void flush(int nextLine) {
        if (this.dirtyEnd != -1 && this.dirtyEnd < nextLine) {
            if (this.dirtyHasEarly) {
                this.result.add(new Range(this.dirtyStart + this.earlyShift, this.dirtyEnd + this.earlyShift + this.dirtyEarlyShift, this.dirtyStart + this.laterShift, this.dirtyEnd + this.laterShift + this.dirtyLaterShift));
            }
            this.dirtyStart = -1;
            this.dirtyEnd = -1;
            this.dirtyHasEarly = false;
            this.earlyShift += this.dirtyEarlyShift;
            this.laterShift += this.dirtyLaterShift;
            this.dirtyEarlyShift = 0;
            this.dirtyLaterShift = 0;
        }
    }
}

