/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionApplicationException;
import com.intellij.codeInspection.InspectionProfileLoader;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.codeInspection.inspectionProfile.YamlInspectionProfileImpl;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.parser.ParserException;

public abstract class InspectionProfileLoaderBase<T extends InspectionProfileImpl>
implements InspectionProfileLoader<T> {
    protected Project project;

    public InspectionProfileLoaderBase(Project project2) {
        this.project = project2;
    }

    @Nullable
    protected InspectionProfileImpl tryLoadProfileFromYaml(@NotNull String profilePath, @NotNull InspectionToolsSupplier inspectionToolsSupplier, @NotNull BaseInspectionProfileManager profileManager) {
        if (profilePath == null) {
            InspectionProfileLoaderBase.$$$reportNull$$$0(0);
        }
        if (inspectionToolsSupplier == null) {
            InspectionProfileLoaderBase.$$$reportNull$$$0(1);
        }
        if (profileManager == null) {
            InspectionProfileLoaderBase.$$$reportNull$$$0(2);
        }
        if (!YamlInspectionProfileImpl.isYamlFile(profilePath)) {
            return null;
        }
        if (!new File(profilePath).isFile()) {
            throw new InspectionApplicationException("Inspection profile '" + profilePath + "' does not exist");
        }
        try {
            return YamlInspectionProfileImpl.loadFrom(this.project, profilePath, inspectionToolsSupplier, profileManager).buildEffectiveProfile();
        }
        catch (ParserException e) {
            throw new InspectionApplicationException("Parse error in '" + profilePath + "': " + e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "profilePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "inspectionToolsSupplier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "profileManager";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/InspectionProfileLoaderBase";
        objectArray[2] = "tryLoadProfileFromYaml";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

