/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview;

import com.intellij.collaboration.ui.codereview.NodeCodeReviewProgressState;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.util.ui.JBUI;
import icons.CollaborationToolsIcons;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0000\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001b\u0010\u0015\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\u00172\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J@\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0011H\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/collaboration/ui/codereview/CodeReviewProgressRenderer;", "Lcom/intellij/ui/CellRendererPanel;", "Ljavax/swing/tree/TreeCellRenderer;", "renderer", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "codeReviewProgressStateProvider", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lcom/intellij/collaboration/ui/codereview/NodeCodeReviewProgressState;", "(Lcom/intellij/ui/ColoredTreeCellRenderer;Lkotlin/jvm/functions/Function1;)V", "iconLabel", "Ljavax/swing/JLabel;", "getIcon", "Ljavax/swing/Icon;", "node", "getReadingStateIcon", "isRead", "", "getReadingStateWithDiscussionsIcon", "discussionsCount", "", "getText", "", "Lcom/intellij/openapi/util/NlsSafe;", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "expanded", "leaf", "row", "hasFocus", "Companion", "intellij.platform.collaborationTools"})
public final class CodeReviewProgressRenderer
extends CellRendererPanel
implements TreeCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColoredTreeCellRenderer renderer;
    @NotNull
    private final Function1<ChangesBrowserNode<?>, NodeCodeReviewProgressState> codeReviewProgressStateProvider;
    @NotNull
    private final JLabel iconLabel;
    private static final int TEXT_ICON_GAP = 4;
    private static final int ICON_BORDER = 10;

    /*
     * WARNING - void declaration
     */
    public CodeReviewProgressRenderer(@NotNull ColoredTreeCellRenderer renderer, @NotNull Function1<? super ChangesBrowserNode<?>, NodeCodeReviewProgressState> codeReviewProgressStateProvider) {
        void $this$iconLabel_u24lambda_u240;
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter(codeReviewProgressStateProvider, (String)"codeReviewProgressStateProvider");
        this.renderer = renderer;
        this.codeReviewProgressStateProvider = codeReviewProgressStateProvider;
        JLabel jLabel2 = jLabel = new JLabel();
        CodeReviewProgressRenderer codeReviewProgressRenderer = this;
        boolean bl = false;
        $this$iconLabel_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)0, (int)10));
        codeReviewProgressRenderer.iconLabel = jLabel;
        this.setLayout((LayoutManager)new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill().noGrid()));
    }

    @Override
    @NotNull
    public Component getTreeCellRendererComponent(@NotNull JTree tree2, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ChangesBrowserNode cfr_ignored_0 = (ChangesBrowserNode)value2;
        this.removeAll();
        this.setBackground(null);
        this.setSelected(selected);
        Component comp = this.renderer.getTreeCellRendererComponent(tree2, value2, selected, expanded, leaf, row2, hasFocus);
        this.add(comp, new CC().minWidth("0").dockWest());
        Icon icon2 = this.getIcon((ChangesBrowserNode)value2);
        this.iconLabel.setIcon(icon2);
        String text2 = this.getText((ChangesBrowserNode)value2);
        this.iconLabel.setText(text2);
        FontMetrics fm = this.iconLabel.getFontMetrics(this.iconLabel.getFont());
        Icon icon3 = icon2;
        String string2 = text2;
        int width = (icon3 != null ? icon3.getIconWidth() : 0) + this.iconLabel.getIconTextGap() + fm.charWidth('8') * (string2 != null ? string2.length() : 0) + this.iconLabel.getInsets().left + this.iconLabel.getInsets().right;
        this.add(this.iconLabel, new CC().minWidth(width + "px").dockEast());
        return (Component)((Object)this);
    }

    private final Icon getIcon(ChangesBrowserNode<?> node) {
        NodeCodeReviewProgressState state = (NodeCodeReviewProgressState)this.codeReviewProgressStateProvider.invoke(node);
        boolean isRead = state.isRead();
        int discussionsCount = state.getDiscussionsCount();
        return discussionsCount <= 0 ? this.getReadingStateIcon(isRead) : this.getReadingStateWithDiscussionsIcon(isRead, discussionsCount);
    }

    private final String getText(ChangesBrowserNode<?> node) {
        NodeCodeReviewProgressState state = (NodeCodeReviewProgressState)this.codeReviewProgressStateProvider.invoke(node);
        int discussionsCount = state.getDiscussionsCount();
        return discussionsCount <= 0 ? null : String.valueOf(discussionsCount);
    }

    private final Icon getReadingStateIcon(boolean isRead) {
        return !isRead ? CollaborationToolsIcons.FileUnread : null;
    }

    private final Icon getReadingStateWithDiscussionsIcon(boolean isRead, int discussionsCount) {
        Icon icon2;
        if (!(discussionsCount > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!isRead) {
            Icon icon3 = CollaborationToolsIcons.Review.CommentUnread;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"CommentUnread");
        } else {
            Icon icon4 = CollaborationToolsIcons.Review.CommentUnresolved;
            icon2 = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"CommentUnresolved");
        }
        return icon2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/collaboration/ui/codereview/CodeReviewProgressRenderer$Companion;", "", "()V", "ICON_BORDER", "", "TEXT_ICON_GAP", "intellij.platform.collaborationTools"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

