/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.util;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.util.UriUtilKt;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0013\u0010\r\u001a\u00070\u0004\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u0005\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/collaboration/util/URIUtil;", "", "()V", "addHttpsSchemaIfMissing", "", "uri", "equalWithoutSchema", "", "first", "Ljava/net/URI;", "second", "isValidHttpUri", "normalizeAndValidateHttpUri", "toStringWithoutScheme", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.platform.collaborationTools"})
@SourceDebugExtension(value={"SMAP\nURIUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URIUtil.kt\ncom/intellij/collaboration/util/URIUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class URIUtil {
    @NotNull
    public static final URIUtil INSTANCE = new URIUtil();

    private URIUtil() {
    }

    @NotNull
    public final String normalizeAndValidateHttpUri(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String normalized = StringsKt.removeSuffix((String)this.addHttpsSchemaIfMissing(uri), (CharSequence)"/");
        if (!StringsKt.startsWith$default((String)normalized, (String)"http", (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string2 = CollaborationToolsBundle.message("login.server.invalid", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"login.server.invalid\")");
            String string3 = string2;
            throw new IllegalArgumentException(string3.toString());
        }
        URI.create(normalized);
        return normalized;
    }

    private final String addHttpsSchemaIfMissing(String uri) {
        if (StringsKt.contains$default((CharSequence)uri, (CharSequence)"://", (boolean)false, (int)2, null)) {
            return uri;
        }
        return "https://" + uri;
    }

    public final boolean isValidHttpUri(@NotNull String uri) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            this.normalizeAndValidateHttpUri(uri);
            bl = true;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    public final boolean equalWithoutSchema(@NotNull URI first, @NotNull URI second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        String stubScheme = "stub";
        return Intrinsics.areEqual((Object)UriUtilKt.withScheme((URI)first, (String)stubScheme), (Object)UriUtilKt.withScheme((URI)second, (String)stubScheme));
    }

    @NotNull
    public final String toStringWithoutScheme(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String schemeText = uri.getScheme() + "://";
        String string2 = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.toString()");
        return StringsKt.removePrefix((String)string2, (CharSequence)schemeText);
    }
}

