/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageListNode
extends AbstractTreeNode<Object> {
    protected final CoverageSuitesBundle myBundle;
    protected final CoverageViewManager.StateBean myStateBean;
    private final FileStatusManager myFileStatusManager;
    private volatile List<AbstractTreeNode<?>> myChildren;
    private final boolean myIsLeaf;
    private boolean myFullyCovered;
    private CoverageListRootNode myRoot;

    public CoverageListNode(Project project2, @NotNull PsiNamedElement classOrPackage, CoverageSuitesBundle bundle, CoverageViewManager.StateBean stateBean) {
        if (classOrPackage == null) {
            CoverageListNode.$$$reportNull$$$0(0);
        }
        this(project2, classOrPackage, bundle, stateBean, false);
    }

    public CoverageListNode(Project project2, @NotNull PsiNamedElement classOrPackage, CoverageSuitesBundle bundle, CoverageViewManager.StateBean stateBean, boolean isLeaf) {
        if (classOrPackage == null) {
            CoverageListNode.$$$reportNull$$$0(1);
        }
        super(project2, (Object)classOrPackage);
        this.myFullyCovered = false;
        this.myName = (String)ReadAction.compute(() -> classOrPackage.getName());
        this.myBundle = bundle;
        this.myStateBean = stateBean;
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        this.myIsLeaf = isLeaf;
    }

    public synchronized void reset() {
        this.myChildren = null;
    }

    public boolean isLeaf() {
        return this.myIsLeaf;
    }

    protected boolean isFullyCovered() {
        return this.myFullyCovered;
    }

    public void setFullyCovered(boolean value2) {
        this.myFullyCovered = value2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CoverageListRootNode getRoot() {
        if (this.myRoot != null) return this.myRoot;
        CoverageListNode parent = (CoverageListNode)this.getParent();
        if (parent == null) {
            CoverageListRootNode root;
            CoverageListNode coverageListNode = this;
            if (!(coverageListNode instanceof CoverageListRootNode)) throw new RuntimeException("Coverage node unexpectedly has no parent " + this + ". Each coverage node is supposed to have a parent or to be CoverageListRootNode instance.");
            this.myRoot = root = (CoverageListRootNode)coverageListNode;
            return this.myRoot;
        } else {
            this.myRoot = parent.getRoot();
        }
        return this.myRoot;
    }

    @NotNull
    public List<? extends AbstractTreeNode<?>> getChildren() {
        List<? extends AbstractTreeNode<?>> list = this.getChildrenInternal();
        if (list == null) {
            CoverageListNode.$$$reportNull$$$0(2);
        }
        return list;
    }

    private synchronized List<? extends AbstractTreeNode<?>> getChildrenInternal() {
        if (this.myChildren == null) {
            List<AbstractTreeNode<?>> nodes = this.myBundle.getCoverageEngine().createCoverageViewExtension(this.myProject, this.myBundle, this.myStateBean).getChildrenNodes(this);
            this.myChildren = this.filterChildren(nodes);
        }
        return this.myChildren;
    }

    protected List<AbstractTreeNode<?>> filterChildren(List<AbstractTreeNode<?>> nodes) {
        if (this.myStateBean.isShowOnlyModified() || this.myStateBean.isHideFullyCovered()) {
            nodes = nodes.stream().filter(node -> {
                boolean filtered = true;
                boolean isLeaf = false;
                if (node instanceof CoverageListNode) {
                    CoverageListNode coverageNode = (CoverageListNode)((Object)node);
                    isLeaf = coverageNode.isLeaf();
                    boolean fullyCovered = coverageNode.isFullyCovered();
                    if (this.myStateBean.isHideFullyCovered() && fullyCovered) {
                        filtered = false;
                        this.getRoot().setHasFullyCoveredChildren(true);
                    }
                }
                if (this.myStateBean.isShowOnlyModified() && isLeaf) {
                    boolean isModified;
                    FileStatus status = node.getFileStatus();
                    boolean bl = isModified = status == FileStatus.MODIFIED || status == FileStatus.ADDED || status == FileStatus.UNKNOWN;
                    if (!isModified) {
                        filtered = false;
                        this.getRoot().setHasVCSFilteredChildren(true);
                    }
                }
                return filtered;
            }).toList();
        }
        return nodes.stream().filter(node -> {
            if (node instanceof CoverageListNode && ((CoverageListNode)((Object)node)).isLeaf()) {
                return true;
            }
            return !node.getChildren().isEmpty();
        }).toList();
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            CoverageListNode.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.getValue();
            if (object instanceof PsiNamedElement) {
                PsiNamedElement value2 = (PsiNamedElement)object;
                if (value2 instanceof PsiQualifiedNamedElement && (this.myStateBean.myFlattenPackages && value2.getContainingFile() == null || this.getParent() instanceof CoverageListRootNode)) {
                    presentation2.setPresentableText(((PsiQualifiedNamedElement)value2).getQualifiedName());
                } else {
                    presentation2.setPresentableText(value2.getName());
                }
                presentation2.setIcon(value2.getIcon(0));
                presentation2.setForcedTextForeground(this.getFileStatus().getColor());
            }
        });
    }

    public FileStatus getFileStatus() {
        PsiFile containingFile = (PsiFile)ReadAction.compute(() -> {
            Object value2 = this.getValue();
            if (value2 instanceof PsiElement && ((PsiElement)value2).isValid()) {
                return ((PsiElement)value2).getContainingFile();
            }
            return null;
        });
        return containingFile != null ? this.myFileStatusManager.getStatus(containingFile.getVirtualFile()) : super.getFileStatus();
    }

    @Nullable
    protected Color computeBackgroundColor() {
        return null;
    }

    protected boolean shouldPostprocess() {
        return false;
    }

    public boolean canNavigate() {
        Object value2 = this.getValue();
        return value2 instanceof PsiElement && ((PsiElement)value2).isValid() && ((PsiElement)value2).getContainingFile() != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigate()) {
            PsiNamedElement value2 = (PsiNamedElement)this.getValue();
            if (requestFocus) {
                NavigationUtil.activateFileWithPsiElement((PsiElement)value2, (boolean)true);
            } else if (value2 instanceof NavigationItem) {
                ((NavigationItem)value2).navigate(false);
            }
        }
    }

    public int getWeight() {
        return (Integer)ReadAction.compute(() -> {
            Object value2 = this.getValue();
            if (value2 instanceof PsiElement && ((PsiElement)value2).getContainingFile() != null) {
                return 40;
            }
            return 30;
        });
    }

    public boolean contains(VirtualFile file) {
        boolean equalContainingFile;
        Object value2 = this.getValue();
        if (value2 instanceof PsiElement && (equalContainingFile = Comparing.equal((Object)PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)value2)), (Object)file))) {
            return true;
        }
        if (value2 instanceof PsiDirectory) {
            return this.contains(file, (PsiDirectory)value2);
        }
        if (value2 instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories;
            for (PsiDirectory directory : directories = ((PsiDirectoryContainer)value2).getDirectories()) {
                if (!this.contains(file, directory)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contains(VirtualFile file, PsiDirectory value2) {
        if (this.myStateBean.myFlattenPackages) {
            return Comparing.equal((Object)value2.getVirtualFile(), (Object)file.getParent());
        }
        return VfsUtilCore.isAncestor((VirtualFile)value2.getVirtualFile(), (VirtualFile)file, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrPackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/view/CoverageListNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/view/CoverageListNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

