/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.ui.CommitNode;
import com.intellij.dvcs.push.ui.CustomRenderedTreeNode;
import com.intellij.dvcs.push.ui.EditableTreeNode;
import com.intellij.dvcs.push.ui.PushLogChangesBrowser;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.dvcs.push.ui.TooltipNode;
import com.intellij.dvcs.push.ui.VcsBranchEditorListener;
import com.intellij.dvcs.push.ui.VcsEditableComponent;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.ui.EditSourceForDialogAction;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeHelper;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PushLog
extends JPanel
implements Disposable,
DataProvider {
    @NonNls
    private static final String CONTEXT_MENU = "Vcs.Push.ContextMenu";
    @NonNls
    private static final String START_EDITING = "startEditing";
    @NonNls
    private static final String TREE_SPLITTER_PROPORTION = "Vcs.Push.Splitter.Tree.Proportion";
    @NonNls
    private static final String DETAILS_SPLITTER_PROPORTION = "Vcs.Push.Splitter.Details.Proportion";
    private final PushLogChangesBrowser myChangesBrowser;
    private final JBLoadingPanel myChangesLoadingPane;
    private final CheckboxTree myTree;
    private final MyTreeCellRenderer myTreeCellRenderer;
    private final JScrollPane myScrollPane;
    private final CommitDetailsPanel myDetailsPanel;
    private final MyShowDetailsAction myShowDetailsAction;
    private boolean myShouldRepaint;
    private boolean mySyncStrategy;
    @Nullable
    @Nls
    private String mySyncRenderedText;
    @NotNull
    private final Project myProject;
    private final boolean myAllowSyncStrategy;

    public PushLog(@NotNull Project project2, final @NotNull CheckedTreeNode root, @NotNull ModalityState modalityState, boolean allowSyncStrategy) {
        if (project2 == null) {
            PushLog.$$$reportNull$$$0(0);
        }
        if (root == null) {
            PushLog.$$$reportNull$$$0(1);
        }
        if (modalityState == null) {
            PushLog.$$$reportNull$$$0(2);
        }
        this.myShouldRepaint = false;
        this.myProject = project2;
        this.myAllowSyncStrategy = allowSyncStrategy;
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root);
        treeModel.nodeStructureChanged((TreeNode)root);
        this.myTreeCellRenderer = new MyTreeCellRenderer();
        this.myTree = new CheckboxTree(this.myTreeCellRenderer, root){

            protected boolean shouldShowBusyIconIfNeeded() {
                return true;
            }

            public boolean isPathEditable(TreePath path2) {
                return this.isEditable() && path2.getLastPathComponent() instanceof DefaultMutableTreeNode;
            }

            protected void onNodeStateChanged(CheckedTreeNode node) {
                if (node instanceof EditableTreeNode) {
                    ((EditableTreeNode)node).fireOnSelectionChange(node.isChecked());
                }
            }

            public String getToolTipText(MouseEvent event) {
                TreePath path2 = PushLog.this.myTree.getPathForLocation(event.getX(), event.getY());
                if (path2 == null) {
                    return "";
                }
                Object node = path2.getLastPathComponent();
                if (!(node instanceof DefaultMutableTreeNode)) {
                    return "";
                }
                if (node instanceof TooltipNode) {
                    String select = DvcsBundle.message("push.select.all.commit.details", new Object[0]);
                    return ((TooltipNode)node).getTooltip() + "<p style='font-style:italic;color:gray;'>" + select + "</p>";
                }
                return "";
            }

            public boolean stopEditing() {
                JComponent editedComponent;
                InputVerifier verifier;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node instanceof EditableTreeNode && (verifier = (editedComponent = (JComponent)node.getUserObject()).getInputVerifier()) != null && !verifier.verify(editedComponent)) {
                    return false;
                }
                boolean result2 = super.stopEditing();
                if (PushLog.this.myShouldRepaint) {
                    PushLog.this.refreshNode((DefaultMutableTreeNode)root);
                }
                PushLog.this.restoreSelection(node);
                return result2;
            }

            public void cancelEditing() {
                DefaultMutableTreeNode lastSelectedPathComponent = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                super.cancelEditing();
                if (PushLog.this.myShouldRepaint) {
                    PushLog.this.refreshNode((DefaultMutableTreeNode)root);
                }
                PushLog.this.restoreSelection(lastSelectedPathComponent);
            }

            protected void installSpeedSearch() {
                TreeSpeedSearch.installOn((JTree)((Object)this), (boolean)false, path2 -> {
                    Object pathComponent = path2.getLastPathComponent();
                    if (pathComponent instanceof RepositoryNode) {
                        return ((RepositoryNode)pathComponent).getRepositoryName();
                    }
                    return pathComponent.toString();
                });
            }
        };
        this.myTree.setUI((TreeUI)((Object)new MyTreeUi()));
        this.myTree.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        this.myTree.setEditable(true);
        this.myTree.setShowsRootHandles(root.getChildCount() > 1);
        MyTreeCellEditor treeCellEditor = new MyTreeCellEditor();
        this.myTree.setCellEditor((TreeCellEditor)treeCellEditor);
        treeCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node instanceof EditableTreeNode) {
                    JComponent editedComponent = (JComponent)node.getUserObject();
                    InputVerifier verifier = editedComponent.getInputVerifier();
                    if (verifier != null && !verifier.verify(editedComponent)) {
                        ((EditableTreeNode)((Object)node)).fireOnCancel();
                    } else if (PushLog.this.mySyncStrategy) {
                        PushLog.this.resetEditSync();
                        ContainerUtil.process(PushLog.getChildNodesByType((DefaultMutableTreeNode)root, RepositoryNode.class, false), node1 -> {
                            node1.fireOnChange();
                            return true;
                        });
                    } else {
                        ((EditableTreeNode)((Object)node)).fireOnChange();
                    }
                }
                PushLog.this.myTree.firePropertyChange("tree.edit.mode", true, false);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node instanceof EditableTreeNode) {
                    ((EditableTreeNode)((Object)node)).fireOnCancel();
                }
                PushLog.this.resetEditSync();
                PushLog.this.myTree.firePropertyChange("tree.edit.mode", true, false);
            }
        });
        this.myTree.setInvokesStopCellEditing(true);
        this.myTree.setRootVisible(false);
        TreeUtil.collapseAll((JTree)this.myTree, (int)1);
        VcsBranchEditorListener linkMouseListener = new VcsBranchEditorListener(this.myTreeCellRenderer);
        linkMouseListener.installOn((Component)this.myTree);
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PushLog.this.onSelectionChanges();
            }
        });
        this.myTree.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node instanceof RepositoryNode && PushLog.this.myTree.isEditing()) {
                    PushLog.this.myTree.getCellEditor().getTreeCellEditorComponent((JTree)PushLog.this.myTree, node, true, false, false, PushLog.this.myTree.getRowForPath(TreeUtil.getPathFromRoot((TreeNode)node)));
                }
            }
        });
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke(113, 0), START_EDITING);
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "");
        ExpandAllAction expandAllAction = new ExpandAllAction((JTree)this.myTree);
        expandAllAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExpandAll").getShortcutSet(), (JComponent)this.myTree);
        CollapseAllAction collapseAll2 = new CollapseAllAction((JTree)this.myTree);
        collapseAll2.registerCustomShortcutSet(ActionManager.getInstance().getAction("CollapseAll").getShortcutSet(), (JComponent)this.myTree);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        PopupHandler.installPopupMenu((JComponent)this.myTree, (String)"Vcs.Log.ContextMenu", (String)CONTEXT_MENU);
        this.myChangesLoadingPane = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
        this.myChangesBrowser = new PushLogChangesBrowser(project2, false, false, this.myChangesLoadingPane);
        this.myChangesBrowser.hideViewerBorder();
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)this.myTree);
        EditSourceForDialogAction editSourceAction = new EditSourceForDialogAction(this.myChangesBrowser);
        editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this.myChangesBrowser);
        this.myChangesBrowser.addToolbarAction((AnAction)editSourceAction);
        this.setDefaultEmptyText();
        this.myDetailsPanel = new CommitDetailsPanel();
        JBScrollPane detailsScrollPane = new JBScrollPane((Component)this.myDetailsPanel, 20, 31);
        detailsScrollPane.setBorder((Border)JBUI.Borders.empty());
        detailsScrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        BorderLayoutPanel detailsContentPanel = new BorderLayoutPanel();
        detailsContentPanel.addToCenter((Component)detailsScrollPane);
        OnePixelSplitter detailsSplitter = new OnePixelSplitter(true, DETAILS_SPLITTER_PROPORTION, 0.67f);
        detailsSplitter.setFirstComponent((JComponent)this.myChangesLoadingPane);
        this.myChangesLoadingPane.add((Component)this.myChangesBrowser);
        this.myShowDetailsAction = new MyShowDetailsAction(project2, arg_0 -> PushLog.lambda$new$0((JBSplitter)detailsSplitter, detailsContentPanel, arg_0));
        this.myShowDetailsAction.setEnabled(false);
        this.myChangesBrowser.addToolbarSeparator();
        this.myChangesBrowser.addToolbarAction((AnAction)this.myShowDetailsAction);
        OnePixelSplitter splitter = new OnePixelSplitter(TREE_SPLITTER_PROPORTION, 0.5f);
        final JComponent syncStrategyPanel = this.myAllowSyncStrategy ? this.createStrategyPanel() : null;
        this.myScrollPane = new JBScrollPane((Component)this.myTree){

            public void layout() {
                super.layout();
                if (syncStrategyPanel != null) {
                    Rectangle bounds = this.getViewport().getBounds();
                    int height = bounds.height - syncStrategyPanel.getPreferredSize().height;
                    this.getViewport().setBounds(bounds.x, bounds.y, bounds.width, height);
                    syncStrategyPanel.setBounds(bounds.x, bounds.y + height, bounds.width, syncStrategyPanel.getPreferredSize().height);
                }
            }
        };
        if (syncStrategyPanel != null) {
            this.myScrollPane.setViewport((JViewport)((Object)new MyTreeViewPort((Component)this.myTree, syncStrategyPanel.getPreferredSize().height)));
        }
        this.myScrollPane.getViewport().setScrollMode(0);
        this.myScrollPane.setOpaque(false);
        if (syncStrategyPanel != null) {
            this.myScrollPane.add(syncStrategyPanel);
        }
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        splitter.setFirstComponent((JComponent)this.myScrollPane);
        splitter.setSecondComponent((JComponent)detailsSplitter);
        this.setBorder(IdeBorderFactory.createBorder((int)8));
        this.setLayout(new BorderLayout());
        this.add((Component)splitter, "Center");
        this.myTree.setRowHeight(0);
    }

    public void dispose() {
        this.myChangesBrowser.shutdown();
    }

    public void highlightNodeOrFirst(@Nullable RepositoryNode repositoryNode, boolean shouldScrollTo) {
        TreePath selectionPath = repositoryNode != null ? TreeUtil.getPathFromRoot((TreeNode)((Object)repositoryNode)) : TreeUtil.getFirstNodePath((JTree)this.myTree);
        this.myTree.setSelectionPath(selectionPath);
        if (shouldScrollTo) {
            this.myTree.scrollPathToVisible(selectionPath);
        }
    }

    private void restoreSelection(@Nullable DefaultMutableTreeNode node) {
        if (node != null) {
            TreeUtil.selectNode((JTree)this.myTree, (TreeNode)node);
        }
    }

    private JComponent createStrategyPanel() {
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBackground(RenderingUtil.getBackground((JTree)this.myTree));
        LinkLabel linkLabel = new LinkLabel(DvcsBundle.message("push.edit.all.targets", new Object[0]), null);
        linkLabel.setBorder(JBUI.Borders.empty((int)2));
        linkLabel.setListener((aSource, aLinkData) -> {
            if (linkLabel.isEnabled()) {
                this.startSyncEditing();
            }
        }, null);
        this.myTree.addPropertyChangeListener("tree.edit.mode", evt -> {
            Boolean editMode = (Boolean)evt.getNewValue();
            linkLabel.setEnabled(editMode == false);
            linkLabel.setPaintUnderline(editMode == false);
            linkLabel.repaint();
        });
        labelPanel.add((Component)linkLabel, "East");
        return labelPanel;
    }

    private void startSyncEditing() {
        this.mySyncStrategy = true;
        DefaultMutableTreeNode nodeToEdit = this.getFirstNodeToEdit();
        if (nodeToEdit != null) {
            this.myTree.startEditingAtPath(TreeUtil.getPathFromRoot((TreeNode)nodeToEdit));
        }
    }

    @NotNull
    static List<Change> collectAllChanges(@NotNull List<? extends CommitNode> commitNodes) {
        if (commitNodes == null) {
            PushLog.$$$reportNull$$$0(3);
        }
        List<Change> list = CommittedChangesTreeBrowser.zipChanges(PushLog.collectChanges(commitNodes));
        if (list == null) {
            PushLog.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static List<CommitNode> collectSelectedCommitNodes(@NotNull List<DefaultMutableTreeNode> selectedNodes) {
        if (selectedNodes == null) {
            PushLog.$$$reportNull$$$0(5);
        }
        List nodes = StreamEx.of(selectedNodes).select(RepositoryNode.class).toFlatList(node -> PushLog.getChildNodesByType((DefaultMutableTreeNode)((Object)node), CommitNode.class, true));
        nodes.addAll(((StreamEx)StreamEx.of(selectedNodes).select(CommitNode.class).filter(node -> !nodes.contains(node))).toList());
        List list = nodes;
        if (list == null) {
            PushLog.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<Change> collectChanges(@NotNull List<? extends CommitNode> commitNodes) {
        if (commitNodes == null) {
            PushLog.$$$reportNull$$$0(7);
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        for (CommitNode commitNode : commitNodes) {
            changes.addAll(commitNode.getUserObject().getChanges());
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            PushLog.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static <T> List<T> getChildNodesByType(@NotNull DefaultMutableTreeNode node, Class<T> type2, boolean reverseOrder) {
        if (node == null) {
            PushLog.$$$reportNull$$$0(9);
        }
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        if (node.getChildCount() < 1) {
            ArrayList<DefaultMutableTreeNode> arrayList = nodes;
            if (arrayList == null) {
                PushLog.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getFirstChild();
        while (childNode != null) {
            if (type2.isInstance(childNode)) {
                DefaultMutableTreeNode nodeT = childNode;
                if (reverseOrder) {
                    nodes.add(0, nodeT);
                } else {
                    nodes.add(nodeT);
                }
            }
            childNode = (DefaultMutableTreeNode)node.getChildAfter(childNode);
        }
        ArrayList<DefaultMutableTreeNode> arrayList = nodes;
        if (arrayList == null) {
            PushLog.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static List<Integer> getSortedRows(int @NotNull [] rows) {
        if (rows == null) {
            PushLog.$$$reportNull$$$0(12);
        }
        ArrayList<Integer> sorted = new ArrayList<Integer>();
        for (int row2 : rows) {
            sorted.add(row2);
        }
        sorted.sort(Collections.reverseOrder());
        ArrayList<Integer> arrayList = sorted;
        if (arrayList == null) {
            PushLog.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public void setBusyLoading(boolean paintBusy) {
        this.myTree.setPaintBusy(paintBusy);
    }

    private void onSelectionChanges() {
        List<CommitNode> commitNodes = this.getSelectedCommitNodes();
        this.updateChangesView(commitNodes);
        this.updateDetailsPanel(commitNodes);
    }

    private void updateChangesView(@NotNull List<? extends CommitNode> commitNodes) {
        if (commitNodes == null) {
            PushLog.$$$reportNull$$$0(14);
        }
        if (!commitNodes.isEmpty()) {
            this.myChangesBrowser.getViewer().setEmptyText(DvcsBundle.message("push.no.differences", new Object[0]));
        } else {
            this.setDefaultEmptyText();
        }
        this.myChangesBrowser.setCommitsToDisplay(commitNodes);
    }

    private void updateDetailsPanel(@NotNull List<? extends CommitNode> commitNodes) {
        if (commitNodes == null) {
            PushLog.$$$reportNull$$$0(15);
        }
        if (commitNodes.size() == 1 && this.getSelectedTreeNodes().stream().noneMatch(it -> it instanceof RepositoryNode)) {
            VcsFullCommitDetails commitDetails = commitNodes.get(0).getUserObject();
            CommitPresentationUtil.CommitPresentation presentation2 = CommitPresentationUtil.buildPresentation(this.myProject, commitDetails, new HashSet());
            this.myDetailsPanel.setCommit(presentation2);
            this.myShowDetailsAction.setEnabled(true);
        } else {
            this.myShowDetailsAction.setEnabled(false);
        }
    }

    private void setDefaultEmptyText() {
        this.myChangesBrowser.getViewer().setEmptyText(DvcsBundle.message("push.no.commits.selected", new Object[0]));
    }

    @Nullable
    public Object getData(@NotNull String id) {
        if (id == null) {
            PushLog.$$$reportNull$$$0(16);
        }
        if (VcsDataKeys.CHANGES.is(id)) {
            List<CommitNode> commitNodes = this.getSelectedCommitNodes();
            return PushLog.collectAllChanges(commitNodes).toArray(Change.EMPTY_CHANGE_ARRAY);
        }
        if (VcsDataKeys.VCS_REVISION_NUMBERS.is(id)) {
            List<CommitNode> commitNodes = this.getSelectedCommitNodes();
            return ContainerUtil.map2Array(commitNodes, VcsRevisionNumber.class, commitNode -> {
                Hash hash2 = (Hash)commitNode.getUserObject().getId();
                return new TextRevisionNumber(hash2.asString(), hash2.toShortString());
            });
        }
        if (VcsDataKeys.VCS_COMMIT_SUBJECTS.is(id)) {
            List<CommitNode> commitNodes = this.getSelectedCommitNodes();
            return ContainerUtil.map2Array(commitNodes, String.class, commitNode -> commitNode.getUserObject().getSubject());
        }
        return null;
    }

    @NotNull
    private List<CommitNode> getSelectedCommitNodes() {
        List<DefaultMutableTreeNode> selectedNodes = this.getSelectedTreeNodes();
        return selectedNodes.isEmpty() ? Collections.emptyList() : PushLog.collectSelectedCommitNodes(selectedNodes);
    }

    @NotNull
    private List<DefaultMutableTreeNode> getSelectedTreeNodes() {
        int[] rows = this.myTree.getSelectionRows();
        List<DefaultMutableTreeNode> list = rows != null && rows.length != 0 ? this.getNodesForRows(PushLog.getSortedRows(rows)) : ContainerUtil.emptyList();
        if (list == null) {
            PushLog.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private List<DefaultMutableTreeNode> getNodesForRows(@NotNull List<Integer> rows) {
        if (rows == null) {
            PushLog.$$$reportNull$$$0(18);
        }
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        for (Integer row2 : rows) {
            TreePath path2 = this.myTree.getPathForRow(row2.intValue());
            Object pathComponent = path2 == null ? null : path2.getLastPathComponent();
            if (!(pathComponent instanceof DefaultMutableTreeNode)) continue;
            nodes.add((DefaultMutableTreeNode)pathComponent);
        }
        ArrayList<DefaultMutableTreeNode> arrayList = nodes;
        if (arrayList == null) {
            PushLog.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyCode() == 10 && this.myTree.isEditing() && e.getModifiersEx() == 0 && pressed) {
            this.myTree.stopEditing();
            return true;
        }
        if (this.myAllowSyncStrategy && e.getKeyCode() == 113 && e.getModifiersEx() == 512 && pressed) {
            this.startSyncEditing();
            return true;
        }
        if (CheckboxTreeHelper.isToggleEvent((KeyEvent)e, (JComponent)this.myTree) && pressed) {
            this.toggleRepositoriesFromCommits();
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    private void toggleRepositoriesFromCommits() {
        LinkedHashSet checkedNodes = (LinkedHashSet)((StreamEx)StreamEx.of(this.getSelectedTreeNodes()).map(n -> n instanceof CommitNode ? n.getParent() : n).select(CheckedTreeNode.class).filter(CheckedTreeNode::isEnabled)).toCollection(LinkedHashSet::new);
        if (checkedNodes.isEmpty()) {
            return;
        }
        boolean newState = !((CheckedTreeNode)checkedNodes.iterator().next()).isChecked();
        checkedNodes.forEach(n -> this.myTree.setNodeState(n, newState));
    }

    @Nullable
    private DefaultMutableTreeNode getFirstNodeToEdit() {
        RepositoryNode selectedNode;
        Object object = this.myTree.getLastSelectedPathComponent();
        if (object instanceof RepositoryNode && (selectedNode = (RepositoryNode)object).isEditableNow()) {
            return selectedNode;
        }
        List<RepositoryNode> repositoryNodes = PushLog.getChildNodesByType((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), RepositoryNode.class, false);
        RepositoryNode editableNode = (RepositoryNode)ContainerUtil.find(repositoryNodes, repositoryNode -> repositoryNode.isEditableNow());
        if (editableNode != null) {
            TreeUtil.selectNode((JTree)this.myTree, (TreeNode)((Object)editableNode));
        }
        return editableNode;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @NotNull
    public CheckboxTree getTree() {
        CheckboxTree checkboxTree = this.myTree;
        if (checkboxTree == null) {
            PushLog.$$$reportNull$$$0(20);
        }
        return checkboxTree;
    }

    public void selectIfNothingSelected(@NotNull TreeNode node) {
        if (node == null) {
            PushLog.$$$reportNull$$$0(21);
        }
        if (this.myTree.isSelectionEmpty()) {
            this.myTree.setSelectionPath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
    }

    public void setChildren(@NotNull DefaultMutableTreeNode parentNode, @NotNull Collection<? extends DefaultMutableTreeNode> childrenNodes) {
        if (parentNode == null) {
            PushLog.$$$reportNull$$$0(22);
        }
        if (childrenNodes == null) {
            PushLog.$$$reportNull$$$0(23);
        }
        parentNode.removeAllChildren();
        for (DefaultMutableTreeNode defaultMutableTreeNode : childrenNodes) {
            parentNode.add(defaultMutableTreeNode);
        }
        if (!this.myTree.isEditing()) {
            this.refreshNode(parentNode);
            TreePath path2 = TreeUtil.getPathFromRoot((TreeNode)parentNode);
            if (this.myTree.getSelectionModel().isPathSelected(path2)) {
                this.onSelectionChanges();
            }
        } else {
            this.myShouldRepaint = true;
        }
    }

    private void refreshNode(@NotNull DefaultMutableTreeNode parentNode) {
        if (parentNode == null) {
            PushLog.$$$reportNull$$$0(24);
        }
        DefaultTreeModel model2 = (DefaultTreeModel)this.myTree.getModel();
        model2.nodeStructureChanged(parentNode);
        this.autoExpandChecked(parentNode);
        this.myShouldRepaint = false;
    }

    private void autoExpandChecked(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            PushLog.$$$reportNull$$$0(25);
        }
        if (node.getChildCount() <= 0) {
            return;
        }
        if (node instanceof RepositoryNode) {
            this.expandIfChecked((RepositoryNode)((Object)node));
            return;
        }
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getFirstChild();
        while (childNode != null) {
            if (!(childNode instanceof RepositoryNode)) {
                return;
            }
            this.expandIfChecked((RepositoryNode)((Object)childNode));
            childNode = (DefaultMutableTreeNode)node.getChildAfter(childNode);
        }
    }

    private void expandIfChecked(@NotNull RepositoryNode node) {
        if (node == null) {
            PushLog.$$$reportNull$$$0(26);
        }
        if (node.isChecked()) {
            TreePath path2 = TreeUtil.getPathFromRoot((TreeNode)((Object)node));
            this.myTree.expandPath(path2);
        }
    }

    private void setSyncText(@Nls String value2) {
        this.mySyncRenderedText = value2;
    }

    public void fireEditorUpdated(@NotNull @Nls String currentText) {
        if (currentText == null) {
            PushLog.$$$reportNull$$$0(27);
        }
        if (this.mySyncStrategy) {
            List<RepositoryNode> repositoryNodes = PushLog.getChildNodesByType((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), RepositoryNode.class, false);
            for (RepositoryNode node : repositoryNodes) {
                if (!node.isEditableNow()) continue;
                node.forceUpdateUiModelWithTypedText(currentText);
            }
            this.setSyncText(currentText);
            this.myTree.repaint();
        }
    }

    private void resetEditSync() {
        if (this.mySyncStrategy) {
            this.mySyncStrategy = false;
            this.mySyncRenderedText = null;
        }
    }

    private static /* synthetic */ void lambda$new$0(JBSplitter detailsSplitter, BorderLayoutPanel detailsContentPanel, Boolean state) {
        detailsSplitter.setSecondComponent((JComponent)(state != false ? detailsContentPanel : null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8, 10, 11, 13, 17, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 3: 
            case 7: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitNodes";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/ui/PushLog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
            case 9: 
            case 21: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenNodes";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/ui/PushLog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllChanges";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSelectedCommitNodes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChanges";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildNodesByType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedRows";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTreeNodes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesForRows";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectAllChanges";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedCommitNodes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectChanges";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getChildNodesByType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSortedRows";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateChangesView";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateDetailsPanel";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNodesForRows";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "selectIfNothingSelected";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "refreshNode";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "autoExpandChecked";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "expandIfChecked";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fireEditorUpdated";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 6, 8, 10, 11, 13, 17, 19, 20 -> new IllegalStateException(string2);
        };
    }

    private class MyTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeRenderer(JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (!(value2 instanceof DefaultMutableTreeNode)) {
                return;
            }
            this.myCheckbox.setBorder(null);
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            renderer.setIpad((Insets)JBInsets.emptyInsets());
            if (value2 instanceof RepositoryNode) {
                RepositoryNode valueNode = (RepositoryNode)value2;
                boolean isCheckboxVisible = valueNode.isCheckboxVisible();
                this.myCheckbox.setVisible(isCheckboxVisible);
                if (!isCheckboxVisible) {
                    renderer.setIpad((Insets)JBUI.insets((int)0, (int)10));
                }
                if (valueNode.isChecked() && valueNode.isLoading()) {
                    this.myCheckbox.setState(ThreeStateCheckBox.State.DONT_CARE);
                } else {
                    this.myCheckbox.setSelected(valueNode.isChecked());
                }
            }
            Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
            if (value2 instanceof CustomRenderedTreeNode) {
                if (tree2.isEditing() && PushLog.this.mySyncStrategy && value2 instanceof RepositoryNode) {
                    ((RepositoryNode)value2).render(renderer, PushLog.this.mySyncRenderedText);
                } else {
                    ((CustomRenderedTreeNode)value2).render(renderer);
                }
            } else {
                renderer.append(userObject == null ? "" : userObject.toString());
            }
        }
    }

    private class MyTreeUi
    extends WideSelectionTreeUI {
        private final ComponentListener myTreeSizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MyTreeUi.this.updateSizes();
            }
        };
        private final AncestorListener myTreeAncestorListener = new AncestorListenerAdapter(){

            public void ancestorMoved(AncestorEvent event) {
                super.ancestorMoved(event);
                MyTreeUi.this.updateSizes();
            }
        };

        private MyTreeUi() {
        }

        private void updateSizes() {
            this.treeState.invalidateSizes();
            this.tree.repaint();
        }

        protected void installListeners() {
            super.installListeners();
            this.tree.addComponentListener(this.myTreeSizeListener);
            this.tree.addAncestorListener(this.myTreeAncestorListener);
        }

        protected void uninstallListeners() {
            this.tree.removeComponentListener(this.myTreeSizeListener);
            this.tree.removeAncestorListener(this.myTreeAncestorListener);
            super.uninstallListeners();
        }

        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            return new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object value2, int row2, int depth, boolean expanded, Rectangle size) {
                    Rectangle dimensions = super.getNodeDimensions(value2, row2, depth, expanded, size);
                    dimensions.width = Math.max(PushLog.this.myScrollPane != null ? PushLog.this.myScrollPane.getViewport().getWidth() - this.getRowX(row2, depth) : PushLog.this.myTree.getMinimumSize().width, dimensions.width);
                    return dimensions;
                }
            };
        }
    }

    private class MyTreeCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private RepositoryWithBranchPanel<?> myValue;

        private MyTreeCellEditor() {
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree2, Object value2, boolean isSelected, boolean expanded, boolean leaf, int row2) {
            RepositoryWithBranchPanel panel2;
            this.myValue = panel2 = (RepositoryWithBranchPanel)((Object)((DefaultMutableTreeNode)value2).getUserObject());
            PushLog.this.myTree.firePropertyChange("tree.edit.mode", false, true);
            return panel2.getTreeCellEditorComponent(tree2, value2, isSelected, expanded, leaf, row2, true);
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)anEvent;
                TreePath path2 = PushLog.this.myTree.getClosestPathForLocation(me.getX(), me.getY());
                int row2 = PushLog.this.myTree.getRowForLocation(me.getX(), me.getY());
                PushLog.this.myTree.getCellRenderer().getTreeCellRendererComponent((JTree)PushLog.this.myTree, path2.getLastPathComponent(), false, false, true, row2, true);
                Object tag = me.getClickCount() >= 1 ? PushLogTreeUtil.getTagAtForRenderer(PushLog.this.myTreeCellRenderer, me) : null;
                return tag instanceof VcsEditableComponent;
            }
            TreePath treePath = PushLog.this.myTree.getAnchorSelectionPath();
            if (treePath == null) {
                return true;
            }
            Object treeNode = treePath.getLastPathComponent();
            return treeNode instanceof EditableTreeNode && ((EditableTreeNode)treeNode).isEditableNow();
        }

        @Override
        public Object getCellEditorValue() {
            return this.myValue;
        }
    }

    private static class MyShowDetailsAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        private final PushSettings mySettings;
        @NotNull
        private final Consumer<? super Boolean> myOnUpdate;

        MyShowDetailsAction(@NotNull Project project2, @NotNull Consumer<? super Boolean> onUpdate) {
            if (project2 == null) {
                MyShowDetailsAction.$$$reportNull$$$0(0);
            }
            if (onUpdate == null) {
                MyShowDetailsAction.$$$reportNull$$$0(1);
            }
            super(DvcsBundle.message("push.show.details", new Object[0]), AllIcons.Actions.PreviewDetailsVertically);
            this.mySettings = (PushSettings)project2.getService(PushSettings.class);
            this.myOnUpdate = onUpdate;
        }

        private boolean getValue() {
            return this.mySettings.getShowDetailsInPushDialog();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyShowDetailsAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.getValue();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySettings.setShowDetailsInPushDialog(state);
            this.myOnUpdate.accept((Boolean)state);
        }

        public void setEnabled(boolean enabled) {
            this.myOnUpdate.accept((Boolean)(enabled && this.getValue() ? 1 : 0));
            super.setEnabled(enabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onUpdate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/ui/PushLog$MyShowDetailsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/ui/PushLog$MyShowDetailsAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static class MyTreeViewPort
    extends JBViewport {
        final int myHeightToReduce;

        MyTreeViewPort(@Nullable Component view, int heightToReduce) {
            this.setView(view);
            this.myHeightToReduce = heightToReduce;
        }

        public Dimension getExtentSize() {
            Dimension defaultSize = super.getExtentSize();
            return new Dimension(defaultSize.width, defaultSize.height - this.myHeightToReduce);
        }
    }
}

