/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.URLUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClonePathProvider {
    private static final ExtensionPointName<ClonePathProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.clonePathProvider");

    @NotNull
    public static String defaultParentDirectoryPath(@NotNull Project project2, @NotNull DvcsRememberedInputs rememberedInputs) {
        if (project2 == null) {
            ClonePathProvider.$$$reportNull$$$0(0);
        }
        if (rememberedInputs == null) {
            ClonePathProvider.$$$reportNull$$$0(1);
        }
        for (ClonePathProvider provider : EP_NAME.getExtensionList()) {
            String directoryPath = provider.getParentDirectoryPath(project2, rememberedInputs);
            if (!StringUtil.isNotEmpty((String)directoryPath)) continue;
            String string2 = directoryPath;
            if (string2 == null) {
                ClonePathProvider.$$$reportNull$$$0(2);
            }
            return string2;
        }
        String parentDirectory = rememberedInputs.getCloneParentDir();
        String string3 = StringUtil.isEmptyOrSpaces((String)parentDirectory) ? ProjectUtil.getBaseDir() : parentDirectory;
        if (string3 == null) {
            ClonePathProvider.$$$reportNull$$$0(3);
        }
        return string3;
    }

    @NotNull
    public static String relativeDirectoryPathForVcsUrl(@NotNull Project project2, @NotNull String vcsUrl) {
        String string2;
        if (project2 == null) {
            ClonePathProvider.$$$reportNull$$$0(4);
        }
        if (vcsUrl == null) {
            ClonePathProvider.$$$reportNull$$$0(5);
        }
        for (ClonePathProvider provider : EP_NAME.getExtensionList()) {
            String directoryPath = provider.getRelativeDirectoryPathForVcsUrl(project2, vcsUrl);
            if (!StringUtil.isNotEmpty((String)directoryPath)) continue;
            String string3 = directoryPath;
            if (string3 == null) {
                ClonePathProvider.$$$reportNull$$$0(6);
            }
            return string3;
        }
        String encoded = PathUtil.getFileName((String)vcsUrl);
        try {
            string2 = URLUtil.decode((String)encoded);
        }
        catch (Exception e) {
            String string4 = encoded;
            if (string4 == null) {
                ClonePathProvider.$$$reportNull$$$0(8);
            }
            return string4;
        }
        if (string2 == null) {
            ClonePathProvider.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Nullable
    public abstract String getParentDirectoryPath(@NotNull Project var1, @NotNull DvcsRememberedInputs var2);

    @Nullable
    public abstract String getRelativeDirectoryPathForVcsUrl(@NotNull Project var1, @NotNull String var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rememberedInputs";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/repo/ClonePathProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/repo/ClonePathProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultParentDirectoryPath";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "relativeDirectoryPathForVcsUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "defaultParentDirectoryPath";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "relativeDirectoryPathForVcsUrl";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 6, 7, 8 -> new IllegalStateException(string2);
        };
    }
}

