/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.ui.UIUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsStatusWidget<T extends Repository>
extends EditorBasedWidget
implements StatusBarWidget.MultipleTextValuesPresentation,
StatusBarWidget.Multiframe {
    protected static final Logger LOG = Logger.getInstance(DvcsStatusWidget.class);
    @NotNull
    private final String myVcsName;
    @Nullable
    @Nls
    private volatile String myText;
    @Nullable
    private volatile @NlsContexts.Tooltip String myTooltip;
    @Nullable
    private volatile Icon myIcon;
    @Nullable
    private volatile T myRepository;
    private final Alarm myUpdateBackgroundAlarm;

    protected DvcsStatusWidget(@NotNull Project project2, @NotNull @Nls String vcsName) {
        if (project2 == null) {
            DvcsStatusWidget.$$$reportNull$$$0(0);
        }
        if (vcsName == null) {
            DvcsStatusWidget.$$$reportNull$$$0(1);
        }
        super(project2);
        this.myUpdateBackgroundAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myVcsName = vcsName;
        this.myConnection.subscribe(VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED, (Object)new VcsRepositoryMappingListener(){

            @Override
            public void mappingChanged() {
                LOG.debug("repository mappings changed");
                DvcsStatusWidget.this.updateLater();
            }
        });
        this.myConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                LOG.debug("selection changed");
                DvcsStatusWidget.this.updateLater();
            }

            public void fileOpened(@NotNull FileEditorManager source2, @NotNull VirtualFile file) {
                if (source2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(2);
                }
                LOG.debug("file opened");
                DvcsStatusWidget.this.updateLater();
            }

            public void fileClosed(@NotNull FileEditorManager source2, @NotNull VirtualFile file) {
                if (source2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(4);
                }
                LOG.debug("file closed");
                DvcsStatusWidget.this.updateLater();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/dvcs/ui/DvcsStatusWidget$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @RequiresBackgroundThread
    @Nullable
    protected abstract T guessCurrentRepository(@NotNull Project var1, @Nullable VirtualFile var2);

    @Nls
    @NotNull
    protected abstract String getFullBranchName(@NotNull T var1);

    @Nullable
    protected Icon getIcon(@NotNull T repository) {
        if (repository == null) {
            DvcsStatusWidget.$$$reportNull$$$0(2);
        }
        if (repository.getState() != Repository.State.NORMAL) {
            return AllIcons.General.Warning;
        }
        return AllIcons.Vcs.Branch;
    }

    protected abstract boolean isMultiRoot(@NotNull Project var1);

    @Nullable
    protected JBPopup getWidgetPopup(@NotNull Project project2, @NotNull T repository) {
        if (project2 == null) {
            DvcsStatusWidget.$$$reportNull$$$0(3);
        }
        if (repository == null) {
            DvcsStatusWidget.$$$reportNull$$$0(4);
        }
        return null;
    }

    protected abstract void rememberRecentRoot(@NotNull String var1);

    public void install(@NotNull StatusBar statusBar2) {
        if (statusBar2 == null) {
            DvcsStatusWidget.$$$reportNull$$$0(5);
        }
        super.install(statusBar2);
        this.updateLater();
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return this;
    }

    @RequiresEdt
    @Nullable
    public String getSelectedValue() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return StringUtil.defaultIfEmpty((String)this.myText, (String)"");
    }

    @Nullable
    public String getTooltipText() {
        return this.myTooltip;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public JBPopup getPopup() {
        if (this.isDisposed()) {
            return null;
        }
        T repository = this.myRepository;
        if (repository == null) {
            return null;
        }
        return this.getWidgetPopup(this.getProject(), repository);
    }

    private void clearStatus() {
        this.myText = null;
        this.myTooltip = null;
        this.myIcon = null;
        this.myRepository = null;
    }

    protected void updateLater() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.isDisposed()) {
                return;
            }
            VirtualFile selectedFile = DvcsUtil.getSelectedFile(this.getProject());
            this.myUpdateBackgroundAlarm.cancelAllRequests();
            this.myUpdateBackgroundAlarm.addRequest(() -> {
                if (this.isDisposed()) {
                    this.clearStatus();
                    return;
                }
                if (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> this.updateOnBackground(selectedFile))) {
                    this.updateLater();
                }
            }, 10);
        });
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    private void updateOnBackground(VirtualFile virtualFile) {
        T repository;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try {
            void selectedFile;
            Project project2 = this.getProject();
            repository = this.guessCurrentRepository(project2, (VirtualFile)selectedFile);
            if (repository == null) {
                this.clearStatus();
                return;
            }
        }
        catch (ProcessCanceledException e) {
            return;
        }
        catch (Throwable t) {
            LOG.error(t);
            this.clearStatus();
            return;
        }
        this.myText = DvcsBranchUtil.shortenBranchName(this.getFullBranchName(repository));
        this.myTooltip = this.getToolTip(repository);
        this.myIcon = this.getIcon(repository);
        this.myRepository = repository;
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
        this.rememberRecentRoot(repository.getRoot().getPath());
    }

    @NlsContexts.Tooltip
    @Nullable
    protected String getToolTip(@Nullable T repository) {
        if (repository == null) {
            return null;
        }
        Object message2 = DvcsBundle.message("tooltip.branch.widget.vcs.branch.name.text", this.myVcsName, this.getFullBranchName(repository));
        if (this.isMultiRoot(repository.getProject())) {
            message2 = (String)message2 + "\n";
            message2 = (String)message2 + DvcsBundle.message("tooltip.branch.widget.root.name.text", repository.getRoot().getName());
        }
        return message2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/ui/DvcsStatusWidget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getWidgetPopup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

