/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.inspectopedia.extractor.data;

import com.intellij.inspectopedia.extractor.data.OptionsPanelInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;

public class Inspection
implements Comparable<Inspection> {
    private static final Safelist WHITELIST = new Safelist().addTags(new String[]{"p", "br", "li", "ul", "ol", "b", "i", "code", "a"}).addAttributes("a", new String[]{"href"});
    public String id;
    public String name = "";
    public String severity = "WARNING";
    public List<String> path = new ArrayList<String>();
    public String language = "";
    public boolean appliesToDialects = true;
    public boolean isCleanup = false;
    public boolean isEnabledDefault = true;
    public String briefDescription = "";
    public String extendedDescription = "";
    public boolean hasOptionsPanel = false;
    public List<OptionsPanelInfo> options = null;

    public Inspection(String id, String name, String severity, String language, String briefDescription, String extendedDescription, List<String> path2, boolean appliesToDialects, boolean partOfCodeCleanup, boolean enabledByDefault, List<OptionsPanelInfo> options) {
        this.id = id;
        this.name = name;
        this.severity = severity;
        this.language = language;
        this.briefDescription = briefDescription;
        this.extendedDescription = extendedDescription;
        this.path = path2;
        this.appliesToDialects = appliesToDialects;
        this.isCleanup = partOfCodeCleanup;
        this.isEnabledDefault = enabledByDefault;
        this.hasOptionsPanel = options != null;
        this.options = options;
    }

    public Inspection() {
    }

    public boolean isAppliesToDialects() {
        return this.appliesToDialects;
    }

    public boolean isCleanup() {
        return this.isCleanup;
    }

    public boolean isEnabledDefault() {
        return this.isEnabledDefault;
    }

    public boolean isHasOptionsPanel() {
        return this.hasOptionsPanel;
    }

    @NotNull
    String cleanHtml(@NotNull String src) {
        if (src == null) {
            Inspection.$$$reportNull$$$0(0);
        }
        Document doc = Jsoup.parse((String)Jsoup.clean((String)src, (Safelist)WHITELIST));
        doc.select("ul").forEach(e -> e.tagName("list"));
        doc.select("ol").forEach(e -> {
            e.tagName("list");
            e.attr("type", "decimal");
        });
        doc.select("code").forEach(element -> element.text(element.text()));
        doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        String string2 = doc.body().html();
        if (string2 == null) {
            Inspection.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getExtendedDescription() {
        return this.extendedDescription;
    }

    public String getBriefDescription() {
        return this.briefDescription;
    }

    public List<String> getPath() {
        return List.copyOf(this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Inspection)) {
            return false;
        }
        Inspection that = (Inspection)o;
        return this.appliesToDialects == that.appliesToDialects && this.isCleanup == that.isCleanup && this.isEnabledDefault == that.isEnabledDefault && this.hasOptionsPanel == that.hasOptionsPanel && this.id.equals(that.id) && this.name.equals(that.name) && this.severity.equals(that.severity) && this.path.equals(that.path) && this.language.equals(that.language) && Objects.equals(this.briefDescription, that.briefDescription) && Objects.equals(this.extendedDescription, that.extendedDescription) && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.severity, this.path, this.language, this.appliesToDialects, this.isCleanup, this.isEnabledDefault, this.briefDescription, this.extendedDescription, this.hasOptionsPanel, this.options);
    }

    @Override
    public int compareTo(@NotNull Inspection o) {
        if (o == null) {
            Inspection.$$$reportNull$$$0(2);
        }
        return this.name.compareTo(o.name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/inspectopedia/extractor/data/Inspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/inspectopedia/extractor/data/Inspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cleanHtml";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

