/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.pointer;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPointerPosition {
    private final List<Step> steps;

    public JsonPointerPosition() {
        this.steps = new ArrayList<Step>();
    }

    private JsonPointerPosition(List<Step> steps) {
        this.steps = steps;
    }

    public static JsonPointerPosition createSingleProperty(String property2) {
        return new JsonPointerPosition(ContainerUtil.createMaybeSingletonList((Object)Step.createPropertyStep(property2)));
    }

    public static JsonPointerPosition parsePointer(@NotNull String pointer) {
        if (pointer == null) {
            JsonPointerPosition.$$$reportNull$$$0(0);
        }
        List<String> chain = JsonPointerUtil.split(JsonPointerUtil.normalizeSlashes(JsonPointerUtil.normalizeId(pointer)));
        ArrayList<Step> steps = new ArrayList<Step>(chain.size());
        for (String s : chain) {
            try {
                steps.add(Step.createArrayElementStep(Integer.parseInt(s)));
            }
            catch (NumberFormatException e) {
                steps.add(Step.createPropertyStep(JsonPointerUtil.unescapeJsonPointerPart(s)));
            }
        }
        return new JsonPointerPosition(steps);
    }

    List<Step> getSteps() {
        return this.steps;
    }

    public void addPrecedingStep(int value2) {
        this.steps.add(0, Step.createArrayElementStep(value2));
    }

    public void addFollowingStep(int value2) {
        this.steps.add(Step.createArrayElementStep(value2));
    }

    public void addPrecedingStep(String value2) {
        this.steps.add(0, Step.createPropertyStep(value2));
    }

    public void addFollowingStep(String value2) {
        this.steps.add(Step.createPropertyStep(value2));
    }

    public void replaceStep(int pos, int value2) {
        this.steps.set(pos, Step.createArrayElementStep(value2));
    }

    public void replaceStep(int pos, String value2) {
        this.steps.set(pos, Step.createPropertyStep(value2));
    }

    public boolean isEmpty() {
        return this.steps.isEmpty();
    }

    public boolean isArray(int pos) {
        return this.checkPosInRange(pos) && this.steps.get(pos).isFromArray();
    }

    public boolean isObject(int pos) {
        return this.checkPosInRange(pos) && this.steps.get(pos).isFromObject();
    }

    @Nullable
    public JsonPointerPosition skip(int count) {
        return this.checkPosInRangeIncl(count) ? new JsonPointerPosition(this.steps.subList(count, this.steps.size())) : null;
    }

    @Nullable
    public JsonPointerPosition trimTail(int count) {
        return this.checkPosInRangeIncl(count) ? new JsonPointerPosition(this.steps.subList(0, this.steps.size() - count)) : null;
    }

    @Nullable
    public String getLastName() {
        Step last = (Step)ContainerUtil.getLastItem(this.steps);
        return last == null ? null : last.getName();
    }

    @Nullable
    public String getFirstName() {
        Step last = (Step)ContainerUtil.getFirstItem(this.steps);
        return last == null ? null : last.getName();
    }

    public int getFirstIndex() {
        Step last = (Step)ContainerUtil.getFirstItem(this.steps);
        return last == null ? -1 : last.getIdx();
    }

    public int size() {
        return this.steps.size();
    }

    public void updateFrom(JsonPointerPosition from) {
        this.steps.clear();
        this.steps.addAll(from.steps);
    }

    public String toJsonPointer() {
        return "/" + this.steps.stream().map(step2 -> JsonPointerUtil.escapeForJsonPointer(step2.myName == null ? String.valueOf(step2.myIdx) : step2.myName)).collect(Collectors.joining("/"));
    }

    public String toString() {
        return this.steps.stream().map(Object::toString).collect(Collectors.joining("->", "steps: <", ">"));
    }

    private boolean checkPosInRange(int pos) {
        return this.steps.size() > pos;
    }

    private boolean checkPosInRangeIncl(int pos) {
        return this.steps.size() >= pos;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/json/pointer/JsonPointerPosition", "parsePointer"));
    }

    static final class Step {
        @Nullable
        private final String myName;
        private final int myIdx;

        private Step(@Nullable String name, int idx) {
            this.myName = name;
            this.myIdx = idx;
        }

        public static Step createPropertyStep(@NotNull String name) {
            if (name == null) {
                Step.$$$reportNull$$$0(0);
            }
            return new Step(name, -1);
        }

        public static Step createArrayElementStep(int idx) {
            assert (idx >= 0);
            return new Step(null, idx);
        }

        public boolean isFromObject() {
            return this.myName != null;
        }

        public boolean isFromArray() {
            return this.myName == null;
        }

        @Nullable
        public String getName() {
            return this.myName;
        }

        public int getIdx() {
            return this.myIdx;
        }

        public String toString() {
            String format = "?%s";
            if (this.myName != null) {
                format = "{%s}";
            }
            if (this.myIdx >= 0) {
                format = "[%s]";
            }
            return String.format(format, this.myName != null ? this.myName : (this.myIdx >= 0 ? String.valueOf(this.myIdx) : "null"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/json/pointer/JsonPointerPosition$Step", "createPropertyStep"));
        }
    }
}

