/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J)\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\u0002\u0010\u000eJ3\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\f2\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J2\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0002J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\bJ\u0016\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/diff/impl/patch/PatchHunkUtil;", "", "()V", "createPatchFromHunk", "", "filePath", "diffHunk", "findDiffFileLineIndex", "", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "locationInDiff", "Lkotlin/Pair;", "Lcom/intellij/diff/util/Side;", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;Lkotlin/Pair;)Ljava/lang/Integer;", "findHunkLineIndex", "hunk", "Lcom/intellij/openapi/diff/impl/patch/PatchHunk;", "diffFile", "", "(Lcom/intellij/openapi/diff/impl/patch/PatchHunk;Lkotlin/Pair;Z)Ljava/lang/Integer;", "findHunkWithOffset", "getChangeOnlyRanges", "", "Lcom/intellij/diff/util/Range;", "getRange", "truncateHunkAfter", "hunkLineIndex", "truncateHunkBefore", "intellij.platform.vcs.core"})
@SourceDebugExtension(value={"SMAP\nPatchHunkUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchHunkUtil.kt\ncom/intellij/openapi/diff/impl/patch/PatchHunkUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1774#2,4:191\n*S KotlinDebug\n*F\n+ 1 PatchHunkUtil.kt\ncom/intellij/openapi/diff/impl/patch/PatchHunkUtil\n*L\n127#1:191,4\n*E\n"})
public final class PatchHunkUtil {
    @NotNull
    public static final PatchHunkUtil INSTANCE = new PatchHunkUtil();

    private PatchHunkUtil() {
    }

    @NotNull
    public final Range getRange(@NotNull PatchHunk hunk) {
        Intrinsics.checkNotNullParameter((Object)hunk, (String)"hunk");
        int end1 = hunk.getStartLineBefore();
        int end2 = hunk.getStartLineAfter();
        for (PatchLine line : hunk.getLines()) {
            switch (WhenMappings.$EnumSwitchMapping$0[line.getType().ordinal()]) {
                case 1: {
                    ++end1;
                    break;
                }
                case 2: {
                    ++end2;
                    break;
                }
                case 3: {
                    ++end1;
                    ++end2;
                }
            }
        }
        return new Range(hunk.getStartLineBefore(), end1, hunk.getStartLineAfter(), end2);
    }

    @NotNull
    public final List<Range> getChangeOnlyRanges(@NotNull PatchHunk hunk) {
        Intrinsics.checkNotNullParameter((Object)hunk, (String)"hunk");
        List ranges = new ArrayList();
        int start1 = hunk.getStartLineBefore();
        int start2 = hunk.getStartLineAfter();
        int end1 = hunk.getStartLineBefore();
        int end2 = hunk.getStartLineAfter();
        boolean changeFound = false;
        boolean newLine1 = false;
        boolean newLine2 = false;
        for (PatchLine line : hunk.getLines()) {
            switch (WhenMappings.$EnumSwitchMapping$0[line.getType().ordinal()]) {
                case 1: {
                    ++end1;
                    changeFound = true;
                    newLine1 = !line.isSuppressNewLine();
                    break;
                }
                case 2: {
                    ++end2;
                    changeFound = true;
                    newLine2 = !line.isSuppressNewLine();
                    break;
                }
                case 3: {
                    if (changeFound) {
                        ranges.add(new Range(start1, end1, start2, end2));
                        start1 = end1;
                        start2 = end2;
                    }
                    ++start1;
                    ++start2;
                    ++end1;
                    ++end2;
                    changeFound = false;
                    newLine1 = !line.isSuppressNewLine();
                    newLine2 = !line.isSuppressNewLine();
                }
            }
        }
        if (changeFound) {
            if (newLine1 != newLine2) {
                if (newLine1) {
                    ++end1;
                }
                if (newLine2) {
                    ++end2;
                }
            }
            ranges.add(new Range(start1, end1, start2, end2));
        }
        return ranges;
    }

    @Nullable
    public final Integer findHunkLineIndex(@NotNull PatchHunk hunk, @NotNull Pair<? extends Side, Integer> locationInDiff, boolean diffFile) {
        Intrinsics.checkNotNullParameter((Object)hunk, (String)"hunk");
        Intrinsics.checkNotNullParameter(locationInDiff, (String)"locationInDiff");
        Side side = (Side)locationInDiff.component1();
        int fileLineIndex = ((Number)locationInDiff.component2()).intValue();
        int sideFileLineIndex = fileLineIndex - side.select(hunk.getStartLineBefore(), hunk.getStartLineAfter());
        int sideFileLineCounter = 0;
        int hunkLineIndex = diffFile ? 1 : 0;
        Integer lastMatchedLineWithNewline = null;
        for (PatchLine line : hunk.getLines()) {
            if (line.getType() == PatchLine.Type.ADD && side == Side.RIGHT || line.getType() == PatchLine.Type.REMOVE && side == Side.LEFT || line.getType() == PatchLine.Type.CONTEXT) {
                if (sideFileLineCounter == sideFileLineIndex) {
                    return hunkLineIndex;
                }
                if (++sideFileLineCounter == sideFileLineIndex && !line.isSuppressNewLine()) {
                    lastMatchedLineWithNewline = hunkLineIndex;
                }
            }
            hunkLineIndex += diffFile && line.isSuppressNewLine() ? 2 : 1;
        }
        return lastMatchedLineWithNewline;
    }

    public static /* synthetic */ Integer findHunkLineIndex$default(PatchHunkUtil patchHunkUtil, PatchHunk patchHunk, Pair pair, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return patchHunkUtil.findHunkLineIndex(patchHunk, (Pair<? extends Side, Integer>)pair, bl);
    }

    @Nullable
    public final Integer findDiffFileLineIndex(@NotNull TextFilePatch patch, @NotNull Pair<? extends Side, Integer> locationInDiff) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Intrinsics.checkNotNullParameter(locationInDiff, (String)"locationInDiff");
        Pair<PatchHunk, Integer> pair = this.findHunkWithOffset(patch, locationInDiff);
        if (pair == null) {
            return null;
        }
        Pair<PatchHunk, Integer> pair2 = pair;
        PatchHunk hunk = (PatchHunk)pair2.component1();
        int offset = ((Number)pair2.component2()).intValue();
        Integer n = this.findHunkLineIndex(hunk, locationInDiff, true);
        if (n == null) {
            return null;
        }
        int hunkLineIndex = n;
        return offset + (hunkLineIndex - 1);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<PatchHunk, Integer> findHunkWithOffset(TextFilePatch patch, Pair<? extends Side, Integer> locationInDiff) {
        Side side = (Side)locationInDiff.component1();
        int lineIndex = ((Number)locationInDiff.component2()).intValue();
        int diffLineCounter = 0;
        for (PatchHunk hunk : patch.getHunks()) {
            int n;
            void $this$count$iv;
            ++diffLineCounter;
            Intrinsics.checkNotNullExpressionValue((Object)hunk, (String)"hunk");
            Range range = this.getRange(hunk);
            int start2 = side.select(range.start1, range.start2);
            int end = side.select(range.end1, range.end2);
            boolean bl = start2 <= lineIndex ? lineIndex <= end : false;
            if (bl) {
                return TuplesKt.to((Object)hunk, (Object)diffLineCounter);
            }
            int n2 = hunk.getLines().size();
            List<PatchLine> list = hunk.getLines();
            Intrinsics.checkNotNullExpressionValue(list, (String)"hunk.lines");
            Iterable iterable = list;
            int n3 = n2;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    PatchLine it = (PatchLine)element$iv;
                    boolean bl2 = false;
                    if (!it.isSuppressNewLine() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n4 = n;
            int hunkLinesCount = n3 + n4;
            diffLineCounter += hunkLinesCount;
        }
        return null;
    }

    @NotNull
    public final String createPatchFromHunk(@NotNull String filePath, @NotNull String diffHunk) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)diffHunk, (String)"diffHunk");
        return "--- a/" + filePath + "\n+++ b/" + filePath + "\n" + diffHunk;
    }

    @NotNull
    public final PatchHunk truncateHunkBefore(@NotNull PatchHunk hunk, int hunkLineIndex) {
        PatchHunk patchHunk;
        Intrinsics.checkNotNullParameter((Object)hunk, (String)"hunk");
        if (hunkLineIndex <= 0) {
            return hunk;
        }
        List<PatchLine> lines = hunk.getLines();
        int startLineBefore = hunk.getStartLineBefore();
        int startLineAfter = hunk.getStartLineAfter();
        block5: for (int i = 0; i < hunkLineIndex; ++i) {
            PatchLine line = lines.get(i);
            switch (WhenMappings.$EnumSwitchMapping$0[line.getType().ordinal()]) {
                case 3: {
                    ++startLineBefore;
                    ++startLineAfter;
                    continue block5;
                }
                case 2: {
                    ++startLineAfter;
                    continue block5;
                }
                case 1: {
                    ++startLineBefore;
                }
            }
        }
        List<PatchLine> truncatedLines = lines.subList(hunkLineIndex, lines.size());
        PatchHunk $this$truncateHunkBefore_u24lambda_u241 = patchHunk = new PatchHunk(startLineBefore, hunk.getEndLineBefore(), startLineAfter, hunk.getEndLineAfter());
        boolean bl = false;
        for (PatchLine line : truncatedLines) {
            $this$truncateHunkBefore_u24lambda_u241.addLine(line);
        }
        return patchHunk;
    }

    @NotNull
    public final PatchHunk truncateHunkAfter(@NotNull PatchHunk hunk, int hunkLineIndex) {
        PatchHunk patchHunk;
        Intrinsics.checkNotNullParameter((Object)hunk, (String)"hunk");
        List<PatchLine> lines = hunk.getLines();
        if (hunkLineIndex > lines.size() - 1) {
            return hunk;
        }
        int endLineBefore = hunk.getEndLineBefore();
        int endLineAfter = hunk.getEndLineAfter();
        int i = lines.size() - 1;
        if (hunkLineIndex <= i) {
            while (true) {
                PatchLine line = lines.get(i);
                switch (WhenMappings.$EnumSwitchMapping$0[line.getType().ordinal()]) {
                    case 3: {
                        --endLineBefore;
                        --endLineAfter;
                        break;
                    }
                    case 2: {
                        --endLineAfter;
                        break;
                    }
                    case 1: {
                        --endLineBefore;
                    }
                }
                if (i == hunkLineIndex) break;
                --i;
            }
        }
        List<PatchLine> truncatedLines = lines.subList(0, hunkLineIndex + 1);
        PatchHunk $this$truncateHunkAfter_u24lambda_u242 = patchHunk = new PatchHunk(hunk.getStartLineBefore(), endLineBefore, hunk.getStartLineAfter(), endLineAfter);
        boolean bl = false;
        for (PatchLine line : truncatedLines) {
            $this$truncateHunkAfter_u24lambda_u242.addLine(line);
        }
        return patchHunk;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PatchLine.Type.values().length];
            try {
                nArray[PatchLine.Type.REMOVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PatchLine.Type.ADD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PatchLine.Type.CONTEXT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

