/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.FileHolderComposite;
import com.intellij.openapi.vcs.changes.FoldersCutDownWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.SwitchedFileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UpdatingChangeListBuilder
implements ChangelistBuilder {
    private static final Logger LOG = Logger.getInstance(UpdatingChangeListBuilder.class);
    private final ChangeListWorker.ChangeListUpdater myChangeListUpdater;
    private final FileHolderComposite myComposite;
    private final Supplier<Boolean> myDisposedGetter;
    private final ProjectLevelVcsManager myVcsManager;
    private VcsDirtyScope myScope;
    private FoldersCutDownWorker myFoldersCutDownWorker;
    private Factory<JComponent> myAdditionalInfo;

    UpdatingChangeListBuilder(ChangeListWorker.ChangeListUpdater changeListUpdater, FileHolderComposite composite, Supplier<Boolean> disposedGetter) {
        this.myChangeListUpdater = changeListUpdater;
        this.myComposite = composite;
        this.myDisposedGetter = disposedGetter;
        this.myVcsManager = ProjectLevelVcsManager.getInstance(changeListUpdater.getProject());
    }

    private void checkIfDisposed() {
        if (this.myDisposedGetter.get().booleanValue()) {
            throw new ProcessCanceledException();
        }
    }

    public void setCurrent(VcsDirtyScope scope2) {
        this.myScope = scope2;
        this.myFoldersCutDownWorker = new FoldersCutDownWorker();
    }

    @Override
    public void processChange(@NotNull Change change, VcsKey vcsKey) {
        if (change == null) {
            UpdatingChangeListBuilder.$$$reportNull$$$0(0);
        }
        this.processChangeInList(change, (ChangeList)null, vcsKey);
    }

    @Override
    public void processChangeInList(@NotNull Change change, @Nullable ChangeList changeList, VcsKey vcsKey) {
        if (change == null) {
            UpdatingChangeListBuilder.$$$reportNull$$$0(1);
        }
        this.checkIfDisposed();
        LOG.debug("[processChangeInList-1] entering, cl name: " + (changeList == null ? null : changeList.getName()) + " change: " + ChangesUtil.getFilePath(change).getPath());
        String fileName = ChangesUtil.getFilePath(change).getName();
        if (FileTypeManager.getInstance().isFileIgnored(fileName)) {
            LOG.debug("[processChangeInList-1] file type ignored");
            return;
        }
        if (ChangeListManagerImpl.isUnder(change, this.myScope)) {
            AbstractVcs vcs;
            AbstractVcs abstractVcs = vcs = vcsKey != null ? this.myVcsManager.findVcsByName(vcsKey.getName()) : null;
            if (changeList != null) {
                LOG.debug("[processChangeInList-1] to add change to cl");
                this.myChangeListUpdater.addChangeToList(changeList.getName(), change, vcs);
            } else {
                LOG.debug("[processChangeInList-1] to add to corresponding list");
                this.myChangeListUpdater.addChangeToCorrespondingList(change, vcs);
            }
        } else {
            LOG.debug("[processChangeInList-1] not under scope");
        }
    }

    @Override
    public void processChangeInList(@NotNull Change change, String changeListName, VcsKey vcsKey) {
        if (change == null) {
            UpdatingChangeListBuilder.$$$reportNull$$$0(2);
        }
        this.checkIfDisposed();
        LocalChangeList list = null;
        if (changeListName != null) {
            list = this.myChangeListUpdater.findOrCreateList(changeListName, null);
        }
        this.processChangeInList(change, list, vcsKey);
    }

    @Override
    public void removeRegisteredChangeFor(FilePath path2) {
        this.myChangeListUpdater.removeRegisteredChangeFor(path2);
    }

    @Override
    public void processUnversionedFile(FilePath filePath) {
        if (this.acceptFilePath(filePath, false)) {
            VirtualFile file;
            this.myComposite.getUnversionedFileHolder().addFile(this.myScope.getVcs(), filePath);
            SwitchedFileHolder switchedFileHolder = this.myComposite.getSwitchedFileHolder();
            if (!switchedFileHolder.isEmpty() && (file = filePath.getVirtualFile()) != null) {
                switchedFileHolder.removeFile(file);
            }
        }
    }

    @Override
    public void processLocallyDeletedFile(FilePath file) {
        this.processLocallyDeletedFile(new LocallyDeletedChange(file));
    }

    @Override
    public void processLocallyDeletedFile(LocallyDeletedChange locallyDeletedChange) {
        this.checkIfDisposed();
        FilePath file = locallyDeletedChange.getPath();
        if (FileTypeManager.getInstance().isFileIgnored(file.getName())) {
            return;
        }
        if (this.myScope.belongsTo(file)) {
            this.myComposite.getDeletedFileHolder().addFile(locallyDeletedChange);
        }
    }

    @Override
    public void processModifiedWithoutCheckout(VirtualFile file) {
        if (this.acceptFile(file, false)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("processModifiedWithoutCheckout " + file);
            }
            this.myComposite.getModifiedWithoutEditingFileHolder().addFile(file);
        }
    }

    @Override
    public void processIgnoredFile(FilePath filePath) {
        if (this.acceptFilePath(filePath, false)) {
            this.myComposite.getIgnoredFileHolder().addFile(this.myScope.getVcs(), filePath);
        }
    }

    @Override
    public void processLockedFolder(VirtualFile file) {
        if (this.acceptFile(file, true) && this.myFoldersCutDownWorker.addCurrent(file)) {
            this.myComposite.getLockedFileHolder().addFile(file);
        }
    }

    @Override
    public void processLogicallyLockedFolder(VirtualFile file, LogicalLock logicalLock) {
        if (this.acceptFile(file, true)) {
            this.myComposite.getLogicallyLockedFileHolder().add(file, logicalLock);
        }
    }

    @Override
    public void processSwitchedFile(VirtualFile file, String branch, boolean recursive) {
        if (this.acceptFile(file, false)) {
            this.myComposite.getSwitchedFileHolder().addFile(file, branch, recursive);
        }
    }

    @Override
    public void processRootSwitch(VirtualFile file, String branch) {
        if (this.acceptFile(file, true)) {
            this.myComposite.getRootSwitchFileHolder().addFile(file, branch, false);
        }
    }

    @Override
    public boolean reportChangesOutsideProject() {
        return false;
    }

    @Override
    public void reportAdditionalInfo(@NlsContexts.Label String text2) {
        this.reportAdditionalInfo(ChangesViewManager.createTextStatusFactory(text2, true));
    }

    @Override
    public void reportAdditionalInfo(Factory<JComponent> infoComponent) {
        if (this.myAdditionalInfo == null) {
            this.myAdditionalInfo = infoComponent;
        }
    }

    public Factory<JComponent> getAdditionalInfo() {
        return this.myAdditionalInfo;
    }

    private boolean acceptFile(@Nullable VirtualFile file, boolean allowIgnored) {
        this.checkIfDisposed();
        if (file == null) {
            return false;
        }
        if (!allowIgnored && ((Boolean)ReadAction.compute(() -> this.myVcsManager.isIgnored(file))).booleanValue()) {
            return false;
        }
        return this.myScope.belongsTo(VcsUtil.getFilePath(file));
    }

    private boolean acceptFilePath(@Nullable FilePath filePath, boolean allowIgnored) {
        this.checkIfDisposed();
        if (filePath == null) {
            return false;
        }
        if (!allowIgnored && ((Boolean)ReadAction.compute(() -> this.myVcsManager.isIgnored(filePath))).booleanValue()) {
            return false;
        }
        return this.myScope.belongsTo(filePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "change";
        objectArray2[1] = "com/intellij/openapi/vcs/changes/UpdatingChangeListBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processChange";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processChangeInList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

