/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.tools.combined.CombinedDiffModel;
import com.intellij.diff.tools.combined.CombinedDiffModelRepository;
import com.intellij.diff.tools.combined.CombinedDiffRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.EditorTabPreviewBase;
import com.intellij.openapi.vcs.changes.actions.diff.CombinedDiffPreviewKt;
import com.intellij.openapi.vcs.changes.actions.diff.CombinedDiffPreviewModel;
import com.intellij.openapi.vcs.changes.actions.diff.CombinedDiffPreviewVirtualFile;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.util.ui.UIUtil;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\b\u0010!\u001a\u00020\u000eH$J\b\u0010\"\u001a\u00020\u001dH$J\n\u0010#\u001a\u0004\u0018\u00010\u001dH\u0014J\r\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J\b\u0010'\u001a\u00020\nH\u0014J\b\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020\nH\u0014J\b\u0010+\u001a\u00020\nH\u0014J\b\u0010,\u001a\u00020)H\u0016J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020\nH\u0016R\u001b\u0010\r\u001a\u00020\u000e8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00148TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010R\u001d\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e*\u00020\u00038DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u00062"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/CombinedDiffPreview;", "Lcom/intellij/openapi/vcs/changes/EditorTabPreviewBase;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Lcom/intellij/openapi/Disposable;)V", "targetComponent", "Ljavax/swing/JComponent;", "isOpenEditorDiffPreviewWithSingleClick", "", "needSetupOpenPreviewListeners", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Ljavax/swing/JComponent;ZZLcom/intellij/openapi/Disposable;)V", "model", "Lcom/intellij/openapi/vcs/changes/actions/diff/CombinedDiffPreviewModel;", "getModel", "()Lcom/intellij/openapi/vcs/changes/actions/diff/CombinedDiffPreviewModel;", "model$delegate", "Lkotlin/Lazy;", "previewFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPreviewFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "previewFile$delegate", "getTree", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "updatePreviewProcessor", "getUpdatePreviewProcessor", "id", "", "Lorg/jetbrains/annotations/NonNls;", "getId", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;)Ljava/lang/String;", "createModel", "getCombinedDiffTabTitle", "getCurrentName", "getFileSize", "", "getFileSize$intellij_platform_vcs_impl", "hasContent", "installCombinedDiffModelListener", "", "isPreviewOnDoubleClickAllowed", "isPreviewOnEnterAllowed", "returnFocusToTree", "updateDiffAction", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updatePreview", "fromModelRefresh", "intellij.platform.vcs.impl"})
public abstract class CombinedDiffPreview
extends EditorTabPreviewBase {
    @NotNull
    private final ChangesTree tree;
    @NotNull
    private final Lazy previewFile$delegate;
    @NotNull
    private final Lazy model$delegate;

    public CombinedDiffPreview(@NotNull ChangesTree tree2, @NotNull JComponent targetComponent, boolean isOpenEditorDiffPreviewWithSingleClick, boolean needSetupOpenPreviewListeners, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree2), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)targetComponent, (String)"targetComponent");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Project project2 = tree2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"tree.project");
        super(project2, parentDisposable);
        this.tree = tree2;
        this.previewFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CombinedDiffPreviewVirtualFile>(this){
            final /* synthetic */ CombinedDiffPreview this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CombinedDiffPreviewVirtualFile invoke() {
                return new CombinedDiffPreviewVirtualFile(this.this$0.getId(this.this$0.getTree()));
            }
        }));
        this.model$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CombinedDiffPreviewModel>(this){
            final /* synthetic */ CombinedDiffPreview this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CombinedDiffPreviewModel invoke() {
                CombinedDiffPreviewModel combinedDiffPreviewModel = this.this$0.createModel();
                CombinedDiffPreview combinedDiffPreview = this.this$0;
                CombinedDiffPreviewModel model2 = combinedDiffPreviewModel;
                boolean bl = false;
                model2.getContext().putUserData(CombinedDiffPreviewKt.COMBINED_DIFF_PREVIEW_TAB_NAME, (Object)new Function0<String>((Object)combinedDiffPreview){

                    @NotNull
                    public final String invoke() {
                        return ((CombinedDiffPreview)this.receiver).getCombinedDiffTabTitle();
                    }
                });
                ComponentManager $this$service$iv = (ComponentManager)CombinedDiffPreview.access$getProject(combinedDiffPreview);
                boolean $i$f$service = false;
                Class<CombinedDiffModelRepository> serviceClass$iv = CombinedDiffModelRepository.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                }
                ((CombinedDiffModelRepository)object).registerModel(combinedDiffPreview.getId(combinedDiffPreview.getTree()), (CombinedDiffModel)model2);
                return combinedDiffPreviewModel;
            }
        }));
        this.setEscapeHandler(() -> CombinedDiffPreview._init_$lambda$0(this));
        if (needSetupOpenPreviewListeners) {
            this.installListeners(this.tree, isOpenEditorDiffPreviewWithSingleClick);
            this.installNextDiffActionOn(targetComponent);
        }
        UIUtil.putClientProperty((JComponent)((JComponent)((Object)this.tree)), (Key)ExpandableItemsHandler.IGNORE_ITEM_SELECTION, (Object)true);
        this.installCombinedDiffModelListener();
    }

    @NotNull
    protected final ChangesTree getTree() {
        return this.tree;
    }

    public CombinedDiffPreview(@NotNull ChangesTree tree2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree2), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this(tree2, (JComponent)((Object)tree2), false, true, parentDisposable);
    }

    @Override
    @NotNull
    protected VirtualFile getPreviewFile() {
        Lazy lazy = this.previewFile$delegate;
        return (VirtualFile)lazy.getValue();
    }

    @Override
    @NotNull
    protected CombinedDiffPreviewModel getUpdatePreviewProcessor() {
        return this.getModel();
    }

    @NotNull
    protected final CombinedDiffPreviewModel getModel() {
        Lazy lazy = this.model$delegate;
        return (CombinedDiffPreviewModel)lazy.getValue();
    }

    @Override
    public void updatePreview(boolean fromModelRefresh) {
        super.updatePreview(fromModelRefresh);
        if (this.isPreviewOpen()) {
            FileEditorManagerEx.Companion.getInstanceEx(this.getProject()).updateFilePresentation(this.getPreviewFile());
        }
    }

    private final void installCombinedDiffModelListener() {
        this.tree.addPropertyChangeListener("model", arg_0 -> CombinedDiffPreview.installCombinedDiffModelListener$lambda$1(this, arg_0));
    }

    public void returnFocusToTree() {
    }

    @Override
    protected boolean isPreviewOnDoubleClickAllowed() {
        return CombinedDiffRegistry.INSTANCE.isEnabled() && super.isPreviewOnDoubleClickAllowed();
    }

    @Override
    protected boolean isPreviewOnEnterAllowed() {
        return CombinedDiffRegistry.INSTANCE.isEnabled() && super.isPreviewOnEnterAllowed();
    }

    @NotNull
    protected abstract CombinedDiffPreviewModel createModel();

    @NotNull
    protected abstract String getCombinedDiffTabTitle();

    @Override
    public void updateDiffAction(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPresentation().setVisible(event.isFromActionToolbar() || event.getPresentation().isEnabled());
    }

    @Override
    @Nullable
    protected String getCurrentName() {
        ChangeViewDiffRequestProcessor.Wrapper wrapper = this.getModel().getSelected();
        return wrapper != null ? wrapper.getPresentableName() : null;
    }

    @Override
    protected boolean hasContent() {
        return !this.getModel().getRequests().isEmpty();
    }

    public final int getFileSize$intellij_platform_vcs_impl() {
        return this.getModel().getRequests().size();
    }

    @NotNull
    protected final String getId(@NotNull ChangesTree $this$id) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$id), (String)"<this>");
        return ((Object)((Object)$this$id)).getClass().getName() + "@" + Integer.toHexString($this$id.hashCode());
    }

    private static final void _init_$lambda$0(CombinedDiffPreview this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.closePreview();
        this$0.returnFocusToTree();
    }

    private static final void installCombinedDiffModelListener$lambda$1(CombinedDiffPreview this$0, PropertyChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.getModel().getOurDisposable().isDisposed()) {
            return;
        }
        List changes = CollectionsKt.toList(this$0.getModel().iterateSelectedOrAllChanges$intellij_platform_vcs_impl());
        if (!((Collection)changes).isEmpty()) {
            this$0.getModel().refresh(true);
            this$0.getModel().setBlocks(CombinedDiffPreviewModel.Companion.prepareCombinedDiffModelRequests(this$0.getProject(), changes));
        }
    }

    public static final /* synthetic */ Project access$getProject(CombinedDiffPreview $this) {
        return $this.getProject();
    }
}

