/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListsListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesPanel;
import com.intellij.openapi.vcs.changes.committed.ProjectCommittedChangesPanel;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\b\u0010\u0015\u001a\u00020\u000fH\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/ProjectCommittedChangesPanel;", "Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesPanel;", "project", "Lcom/intellij/openapi/project/Project;", "provider", "Lcom/intellij/openapi/vcs/CommittedChangesProvider;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/CommittedChangesProvider;)V", "cache", "Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesCache;", "kotlin.jvm.PlatformType", "getProvider", "()Lcom/intellij/openapi/vcs/CommittedChangesProvider;", "setProvider", "(Lcom/intellij/openapi/vcs/CommittedChangesProvider;)V", "clearCaches", "", "passCachedListsToListener", "notification", "Lcom/intellij/openapi/vcs/changes/committed/VcsConfigurationChangeListener$DetailedNotification;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "refreshChanges", "intellij.platform.vcs.impl"})
public final class ProjectCommittedChangesPanel
extends CommittedChangesPanel {
    @NotNull
    private CommittedChangesProvider<?, ?> provider;
    private final CommittedChangesCache cache;

    public ProjectCommittedChangesPanel(@NotNull Project project2, @NotNull CommittedChangesProvider<?, ?> provider) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        super(project2);
        this.provider = provider;
        this.cache = CommittedChangesCache.getInstance(project2);
        this.setup(null, this.provider.createActions(this.getBrowser(), null));
    }

    @NotNull
    public final CommittedChangesProvider<?, ?> getProvider() {
        return this.provider;
    }

    public final void setProvider(@NotNull CommittedChangesProvider<?, ?> committedChangesProvider) {
        Intrinsics.checkNotNullParameter(committedChangesProvider, (String)"<set-?>");
        this.provider = committedChangesProvider;
    }

    @Override
    public void refreshChanges() {
        this.cache.hasCachesForAnyRoot((Consumer<? super Boolean>)((Consumer)arg_0 -> ProjectCommittedChangesPanel.refreshChanges$lambda$0((Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ ProjectCommittedChangesPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Boolean hasCaches) {
                if (!hasCaches.booleanValue()) {
                    this.this$0.getBrowser().getEmptyText().setText(VcsBundle.message("committed.changes.not.loaded.message", new Object[0]));
                    return;
                }
                Function1 changeListsConsumer2 = (Function1)new Function1<List<? extends CommittedChangeList>, Unit>(this.this$0){
                    final /* synthetic */ ProjectCommittedChangesPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull List<? extends CommittedChangeList> changeLists) {
                        Intrinsics.checkNotNullParameter(changeLists, (String)"changeLists");
                        this.this$0.getBrowser().getEmptyText().setText(VcsBundle.message("committed.changes.empty.message", new Object[0]));
                        this.this$0.getBrowser().setItems(changeLists, CommittedChangesBrowserUseCase.COMMITTED);
                    }
                };
                Function1 errorHandler2 = (Function1)new Function1<List<? extends VcsException>, Unit>(this.this$0){
                    final /* synthetic */ ProjectCommittedChangesPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull List<? extends VcsException> errors) {
                        Intrinsics.checkNotNullParameter(errors, (String)"errors");
                        AbstractVcsHelper.getInstance(this.this$0.getProject()).showErrors(errors, VcsBundle.message("changes.error.refreshing.vcs.history", new Object[0]));
                    }
                };
                ProjectCommittedChangesPanel.access$getCache$p(this.this$0).getProjectChangesAsync((ChangeBrowserSettings)this.this$0.getProvider().createDefaultSettings(), 0, true, (Consumer<? super List<CommittedChangeList>>)((Consumer)arg_0 -> refreshChanges.1.invoke$lambda$0(changeListsConsumer2, arg_0)), (Consumer<? super List<VcsException>>)((Consumer)arg_0 -> refreshChanges.1.invoke$lambda$1(errorHandler2, arg_0)));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0)));
    }

    public final void clearCaches() {
        this.cache.clearCaches(() -> ProjectCommittedChangesPanel.clearCaches$lambda$1(this));
    }

    public final void passCachedListsToListener(@NotNull VcsConfigurationChangeListener.DetailedNotification notification, @Nullable VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        List changeLists = new ArrayList();
        this.getBrowser().reportLoadedLists(new CommittedChangeListsListener(changeLists, notification, this, root){
            final /* synthetic */ List<CommittedChangeList> $changeLists;
            final /* synthetic */ VcsConfigurationChangeListener.DetailedNotification $notification;
            final /* synthetic */ ProjectCommittedChangesPanel this$0;
            final /* synthetic */ VirtualFile $root;
            {
                this.$changeLists = $changeLists;
                this.$notification = $notification;
                this.this$0 = $receiver;
                this.$root = $root;
            }

            public void onBeforeStartReport() {
            }

            public boolean report(@NotNull CommittedChangeList list) {
                Intrinsics.checkNotNullParameter((Object)list, (String)"list");
                this.$changeLists.add(list);
                return false;
            }

            public void onAfterEndReport() {
                if (!((Collection)this.$changeLists).isEmpty()) {
                    this.$notification.execute(this.this$0.getProject(), this.$root, this.$changeLists);
                }
            }
        });
    }

    private static final void refreshChanges$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void clearCaches$lambda$1(ProjectCommittedChangesPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ActionsKt.runInEdt((ModalityState)ModalityState.nonModal(), (Function0)((Function0)new Function0<Unit>(this$0){
            final /* synthetic */ ProjectCommittedChangesPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (this.this$0.getProject().isDisposed()) {
                    return;
                }
                this.this$0.getBrowser().getEmptyText().setText(VcsBundle.message("committed.changes.not.loaded.message", new Object[0]));
                this.this$0.getBrowser().setItems(CollectionsKt.emptyList(), CommittedChangesBrowserUseCase.COMMITTED);
            }
        }));
    }

    public static final /* synthetic */ CommittedChangesCache access$getCache$p(ProjectCommittedChangesPanel $this) {
        return $this.cache;
    }
}

