/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.formove.PathMerger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.patch.LazyPatchContentRevision;
import com.intellij.openapi.vcs.changes.patch.Strippable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFilePatchInProgress<T extends FilePatch>
implements Strippable {
    protected final T myPatch;
    private final PatchStrippable myStrippable;
    protected final FilePatchStatus myStatus;
    private VirtualFile myBase;
    protected File myIoCurrentBase;
    protected VirtualFile myCurrentBase;
    private boolean myBaseExists;
    protected ContentRevision myNewContentRevision;
    private ContentRevision myCurrentRevision;
    private final List<VirtualFile> myAutoBases;
    protected volatile Boolean myConflicts;

    protected AbstractFilePatchInProgress(T patch, Collection<VirtualFile> autoBases, VirtualFile baseDir2) {
        this.myPatch = patch;
        this.myStrippable = new PatchStrippable((FilePatch)patch);
        this.myAutoBases = new ArrayList<VirtualFile>();
        if (autoBases != null) {
            this.setAutoBases(autoBases);
        }
        this.myStatus = this.getStatus(this.myPatch);
        if (this.myAutoBases.isEmpty()) {
            this.setNewBase(baseDir2);
        } else {
            this.setNewBase(this.myAutoBases.get(0));
        }
    }

    public void setAutoBases(@NotNull Collection<? extends VirtualFile> autoBases) {
        if (autoBases == null) {
            AbstractFilePatchInProgress.$$$reportNull$$$0(0);
        }
        String path2 = ((FilePatch)this.myPatch).getBeforeName() == null ? ((FilePatch)this.myPatch).getAfterName() : ((FilePatch)this.myPatch).getBeforeName();
        for (VirtualFile virtualFile : autoBases) {
            VirtualFile willBeBase = PathMerger.getBase(virtualFile, path2);
            if (willBeBase == null) continue;
            this.myAutoBases.add(willBeBase);
        }
    }

    private FilePatchStatus getStatus(T patch) {
        String beforeName = PathUtil.toSystemIndependentName((String)((FilePatch)patch).getBeforeName());
        String afterName = PathUtil.toSystemIndependentName((String)((FilePatch)patch).getAfterName());
        if (((FilePatch)patch).isNewFile() || beforeName == null) {
            return FilePatchStatus.ADDED;
        }
        if (((FilePatch)patch).isDeletedFile() || afterName == null) {
            return FilePatchStatus.DELETED;
        }
        if (beforeName.equals(afterName)) {
            return FilePatchStatus.MODIFIED;
        }
        return FilePatchStatus.MOVED_OR_RENAMED;
    }

    public PatchChange getChange() {
        return new PatchChange(this.getCurrentRevision(), this.getNewContentRevision(), this);
    }

    public void setNewBase(VirtualFile base) {
        this.myBase = base;
        this.myNewContentRevision = null;
        this.myCurrentRevision = null;
        this.myConflicts = null;
        String beforeName = ((FilePatch)this.myPatch).getBeforeName();
        if (beforeName != null) {
            this.myIoCurrentBase = PathMerger.getFile(new File(this.myBase.getPath()), beforeName);
            this.myCurrentBase = this.myIoCurrentBase == null ? null : VcsUtil.getVirtualFileWithRefresh(this.myIoCurrentBase);
            this.myBaseExists = this.myCurrentBase != null && this.myCurrentBase.exists();
        } else {
            String afterName = ((FilePatch)this.myPatch).getAfterName();
            this.myBaseExists = true;
            this.myIoCurrentBase = PathMerger.getFile(new File(this.myBase.getPath()), afterName);
            this.myCurrentBase = VcsUtil.getVirtualFileWithRefresh(this.myIoCurrentBase);
        }
    }

    public void setCreatedCurrentBase(VirtualFile vf) {
        this.myCurrentBase = vf;
    }

    public FilePatchStatus getStatus() {
        return this.myStatus;
    }

    public File getIoCurrentBase() {
        return this.myIoCurrentBase;
    }

    public VirtualFile getCurrentBase() {
        return this.myCurrentBase;
    }

    public VirtualFile getBase() {
        return this.myBase;
    }

    public T getPatch() {
        return this.myPatch;
    }

    private boolean isBaseExists() {
        return this.myBaseExists;
    }

    public boolean baseExistsOrAdded() {
        return this.myBaseExists || FilePatchStatus.ADDED.equals((Object)this.myStatus);
    }

    protected abstract ContentRevision getNewContentRevision();

    @NotNull
    protected FilePath getFilePath() {
        FilePath filePath = FilePatchStatus.ADDED.equals((Object)this.myStatus) ? VcsUtil.getFilePath(this.myIoCurrentBase, false) : this.detectNewFilePathForMovedOrModified();
        if (filePath == null) {
            AbstractFilePatchInProgress.$$$reportNull$$$0(1);
        }
        return filePath;
    }

    @NotNull
    protected FilePath detectNewFilePathForMovedOrModified() {
        FilePath filePath = FilePatchStatus.MOVED_OR_RENAMED.equals((Object)this.myStatus) ? VcsUtil.getFilePath(Objects.requireNonNull(PathMerger.getFile(new File(this.myBase.getPath()), ((FilePatch)this.myPatch).getAfterName())), false) : (this.myCurrentBase != null ? VcsUtil.getFilePath(this.myCurrentBase) : VcsUtil.getFilePath(this.myIoCurrentBase, false));
        if (filePath == null) {
            AbstractFilePatchInProgress.$$$reportNull$$$0(2);
        }
        return filePath;
    }

    protected boolean isConflictingChange() {
        if (this.myConflicts == null) {
            if (this.myCurrentBase != null && this.myNewContentRevision instanceof LazyPatchContentRevision) {
                ((LazyPatchContentRevision)this.myNewContentRevision).getContent();
                this.myConflicts = ((LazyPatchContentRevision)this.myNewContentRevision).isPatchApplyFailed();
            } else {
                this.myConflicts = false;
            }
        }
        return this.myConflicts;
    }

    private ContentRevision getCurrentRevision() {
        if (FilePatchStatus.ADDED.equals((Object)this.myStatus)) {
            return null;
        }
        if (this.myCurrentRevision == null) {
            FilePath filePath = this.myCurrentBase != null ? VcsUtil.getFilePath(this.myCurrentBase) : VcsUtil.getFilePath(this.myIoCurrentBase, false);
            this.myCurrentRevision = new CurrentContentRevision(filePath);
        }
        return this.myCurrentRevision;
    }

    @NotNull
    public abstract DiffRequestProducer getDiffRequestProducers(Project var1, PatchReader var2);

    public List<VirtualFile> getAutoBasesCopy() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(this.myAutoBases.size() + 1);
        result2.addAll(this.myAutoBases);
        return result2;
    }

    public Couple<String> getKey() {
        return Couple.of((Object)((FilePatch)this.myPatch).getBeforeName(), (Object)((FilePatch)this.myPatch).getAfterName());
    }

    private void refresh() {
        this.myStrippable.applyBackToPatch((FilePatch)this.myPatch);
        this.setNewBase(this.myBase);
    }

    @Override
    public void reset() {
        this.myStrippable.reset();
        this.refresh();
    }

    @Override
    public boolean canDown() {
        return this.myStrippable.canDown();
    }

    @Override
    public boolean canUp() {
        return this.myStrippable.canUp();
    }

    @Override
    public void up() {
        this.myStrippable.up();
        this.refresh();
    }

    @Override
    public void down() {
        this.myStrippable.down();
        this.refresh();
    }

    @Override
    public void setZero() {
        this.myStrippable.setZero();
        this.refresh();
    }

    @Override
    @NlsSafe
    public String getCurrentPath() {
        return this.myStrippable.getCurrentPath();
    }

    @NotNull
    public String getOriginalBeforePath() {
        String string2 = this.myStrippable.getOriginalBeforePath();
        if (string2 == null) {
            AbstractFilePatchInProgress.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    public int getCurrentStrip() {
        return this.myStrippable.getCurrentStrip();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFilePatchInProgress that = (AbstractFilePatchInProgress)o;
        return this.myStrippable.equals(that.myStrippable);
    }

    public int hashCode() {
        return this.myStrippable.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoBases";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/AbstractFilePatchInProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/AbstractFilePatchInProgress";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "detectNewFilePathForMovedOrModified";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalBeforePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setAutoBases";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3 -> new IllegalStateException(string2);
        };
    }

    private static final class PatchStrippable
    implements Strippable {
        private final StripCapablePath[] myParts;
        private final int myBeforeIdx;
        private final int myAfterIdx;

        private PatchStrippable(FilePatch patch) {
            boolean onePath = patch.isDeletedFile() || patch.isNewFile() || Objects.equals(patch.getAfterName(), patch.getBeforeName());
            int size = onePath ? 1 : 2;
            this.myParts = new StripCapablePath[size];
            int cnt = 0;
            if (patch.getAfterName() != null) {
                this.myAfterIdx = 0;
                this.myParts[cnt] = new StripCapablePath(patch.getAfterName());
                ++cnt;
            } else {
                this.myAfterIdx = -1;
            }
            if (cnt < size) {
                this.myParts[cnt] = new StripCapablePath(patch.getBeforeName());
                this.myBeforeIdx = cnt;
            } else {
                this.myBeforeIdx = 0;
            }
        }

        @Override
        public void reset() {
            for (StripCapablePath part : this.myParts) {
                part.reset();
            }
        }

        @Override
        public boolean canDown() {
            boolean result2 = true;
            for (StripCapablePath part : this.myParts) {
                result2 &= part.canDown();
            }
            return result2;
        }

        @Override
        public boolean canUp() {
            boolean result2 = true;
            for (StripCapablePath part : this.myParts) {
                result2 &= part.canUp();
            }
            return result2;
        }

        @Override
        public void up() {
            for (StripCapablePath part : this.myParts) {
                part.up();
            }
        }

        @Override
        public void down() {
            for (StripCapablePath part : this.myParts) {
                part.down();
            }
        }

        @Override
        public void setZero() {
            for (StripCapablePath part : this.myParts) {
                part.setZero();
            }
        }

        @Override
        public String getCurrentPath() {
            return this.myParts[0].getCurrentPath();
        }

        @NotNull
        private String getOriginalBeforePath() {
            String string2 = this.myParts[this.myBeforeIdx].getOriginalPath();
            if (string2 == null) {
                PatchStrippable.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        public int getCurrentStrip() {
            return this.myParts[0].getCurrentStrip();
        }

        public void applyBackToPatch(FilePatch patch) {
            String afterName;
            String beforeName = patch.getBeforeName();
            if (beforeName != null) {
                patch.setBeforeName(this.myParts[this.myBeforeIdx].getCurrentPath());
            }
            if ((afterName = patch.getAfterName()) != null) {
                patch.setAfterName(this.myParts[this.myAfterIdx].getCurrentPath());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatchStrippable that = (PatchStrippable)o;
            return Arrays.equals(this.myParts, that.myParts);
        }

        public int hashCode() {
            return Arrays.hashCode(this.myParts);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/AbstractFilePatchInProgress$PatchStrippable", "getOriginalBeforePath"));
        }
    }

    public static final class PatchChange
    extends Change {
        private final AbstractFilePatchInProgress<?> myPatchInProgress;

        public PatchChange(ContentRevision beforeRevision, ContentRevision afterRevision, AbstractFilePatchInProgress<?> patchInProgress) {
            super(beforeRevision, afterRevision, patchInProgress.isBaseExists() || FilePatchStatus.ADDED.equals((Object)patchInProgress.getStatus()) ? null : FileStatus.MERGED_WITH_CONFLICTS);
            this.myPatchInProgress = patchInProgress;
        }

        public AbstractFilePatchInProgress<?> getPatchInProgress() {
            return this.myPatchInProgress;
        }

        public boolean isValid() {
            return this.myPatchInProgress.baseExistsOrAdded();
        }
    }

    private static final class StripCapablePath
    implements Strippable {
        private final int myStripMax;
        private int myCurrentStrip;
        private final StringBuilder mySourcePath;
        private final int[] myParts;

        private StripCapablePath(String path2) {
            String corrected = PathUtil.toSystemIndependentName((String)path2.trim());
            this.mySourcePath = new StringBuilder(corrected);
            String[] steps = corrected.split("/");
            this.myStripMax = steps.length - 1;
            this.myParts = new int[steps.length];
            int pos = 0;
            for (int i = 0; i < steps.length; ++i) {
                String step2 = steps[i];
                this.myParts[i] = pos;
                pos += step2.length() + 1;
            }
            this.myCurrentStrip = 0;
        }

        @Override
        public void reset() {
            this.myCurrentStrip = 0;
        }

        @Override
        public int getCurrentStrip() {
            return this.myCurrentStrip;
        }

        @Override
        public boolean canDown() {
            return this.myCurrentStrip > 0;
        }

        @Override
        public boolean canUp() {
            return this.myCurrentStrip < this.myStripMax;
        }

        @Override
        public void up() {
            if (this.canUp()) {
                ++this.myCurrentStrip;
            }
        }

        @Override
        public void down() {
            if (this.canDown()) {
                --this.myCurrentStrip;
            }
        }

        @Override
        public void setZero() {
            this.myCurrentStrip = this.myStripMax;
        }

        @Override
        public String getCurrentPath() {
            return this.mySourcePath.substring(this.myParts[this.myCurrentStrip]);
        }

        @NotNull
        private String getOriginalPath() {
            String string2 = this.mySourcePath.toString();
            if (string2 == null) {
                StripCapablePath.$$$reportNull$$$0(0);
            }
            return string2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StripCapablePath that = (StripCapablePath)o;
            return StringUtil.equals((CharSequence)this.mySourcePath, (CharSequence)that.mySourcePath);
        }

        public int hashCode() {
            return this.mySourcePath.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/AbstractFilePatchInProgress$StripCapablePath", "getOriginalPath"));
        }
    }
}

