/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.diff.DiffManager;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.ImportToShelfExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplyPatchAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(ApplyPatchAction.class);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ApplyPatchAction.$$$reportNull$$$0(0);
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            e.getPresentation().setEnabledAndVisible(project2 != null && PatchFileType.isPatchFile(vFile));
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(project2 != null);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ApplyPatchAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ApplyPatchAction.$$$reportNull$$$0(2);
        }
        if (ChangeListManager.getInstance(project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT)).isFreezedWithNotification(VcsBundle.message("patch.apply.cannot.apply.now", new Object[0]))) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile vFile = null;
        String place = e.getPlace();
        if (ActionPlaces.isPopupPlace((String)e.getPlace()) || "MainMenu".equals(place)) {
            vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        }
        if (PatchFileType.isPatchFile(vFile)) {
            ApplyPatchAction.showApplyPatch(project2, vFile);
        } else {
            FileChooserDescriptor descriptor = ApplyPatchDifferentiatedDialog.createSelectPatchDescriptor();
            VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
            VirtualFile toSelect = settings.PATCH_STORAGE_LOCATION == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(settings.PATCH_STORAGE_LOCATION));
            FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project2, (VirtualFile)toSelect, file -> {
                VirtualFile parent = file.getParent();
                if (parent != null) {
                    settings.PATCH_STORAGE_LOCATION = parent.getPath();
                }
                ApplyPatchAction.showApplyPatch(project2, file);
            });
        }
    }

    public static void showApplyPatch(@NotNull Project project2, @NotNull VirtualFile file) {
        if (project2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ApplyPatchAction.$$$reportNull$$$0(4);
        }
        ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(project2, new ApplyPatchDefaultExecutor(project2), Collections.singletonList(new ImportToShelfExecutor(project2)), ApplyPatchMode.APPLY, file);
        dialog.show();
    }

    @RequiresEdt
    public static Boolean showAndGetApplyPatch(@NotNull Project project2, @NotNull File file) {
        if (project2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ApplyPatchAction.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        String patchPath = file.getPath();
        if (vFile == null) {
            VcsNotifier.getInstance(project2).notifyWeakError("vcs.patch.apply.cannot.find.patch.file", VcsBundle.message("patch.apply.can.t.find.patch.file.warning", patchPath));
            return false;
        }
        if (!PatchFileType.isPatchFile(vFile)) {
            VcsNotifier.getInstance(project2).notifyWeakError("vcs.patch.apply.not.patch.type.file", VcsBundle.message("patch.apply.not.patch.type.file.error", patchPath));
            return false;
        }
        ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(project2, new ApplyPatchDefaultExecutor(project2), Collections.emptyList(), ApplyPatchMode.APPLY_PATCH_IN_MEMORY, vFile);
        dialog.setModal(true);
        return dialog.showAndGet();
    }

    @NotNull
    public static ApplyPatchStatus applyContent(@NotNull Project project2, @NotNull ApplyFilePatchBase<?> patch, @Nullable ApplyPatchContext context, @NotNull VirtualFile file, @Nullable CommitContext commitContext, boolean reverse, @Nullable String leftPanelTitle, @Nullable String rightPanelTitle) {
        ApplyPatchStatus applyPatchStatus;
        String patchedContent;
        ApplyFilePatch.Result result2;
        ApplyPatchStatus status;
        if (project2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(7);
        }
        if (patch == null) {
            ApplyPatchAction.$$$reportNull$$$0(8);
        }
        if (file == null) {
            ApplyPatchAction.$$$reportNull$$$0(9);
        }
        if (ApplyPatchStatus.ALREADY_APPLIED.equals((Object)(status = (result2 = ApplyPatchAction.tryApplyPatch(project2, patch, context, file, commitContext)).getStatus())) || ApplyPatchStatus.SUCCESS.equals((Object)status)) {
            ApplyPatchStatus applyPatchStatus2 = status;
            if (applyPatchStatus2 == null) {
                ApplyPatchAction.$$$reportNull$$$0(10);
            }
            return applyPatchStatus2;
        }
        ApplyPatchForBaseRevisionTexts mergeData = result2.getMergeData();
        if (mergeData == null) {
            ApplyPatchStatus applyPatchStatus3 = status;
            if (applyPatchStatus3 == null) {
                ApplyPatchAction.$$$reportNull$$$0(11);
            }
            return applyPatchStatus3;
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(file);
        if (document2 == null) {
            ApplyPatchStatus applyPatchStatus4 = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus4 == null) {
                ApplyPatchAction.$$$reportNull$$$0(12);
            }
            return applyPatchStatus4;
        }
        if (mergeData.getBase() == null && ApplyPatchStatus.PARTIAL.equals((Object)status)) {
            WriteAction.run(() -> {
                VcsFacade.getInstance().runHeavyModificationTask(project2, document2, () -> document2.setText((CharSequence)mergeData.getPatched()));
                FileDocumentManager.getInstance().saveDocument(document2);
            });
            ApplyPatchStatus applyPatchStatus5 = status;
            if (applyPatchStatus5 == null) {
                ApplyPatchAction.$$$reportNull$$$0(13);
            }
            return applyPatchStatus5;
        }
        String baseContent = ApplyPatchAction.convertLineSeparators(mergeData.getBase());
        String localContent = ApplyPatchAction.convertLineSeparators(mergeData.getLocal());
        if (localContent.equals(patchedContent = mergeData.getPatched())) {
            ApplyPatchStatus applyPatchStatus6 = ApplyPatchStatus.ALREADY_APPLIED;
            if (applyPatchStatus6 == null) {
                ApplyPatchAction.$$$reportNull$$$0(14);
            }
            return applyPatchStatus6;
        }
        Ref applyPatchStatusReference = new Ref();
        Consumer callback2 = result13 -> {
            FileDocumentManager.getInstance().saveDocument(document2);
            applyPatchStatusReference.setIfNull((Object)(result13 != MergeResult.CANCEL ? ApplyPatchStatus.SUCCESS : ApplyPatchStatus.FAILURE));
        };
        try {
            MergeRequest request;
            if (baseContent != null) {
                if (reverse) {
                    if (leftPanelTitle == null) {
                        leftPanelTitle = VcsBundle.message("patch.apply.conflict.patched.version", new Object[0]);
                    }
                    if (rightPanelTitle == null) {
                        rightPanelTitle = VcsBundle.message("patch.apply.conflict.local.version", new Object[0]);
                    }
                    List<String> contents = Arrays.asList(patchedContent, baseContent, localContent);
                    List<String> titles = Arrays.asList(leftPanelTitle, null, rightPanelTitle);
                    request = PatchDiffRequestFactory.createMergeRequest(project2, document2, file, contents, null, titles, (Consumer<? super MergeResult>)callback2);
                } else {
                    request = PatchDiffRequestFactory.createMergeRequest(project2, document2, file, baseContent, localContent, patchedContent, (Consumer<? super MergeResult>)callback2);
                }
            } else {
                TextFilePatch textPatch = (TextFilePatch)patch.getPatch();
                GenericPatchApplier applier = new GenericPatchApplier(localContent, textPatch.getHunks());
                applier.execute();
                AppliedTextPatch appliedTextPatch = AppliedTextPatch.create(applier.getAppliedInfo());
                request = PatchDiffRequestFactory.createBadMergeRequest(project2, document2, file, localContent, appliedTextPatch, (Consumer<? super MergeResult>)callback2);
            }
            request.putUserData(DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS, result12 -> result12.equals((Object)MergeResult.CANCEL) ? VcsBundle.message("patch.apply.abort.action", new Object[0]) : null);
            request.putUserData(DiffUserDataKeysEx.MERGE_CANCEL_HANDLER, viewer -> {
                String message2 = VcsBundle.message("patch.apply.abort.and.rollback.prompt", new Object[0]);
                String title2 = VcsBundle.message("patch.apply.abort.title", new Object[0]);
                String yesText = VcsBundle.message("patch.apply.abort.and.rollback.action", new Object[0]);
                String noText = VcsBundle.message("patch.apply.skip.action", new Object[0]);
                String cancelText = VcsBundle.message("patch.apply.continue.resolve.action", new Object[0]);
                int result1 = Messages.showYesNoCancelDialog((Component)viewer.getComponent().getRootPane(), (String)message2, (String)title2, (String)yesText, (String)noText, (String)cancelText, (Icon)Messages.getQuestionIcon());
                if (result1 == 0) {
                    applyPatchStatusReference.set((Object)ApplyPatchStatus.ABORT);
                } else if (result1 == 1) {
                    applyPatchStatusReference.set((Object)ApplyPatchStatus.SKIP);
                }
                return result1 != 2;
            });
            DiffManager.getInstance().showMerge(project2, request);
            applyPatchStatus = (ApplyPatchStatus)((Object)applyPatchStatusReference.get());
        }
        catch (InvalidDiffRequestException e) {
            LOG.warn((Throwable)e);
            ApplyPatchStatus applyPatchStatus7 = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus7 == null) {
                ApplyPatchAction.$$$reportNull$$$0(16);
            }
            return applyPatchStatus7;
        }
        if (applyPatchStatus == null) {
            ApplyPatchAction.$$$reportNull$$$0(15);
        }
        return applyPatchStatus;
    }

    @NotNull
    private static ApplyFilePatch.Result tryApplyPatch(@NotNull Project project2, @NotNull ApplyFilePatchBase<?> patch, @Nullable ApplyPatchContext context, @NotNull VirtualFile file, @Nullable CommitContext commitContext) {
        if (project2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(17);
        }
        if (patch == null) {
            ApplyPatchAction.$$$reportNull$$$0(18);
        }
        if (file == null) {
            ApplyPatchAction.$$$reportNull$$$0(19);
        }
        Object patchBase = patch.getPatch();
        ApplyFilePatch.Result result2 = (ApplyFilePatch.Result)WriteAction.compute(() -> {
            try {
                return patch.apply(file, context, project2, VcsUtil.getFilePath(file), () -> {
                    String path2 = (String)ObjectUtils.chooseNotNull((Object)patchBase.getBeforeName(), (Object)patchBase.getAfterName());
                    return BaseRevisionTextPatchEP.getBaseContent(project2, path2, commitContext);
                }, commitContext);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return ApplyFilePatch.FAILURE;
            }
        });
        if (result2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(20);
        }
        return result2;
    }

    @Nullable
    private static String convertLineSeparators(@Nullable String charSequence) {
        return charSequence != null ? StringUtil.convertLineSeparators((String)charSequence) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 10, 11, 12, 13, 14, 15, 16, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "applyContent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "tryApplyPatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showApplyPatch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showAndGetApplyPatch";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyContent";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tryApplyPatch";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 10, 11, 12, 13, 14, 15, 16, 20 -> new IllegalStateException(string2);
        };
    }
}

