/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchException;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShelvedChange {
    private static final Logger LOG = Logger.getInstance(ShelvedChange.class);
    @NotNull
    private final Path myPatchPath;
    @NotNull
    private final String myBeforePath;
    @NotNull
    private final String myAfterPath;
    @NotNull
    private final FileStatus myFileStatus;
    @NotNull
    private final Change myChange;

    private ShelvedChange(@NotNull Path patchPath, @NotNull String beforePath, @NotNull String afterPath, @NotNull FileStatus fileStatus, @NotNull Change change) {
        if (patchPath == null) {
            ShelvedChange.$$$reportNull$$$0(0);
        }
        if (beforePath == null) {
            ShelvedChange.$$$reportNull$$$0(1);
        }
        if (afterPath == null) {
            ShelvedChange.$$$reportNull$$$0(2);
        }
        if (fileStatus == null) {
            ShelvedChange.$$$reportNull$$$0(3);
        }
        if (change == null) {
            ShelvedChange.$$$reportNull$$$0(4);
        }
        this.myPatchPath = patchPath;
        this.myBeforePath = beforePath;
        this.myAfterPath = afterPath;
        this.myFileStatus = fileStatus;
        this.myChange = change;
    }

    public static ShelvedChange create(@NotNull Project project2, @NotNull Path patchPath, @NotNull String beforePath, @NotNull String afterPath, @NotNull FileStatus fileStatus) {
        if (project2 == null) {
            ShelvedChange.$$$reportNull$$$0(5);
        }
        if (patchPath == null) {
            ShelvedChange.$$$reportNull$$$0(6);
        }
        if (beforePath == null) {
            ShelvedChange.$$$reportNull$$$0(7);
        }
        if (afterPath == null) {
            ShelvedChange.$$$reportNull$$$0(8);
        }
        if (fileStatus == null) {
            ShelvedChange.$$$reportNull$$$0(9);
        }
        afterPath = Objects.equals(beforePath, afterPath) ? beforePath : afterPath;
        Change change = ShelvedChange.createChange(project2, patchPath, beforePath, afterPath, fileStatus);
        return new ShelvedChange(patchPath, beforePath, afterPath, fileStatus, change);
    }

    public static ShelvedChange copyToNewPatch(@NotNull Project project2, @NotNull Path newPatchPath, @NotNull ShelvedChange shelvedChange) {
        if (project2 == null) {
            ShelvedChange.$$$reportNull$$$0(10);
        }
        if (newPatchPath == null) {
            ShelvedChange.$$$reportNull$$$0(11);
        }
        if (shelvedChange == null) {
            ShelvedChange.$$$reportNull$$$0(12);
        }
        return ShelvedChange.create(project2, newPatchPath, shelvedChange.getBeforePath(), shelvedChange.getAfterPath(), shelvedChange.getFileStatus());
    }

    public boolean isConflictingChange() {
        block3: {
            ContentRevision afterRevision = this.getChange().getAfterRevision();
            if (afterRevision == null) {
                return false;
            }
            try {
                afterRevision.getContent();
            }
            catch (VcsException e) {
                if (!(e.getCause() instanceof ApplyPatchException)) break block3;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getBeforePath() {
        String string2 = this.myBeforePath;
        if (string2 == null) {
            ShelvedChange.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @NotNull
    public String getAfterPath() {
        String string2 = this.myAfterPath;
        if (string2 == null) {
            ShelvedChange.$$$reportNull$$$0(14);
        }
        return string2;
    }

    @NotNull
    public FileStatus getFileStatus() {
        FileStatus fileStatus = this.myFileStatus;
        if (fileStatus == null) {
            ShelvedChange.$$$reportNull$$$0(15);
        }
        return fileStatus;
    }

    @NotNull
    public Change getChange() {
        Change change = this.myChange;
        if (change == null) {
            ShelvedChange.$$$reportNull$$$0(16);
        }
        return change;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Change getChange(@NotNull Project project2) {
        if (project2 == null) {
            ShelvedChange.$$$reportNull$$$0(17);
        }
        Change change = this.myChange;
        if (change == null) {
            ShelvedChange.$$$reportNull$$$0(18);
        }
        return change;
    }

    private static Change createChange(@NotNull Project project2, @NotNull Path patchPath, @NotNull String beforePath, @NotNull String afterPath, @NotNull FileStatus fileStatus) {
        if (project2 == null) {
            ShelvedChange.$$$reportNull$$$0(19);
        }
        if (patchPath == null) {
            ShelvedChange.$$$reportNull$$$0(20);
        }
        if (beforePath == null) {
            ShelvedChange.$$$reportNull$$$0(21);
        }
        if (afterPath == null) {
            ShelvedChange.$$$reportNull$$$0(22);
        }
        if (fileStatus == null) {
            ShelvedChange.$$$reportNull$$$0(23);
        }
        File baseDir2 = new File(Objects.requireNonNull(project2.getBasePath()));
        FilePath beforeFilePath = VcsUtil.getFilePath(ShelvedChange.getAbsolutePath(baseDir2, beforePath), false);
        FilePath afterFilePath = VcsUtil.getFilePath(ShelvedChange.getAbsolutePath(baseDir2, afterPath), false);
        CurrentContentRevision beforeRevision = null;
        if (fileStatus != FileStatus.ADDED) {
            beforeRevision = new CurrentContentRevision(beforeFilePath){

                @Override
                @NotNull
                public VcsRevisionNumber getRevisionNumber() {
                    return new TextRevisionNumber(VcsBundle.message("local.version.title", new Object[0]));
                }
            };
        }
        PatchedContentRevision afterRevision = null;
        if (fileStatus != FileStatus.DELETED) {
            afterRevision = new PatchedContentRevision(project2, patchPath, beforePath, beforeFilePath, afterFilePath);
        }
        return new Change(beforeRevision, afterRevision, fileStatus);
    }

    private static File getAbsolutePath(@NotNull File baseDir2, @NotNull String relativePath) {
        File file;
        if (baseDir2 == null) {
            ShelvedChange.$$$reportNull$$$0(24);
        }
        if (relativePath == null) {
            ShelvedChange.$$$reportNull$$$0(25);
        }
        try {
            file = new File(baseDir2, relativePath).getCanonicalFile();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            file = new File(baseDir2, relativePath);
        }
        return file;
    }

    @Nullable
    private static TextFilePatch loadFilePatch(@NotNull Project project2, @NotNull Path patchPath, @NotNull String beforePath, @Nullable CommitContext commitContext) throws IOException, PatchSyntaxException {
        if (project2 == null) {
            ShelvedChange.$$$reportNull$$$0(26);
        }
        if (patchPath == null) {
            ShelvedChange.$$$reportNull$$$0(27);
        }
        if (beforePath == null) {
            ShelvedChange.$$$reportNull$$$0(28);
        }
        List<TextFilePatch> filePatches = ShelveChangesManager.loadPatches(project2, patchPath, commitContext);
        return (TextFilePatch)ContainerUtil.find(filePatches, patch -> beforePath.equals(patch.getBeforeName()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShelvedChange)) {
            return false;
        }
        ShelvedChange that = (ShelvedChange)o;
        if (!Objects.equals(this.myAfterPath, that.myAfterPath)) {
            return false;
        }
        if (!Objects.equals(this.myBeforePath, that.myBeforePath)) {
            return false;
        }
        if (!Objects.equals(this.myFileStatus, that.myFileStatus)) {
            return false;
        }
        return Objects.equals(this.myPatchPath, that.myPatchPath);
    }

    public int hashCode() {
        return Objects.hash(this.myPatchPath, this.myBeforePath, this.myAfterPath, this.myFileStatus);
    }

    @NotNull
    public Path getPatchPath() {
        Path path2 = this.myPatchPath;
        if (path2 == null) {
            ShelvedChange.$$$reportNull$$$0(29);
        }
        return path2;
    }

    public String toString() {
        return FileUtil.toSystemDependentName((String)this.myBeforePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15, 16, 18, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchPath";
                break;
            }
            case 1: 
            case 7: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforePath";
                break;
            }
            case 2: 
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterPath";
                break;
            }
            case 3: 
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatus";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 5: 
            case 10: 
            case 17: 
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPatchPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChange";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChange";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChange";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforePath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getChange";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyToNewPatch";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 29: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getChange";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "loadFilePatch";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 13, 14, 15, 16, 18, 29 -> new IllegalStateException(string2);
        };
    }

    private static class PatchedContentRevision
    implements ContentRevision {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Path myPatchPath;
        @NotNull
        private final String myBeforePath;
        @NotNull
        private final FilePath myBeforeFilePath;
        @NotNull
        private final FilePath myAfterFilePath;

        PatchedContentRevision(@NotNull Project project2, @NotNull Path patchPath, @NotNull String beforePath, @NotNull FilePath beforeFilePath, @NotNull FilePath afterFilePath) {
            if (project2 == null) {
                PatchedContentRevision.$$$reportNull$$$0(0);
            }
            if (patchPath == null) {
                PatchedContentRevision.$$$reportNull$$$0(1);
            }
            if (beforePath == null) {
                PatchedContentRevision.$$$reportNull$$$0(2);
            }
            if (beforeFilePath == null) {
                PatchedContentRevision.$$$reportNull$$$0(3);
            }
            if (afterFilePath == null) {
                PatchedContentRevision.$$$reportNull$$$0(4);
            }
            this.myProject = project2;
            this.myPatchPath = patchPath;
            this.myBeforePath = beforePath;
            this.myBeforeFilePath = beforeFilePath;
            this.myAfterFilePath = afterFilePath;
        }

        @Override
        @Nullable
        public String getContent() throws VcsException {
            try {
                return this.loadContent();
            }
            catch (VcsException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VcsException(e);
            }
        }

        @Nullable
        private String loadContent() throws IOException, PatchSyntaxException, VcsException {
            TextFilePatch patch = ShelvedChange.loadFilePatch(this.myProject, this.myPatchPath, this.myBeforePath, null);
            if (patch != null) {
                return this.loadContent(patch);
            }
            return null;
        }

        private String loadContent(TextFilePatch patch) throws VcsException {
            if (patch.isNewFile()) {
                return patch.getSingleHunkPatchText();
            }
            if (patch.isDeletedFile()) {
                return null;
            }
            GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply(this.getBaseContent(), patch.getHunks());
            if (appliedPatch != null) {
                return appliedPatch.patchedText;
            }
            throw new VcsException(VcsBundle.message("patch.apply.error.conflict", new Object[0]));
        }

        @NotNull
        private String getBaseContent() throws VcsException {
            String string2 = (String)ReadAction.compute(() -> {
                VirtualFile file = this.myBeforeFilePath.getVirtualFile();
                if (file == null) {
                    throw new VcsException(VcsBundle.message("patch.apply.error.file.not.found", this.myBeforeFilePath));
                }
                Document doc = FileDocumentManager.getInstance().getDocument(file);
                if (doc == null) {
                    throw new VcsException(VcsBundle.message("patch.apply.error.document.not.found", file));
                }
                return doc.getText();
            });
            if (string2 == null) {
                PatchedContentRevision.$$$reportNull$$$0(5);
            }
            return string2;
        }

        @Override
        @NotNull
        public FilePath getFile() {
            FilePath filePath = this.myAfterFilePath;
            if (filePath == null) {
                PatchedContentRevision.$$$reportNull$$$0(6);
            }
            return filePath;
        }

        @Override
        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            return new TextRevisionNumber(VcsBundle.message("shelved.version.name", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beforePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beforeFilePath";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterFilePath";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChange$PatchedContentRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChange$PatchedContentRevision";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBaseContent";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5, 6 -> new IllegalStateException(string2);
            };
        }
    }
}

