/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.changes.ui.BaseInclusionModel;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0016J\u0016\u0010\u0015\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0016J\u0016\u0010\u0016\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DefaultInclusionModel;", "Lcom/intellij/openapi/vcs/changes/ui/BaseInclusionModel;", "inclusionHashingStrategy", "Lcom/intellij/util/containers/HashingStrategy;", "", "(Lcom/intellij/util/containers/HashingStrategy;)V", "inclusion", "", "addInclusion", "", "items", "", "clearInclusion", "getInclusion", "", "getInclusionState", "Lcom/intellij/util/ui/ThreeStateCheckBox$State;", "item", "isInclusionEmpty", "", "removeInclusion", "retainInclusion", "setInclusion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultInclusionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultInclusionModel.kt\ncom/intellij/openapi/vcs/changes/ui/DefaultInclusionModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class DefaultInclusionModel
extends BaseInclusionModel {
    @Nullable
    private final HashingStrategy<Object> inclusionHashingStrategy;
    @NotNull
    private final Set<Object> inclusion;

    public DefaultInclusionModel(@Nullable HashingStrategy<Object> inclusionHashingStrategy) {
        Set set;
        this.inclusionHashingStrategy = inclusionHashingStrategy;
        if (this.inclusionHashingStrategy == null) {
            set = new HashSet();
        } else {
            Set set2 = CollectionFactory.createCustomHashingStrategySet(this.inclusionHashingStrategy);
            set = set2;
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"createCustomHashingStrat\u2026inclusionHashingStrategy)");
        }
        this.inclusion = set;
    }

    public /* synthetic */ DefaultInclusionModel(HashingStrategy hashingStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            hashingStrategy = null;
        }
        this((HashingStrategy<Object>)hashingStrategy);
    }

    @Override
    @NotNull
    public Set<Object> getInclusion() {
        Set set;
        if (this.inclusionHashingStrategy == null) {
            set = new HashSet(this.inclusion);
        } else {
            Set set2;
            Set it = set2 = CollectionFactory.createCustomHashingStrategySet(this.inclusionHashingStrategy);
            boolean bl = false;
            it.addAll((Collection)this.inclusion);
            set = set2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"if (inclusionHashingStra\u2026 { it.addAll(inclusion) }");
        Set set3 = set;
        Set<Object> set4 = Collections.unmodifiableSet(set3);
        Intrinsics.checkNotNullExpressionValue(set4, (String)"unmodifiableSet(set)");
        return set4;
    }

    @Override
    @NotNull
    public ThreeStateCheckBox.State getInclusionState(@NotNull Object item2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        return this.inclusion.contains(item2) ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.NOT_SELECTED;
    }

    @Override
    public boolean isInclusionEmpty() {
        return this.inclusion.isEmpty();
    }

    @Override
    public void addInclusion(@NotNull Collection<? extends Object> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        if (this.inclusion.addAll(items2)) {
            this.fireInclusionChanged();
        }
    }

    @Override
    public void removeInclusion(@NotNull Collection<? extends Object> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        if (VcsUtil.removeAllFromSet(this.inclusion, items2)) {
            this.fireInclusionChanged();
        }
    }

    @Override
    public void setInclusion(@NotNull Collection<? extends Object> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        Set<Object> oldInclusion = this.getInclusion();
        this.inclusion.clear();
        this.inclusion.addAll(items2);
        if (!Intrinsics.areEqual(oldInclusion, this.inclusion)) {
            this.fireInclusionChanged();
        }
    }

    @Override
    public void retainInclusion(@NotNull Collection<? extends Object> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        if (this.inclusion.retainAll(items2)) {
            this.fireInclusionChanged();
        }
    }

    @Override
    public void clearInclusion() {
        if (!((Collection)this.inclusion).isEmpty()) {
            this.inclusion.clear();
            this.fireInclusionChanged();
        }
    }

    public DefaultInclusionModel() {
        this(null, 1, null);
    }
}

